/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.websphere;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.plugin.websphere.WebSphereProcess;
import org.hyperic.hq.plugin.websphere.WebsphereDetector;
import org.hyperic.hq.product.ProductPlugin;
import org.hyperic.hq.product.ProductPluginManager;
import org.hyperic.sigar.OperatingSystem;
import org.hyperic.sigar.win32.RegistryKey;
import org.hyperic.sigar.win32.Win32Exception;
import sun.net.www.ParseUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebsphereProductPlugin
extends ProductPlugin {
    public static boolean VALID_JVM = true;
    public static final String NAME = "websphere";
    public static final String SERVER_NAME = "WebSphere";
    public static final String SERVER_DESC = "Application Server";
    public static final String ADMIN_NAME = "Admin";
    public static final String THRPOOL_NAME = "Thread Pool";
    public static final String CONNPOOL_NAME = "Connection Pool";
    public static final String APP_NAME = "Application";
    public static final String WEBAPP_NAME = "Webapp";
    public static final String EJB_NAME = "EJB";
    public static final String SERVER_ADMIN_NAME = "WebSphere Admin";
    public static final String VERSION_50 = "5.0";
    public static final String PROP_INSTALL_ROOT = "was.install.root";
    public static final String PROP_ADMIN_HOST = "admin.host";
    public static final String PROP_ADMIN_PORT = "admin.port";
    public static final String PROP_USERNAME = "username";
    public static final String PROP_PASSWORD = "password";
    public static final String PROP_SERVER_NODE = "server.node";
    public static final String PROP_SERVER_NAME = "server.name";
    public static final String PROP_SERVER_PORT = "server.port";
    public static final String PROP_SERVER_CELL = "server.cell";
    public static final String PROP_THRPOOL_NAME = "thrpool";
    public static final String PROP_CONNPOOL_NAME = "connpool";
    public static final String PROP_APP_NAME = "app";
    public static final String PROP_WEBAPP_NAME = "webapp";
    public static final String PROP_EJB_NAME = "ejb";
    public static final String PROP_WEBAPP_DISPLAY_NAME = "webapp.display";
    public static final String PROP_WEBAPP_CONTEXT = "webapp.context";
    public static final String PROP_EJB_JNDI_NAME = "ejb.jndi";
    public static final String PROP_INSTALLPATH = "websphere.installpath";
    private static final String[] REG_VERSIONS = new String[]{"5.1.0.0", "5.0.0.0", "6.0.0.0", "6.1.0.0", "7.0.0.0", "8.0.0.0", "8.5.0.0"};
    private static Log log = LogFactory.getLog((String)"WebsphereProductPlugin");
    private static String REG_KEY;
    private static boolean hasSoapConfig;
    private static boolean isOSGi;
    private static boolean useExt;
    static boolean useJMX;
    private static String tmpdir;

    private static String getInstallPathFromJDK() {
        String res = null;
        if (VALID_JVM) {
            String javaHome = System.getProperty("java.home");
            File dir = new File(javaHome);
            do {
                if (!new File(dir, "profiles").exists()) {
                    dir = dir.getParentFile();
                    continue;
                }
                res = dir.getAbsolutePath();
            } while (res == null && dir.getParentFile() != null);
        }
        return res;
    }

    public static File getRegistryInstallPath() {
        List<File> dirs = WebsphereProductPlugin.getRegistryInstallPaths();
        if (dirs.size() == 0) {
            return null;
        }
        return dirs.get(0);
    }

    public static List<File> getRegistryInstallPaths() {
        ArrayList<File> dirs = new ArrayList<File>();
        try {
            RegistryKey key = RegistryKey.LocalMachine.openSubKey(REG_KEY);
            for (int i = 0; i < REG_VERSIONS.length; ++i) {
                String name = REG_VERSIONS[i];
                try {
                    RegistryKey ver = key.openSubKey(name);
                    String val = ver.getStringValue("InstallLocation");
                    if (val == null) continue;
                    dirs.add(new File(val.trim()));
                    continue;
                }
                catch (Win32Exception e) {
                    log.debug((Object)e, (Throwable)e);
                }
            }
        }
        catch (Win32Exception e) {
            log.debug((Object)e, (Throwable)e);
        }
        catch (UnsatisfiedLinkError e) {
            log.debug((Object)e, (Throwable)e);
        }
        return dirs;
    }

    private static String findInstallDir() {
        File path;
        String dir = null;
        String where = "unknown";
        if (WebsphereProductPlugin.isWin32() && (path = WebsphereProductPlugin.getRegistryInstallPath()) != null) {
            dir = path.getAbsolutePath();
            where = "registry";
        }
        if (dir == null) {
            dir = WebsphereDetector.getRunningInstallPath();
            if (dir != null) {
                where = "process table";
            } else {
                dir = WebsphereProductPlugin.getInstallPathFromJDK();
                if (dir != null) {
                    where = "JRE";
                }
            }
            if (dir == null) {
                String root = WebsphereProductPlugin.isWin32() ? "C:/Program Files" : "/opt";
                dir = root + "/IBM/WebSphere/AppServer";
                if (!new File(dir).isDirectory() && !new File(dir = root + "/WebSphere/AppServer").isDirectory()) {
                    dir = null;
                }
                where = "default location";
            }
        }
        if (dir == null) {
            log.debug((Object)"Unable to determine websphere.installpath");
            return null;
        }
        log.debug((Object)("websphere.installpath configured using " + where + " (" + dir + ")"));
        return dir;
    }

    public static boolean hasSoapConfig() {
        return hasSoapConfig;
    }

    public static boolean isOSGi() {
        return isOSGi;
    }

    private void addClassPath(List<String> path, String dir, String[] jars) {
        if (jars == null) {
            return;
        }
        for (int j = 0; j < jars.length; ++j) {
            if (!jars[j].endsWith(".jar")) continue;
            File f = new File(dir, jars[j]);
            log.debug((Object)("- Classpath += " + f));
            try {
                path.add(f.getCanonicalPath());
                continue;
            }
            catch (IOException ex) {
                path.add(f.getAbsolutePath());
            }
        }
    }

    private void addClassPathOSGi(List<String> path, String dir, String[] jars) {
        log.debug((Object)("Adding OSGi packages from " + dir));
        final HashMap<String, Boolean> wantedJars = new HashMap<String, Boolean>();
        for (int i = 0; i < jars.length; ++i) {
            wantedJars.put(jars[i], Boolean.TRUE);
        }
        String[] files = new File(dir).list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                int ix = name.indexOf(95);
                if (ix != -1) {
                    name = name.substring(0, ix);
                }
                return wantedJars.get(name) != null;
            }
        });
        this.addClassPath(path, dir, files);
    }

    private void copyToTmpAndAddClassPath(List<String> path, String dir, String[] jars) {
        final HashMap<String, Boolean> wantedJars = new HashMap<String, Boolean>();
        for (int i = 0; i < jars.length; ++i) {
            wantedJars.put(jars[i], Boolean.TRUE);
        }
        String[] files = new File(dir).list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                int ix = name.indexOf(95);
                if (ix != -1) {
                    name = name.substring(0, ix);
                }
                return wantedJars.get(name) != null;
            }
        });
        String tmp = dir;
        if (tmp.contains(" ")) {
            tmp = tmpdir;
            if (tmp.contains(" ")) {
                tmp = WebsphereProductPlugin.isWin32() ? "c:\\tmp" : "/tmp";
            }
            log.debug((Object)("Websphere install path (" + dir + ") contains a ' ', copying necesary jars to '" + tmp + "' (websphere.tmpdir)"));
        }
        for (String jar : jars) {
            try {
                WebsphereProductPlugin.copyFile(new File(dir, jar), new File(tmp, jar));
            }
            catch (IOException ex) {
                log.debug((Object)ex, (Throwable)ex);
            }
        }
        this.addClassPathOSGi(path, tmp, jars);
    }

    public static void copyFile(File sourceFile, File destFile) throws IOException {
        int len;
        log.debug((Object)("[copyFile] " + sourceFile.getCanonicalPath() + " => " + destFile.getCanonicalPath()));
        if (!destFile.exists()) {
            destFile.createNewFile();
        }
        FileInputStream in = new FileInputStream(sourceFile);
        FileOutputStream out = new FileOutputStream(destFile);
        byte[] buf = new byte[1024];
        while ((len = ((InputStream)in).read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File runtimeJarHack(File file) throws Exception {
        String tmp = System.getProperty("java.io.tmpdir");
        File newJar = new File(tmp, file.getName());
        if (newJar.exists()) {
            return newJar;
        }
        log.debug((Object)("Creating " + newJar));
        JarFile jar = new JarFile(file);
        JarOutputStream os = new JarOutputStream(new FileOutputStream(newJar));
        byte[] buffer = new byte[1024];
        try {
            Enumeration<JarEntry> e = jar.entries();
            while (e.hasMoreElements()) {
                int n;
                JarEntry entry = e.nextElement();
                if (entry.getName().startsWith("org/apache/commons/logging/")) continue;
                InputStream entryStream = jar.getInputStream(entry);
                os.putNextEntry(entry);
                while ((n = entryStream.read(buffer)) != -1) {
                    os.write(buffer, 0, n);
                }
                entryStream.close();
            }
        }
        finally {
            jar.close();
            os.close();
        }
        return newJar;
    }

    private void setExtDirs(String installDir) throws Exception {
        URLClassLoader loader = null;
        for (ClassLoader parent = ((Object)((Object)this)).getClass().getClassLoader().getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof URLClassLoader)) continue;
            loader = (URLClassLoader)parent;
        }
        log.debug((Object)("Using java.ext.dirs loader=" + loader));
        Method addURL = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
        addURL.setAccessible(true);
        String[] dirs = new String[]{"lib", "plugins", "runtimes"};
        for (int i = 0; i < dirs.length; ++i) {
            File dir = new File(installDir, dirs[i]);
            String[] jars = dir.list();
            if (jars == null) continue;
            for (int j = 0; j < jars.length; ++j) {
                File jar = new File(dir, jars[j]);
                if (this.isValidJar(jar)) {
                    log.debug((Object)("classpath += " + jar));
                    if (jar.getName().startsWith("com.ibm.ws.runtime_")) {
                        jar = this.runtimeJarHack(jar);
                    }
                    URL url = ParseUtil.fileToEncodedURL(jar);
                    addURL.invoke((Object)loader, url);
                    continue;
                }
                log.debug((Object)("jar '" + jars[j] + "' skipped"));
            }
        }
    }

    private boolean isValidJar(File jar) {
        return jar.getName().startsWith("com.ibm") && jar.getName().endsWith(".jar") && !jar.getName().contains("thinclient") && jar.isFile();
    }

    private String[] getClassPathOSGi(String installDir) {
        String[] lib;
        ArrayList<String> path = new ArrayList<String>();
        String v = WebsphereDetector.getComponentVersion(new File(installDir, "properties/version/WAS.product"));
        if (v.startsWith("6")) {
            lib = new String[]{"bootstrap.jar", "j2ee.jar", "launchclient.jar", "mail-impl.jar"};
            this.addClassPathOSGi(path, installDir + "/lib/", lib);
            String[] plugins = new String[]{"com.ibm.ws.bootstrap", "com.ibm.ws.emf", "com.ibm.ws.security.crypto", "com.ibm.ws.wccm", "org.eclipse.core.runtime", "org.eclipse.osgi", "com.ibm.ws.runtime"};
            this.addClassPathOSGi(path, installDir + "/plugins/", plugins);
            String[] runtimes = new String[]{"com.ibm.ws.admin.client"};
            this.addClassPathOSGi(path, installDir + "/runtimes/", runtimes);
        } else if (v.startsWith("7") || v.startsWith("8")) {
            lib = new String[]{"bootstrap.jar"};
            this.addClassPathOSGi(path, installDir + "/lib/", lib);
            String[] plugins = new String[]{"com.ibm.ffdc.jar", "com.ibm.ws.admin.core.jar", "com.ibm.ws.runtime.jar", "com.ibm.ws.emf.jar", "com.ibm.hpel.logging.jar", "org.eclipse.emf.ecore.jar", "org.eclipse.emf.common.jar", "com.ibm.ws.prereq.soap.jar", "com.ibm.ws.prereq.javamail.jar", "com.ibm.wsfp.main.jar", "javax.j2ee.management.jar"};
            this.addClassPathOSGi(path, installDir + "/plugins/", plugins);
            String[] jarToCopy = new String[]{"com.ibm.ws.security.crypto.jar"};
            this.copyToTmpAndAddClassPath(path, installDir + "/plugins/", jarToCopy);
        } else if (log.isDebugEnabled()) {
            log.error((Object)("Unknown version '" + v + "'"));
        }
        path.add("pdk/lib/mx4j/hq-jmx.jar");
        String[] cp = new String[path.size()];
        path.toArray(cp);
        return cp;
    }

    public String[] getClassPath(ProductPluginManager manager) {
        String prop;
        boolean testIBMJDK;
        OperatingSystem os = OperatingSystem.getInstance();
        boolean bl = testIBMJDK = os.getName().equals("Linux") || os.getName().equals("Win32");
        if (testIBMJDK) {
            boolean bl2 = VALID_JVM = System.getProperty("java.vm.vendor").toUpperCase().indexOf("IBM") != -1;
            if (!VALID_JVM) {
                log.debug((Object)("The WebSphere plugin needs a IBM JVM !!! (agent jvm=" + System.getProperty("java.vm.vendor") + ")"));
            }
            assert (VALID_JVM);
        }
        if (WebsphereProductPlugin.isWin32() && (REG_KEY = this.getPluginProperty(prop = "websphere.regkey")) == null) {
            log.error((Object)("Prop " + prop + "undefined"));
            return new String[0];
        }
        Properties managerProps = manager.getProperties();
        tmpdir = managerProps.getProperty("websphere.tmpdir", System.getProperty("java.io.tmpdir"));
        useJMX = Boolean.valueOf(managerProps.getProperty("websphere.usejmx", "true"));
        useExt = Boolean.valueOf(managerProps.getProperty("websphere.useext", "false"));
        String installDir = managerProps.getProperty(PROP_INSTALLPATH, WebsphereProductPlugin.findInstallDir());
        log.debug((Object)("websphere.tmpdir = " + tmpdir));
        log.debug((Object)("websphere.usejmx = " + useJMX));
        log.debug((Object)("websphere.useext = " + useExt));
        log.debug((Object)("websphere.installpath = " + installDir));
        if (installDir == null) {
            return new String[]{"pdk/lib/mx4j/hq-jmx.jar"};
        }
        String defaultCorbaConfig = installDir + File.separator + "properties" + File.separator + "sas.client.props";
        String corbaConfig = managerProps.getProperty("websphere.CORBA.ConfigURL", defaultCorbaConfig);
        System.setProperty("com.ibm.CORBA.ConfigURL", "file:" + corbaConfig);
        String defaultSoapProps = "properties" + File.separator + "soap.client.props";
        File installPropertiesDir = this.getInstallPropertiesDir(installDir, defaultSoapProps);
        String soapConfig = null;
        File soapConfigFile = null;
        if (installPropertiesDir != null && installPropertiesDir.exists()) {
            String defaultSoapConfig = installPropertiesDir.getPath();
            log.debug((Object)("default soap config is " + defaultSoapConfig));
            soapConfig = managerProps.getProperty("websphere.SOAP.ConfigURL", defaultSoapConfig);
            soapConfigFile = new File(soapConfig);
            hasSoapConfig = soapConfigFile.exists();
        }
        if (hasSoapConfig) {
            log.debug((Object)("Using soap properties: " + soapConfig));
            System.setProperty("com.ibm.SOAP.ConfigURL", "file:" + soapConfig);
        } else {
            log.debug((Object)("Unable to find soap.client.props in " + soapConfig));
        }
        isOSGi = new File(installDir, "/plugins").isDirectory();
        log.debug((Object)("isOSGi=" + isOSGi));
        File sslConfigFile = null;
        if (hasSoapConfig && soapConfigFile != null) {
            sslConfigFile = new File(soapConfigFile.getParent(), "ssl.client.props");
        }
        if (sslConfigFile != null && sslConfigFile.exists()) {
            log.debug((Object)("Using ssl properties: " + sslConfigFile));
            System.setProperty("com.ibm.SSL.ConfigURL", "file:" + sslConfigFile);
        } else if (isOSGi) {
            log.debug((Object)"Unable to find ssl.client.props");
        }
        System.setProperty(PROP_INSTALL_ROOT, installDir);
        if (isOSGi) {
            if (useExt) {
                try {
                    this.setExtDirs(installDir);
                    return new String[]{"pdk/lib/mx4j/hq-jmx.jar"};
                }
                catch (Exception e) {
                    log.error((Object)("setExtDirs: " + e), (Throwable)e);
                }
            }
            return this.getClassPathOSGi(installDir);
        }
        return new String[]{installDir + "/java/jre/lib/core.jar", installDir + "/java/jre/lib/ext/log.jar", installDir + "/lib/bootstrap.jar", installDir + "/lib/wssec.jar", installDir + "/lib/pmiclient.jar", installDir + "/lib/wasjmx.jar", installDir + "/lib/soap.jar", installDir + "/lib/sas.jar", installDir + "/lib/pmi.jar", installDir + "/lib/wsexception.jar", installDir + "/lib/jmxc.jar", installDir + "/lib/jmxx.jar", installDir + "/lib/jmxext.jar", installDir + "/lib/jflt.jar", installDir + "/lib/nls.jar", installDir + "/lib/ffdc.jar", installDir + "/lib/idl.jar", installDir + "/java/jre/lib/ext/ibmjsse.jar", installDir + "/java/jre/lib/ext/ibmjssefips-ob.jar", installDir + "/java/jre/lib/security.jar", installDir + "/java/jre/lib/ibmjsseprovider.jar", installDir + "/lib/perf.jar", installDir + "/lib/websphere.jar", installDir + "/lib/ujc.jar", installDir + "/lib/ns.jar", installDir + "/lib/iwsorb.jar", installDir + "/lib/ejbcontainer.jar", installDir + "/lib/jts.jar", installDir + "/lib/csicpi.jar", installDir + "/lib/repository.jar", installDir + "/lib/admin.jar", installDir + "/lib/xerces.jar", installDir + "/lib/j2ee.jar", installDir + "/lib/ras.jar", installDir + "/lib/utils.jar", installDir + "/java/jre/lib/ext/mail.jar", installDir + "/lib/management.jar", installDir + "/lib/mail-impl.jar", installDir + "/lib/emf.jar", installDir + "/lib/utils.jar", installDir + "/lib/runtime.jar", installDir + "/lib/classloader.jar", installDir + "/lib/security.jar", installDir + "/lib/wasproduct.jar", installDir + "/lib/pmij2ee.jar", installDir + "/java/jre/lib/ibmcertpathprovider.jar", installDir + "/java/jre/lib/ext/ibmjceprovider.jar", installDir + "/java/jre/lib/ext/ibmjcefips.jar", installDir + "/etc/tmx4jTransform.jar", "pdk/lib/mx4j/hq-jmx.jar"};
    }

    File getInstallPropertiesDir(String installDir, String lookFor) {
        File result = this.getInstallPropertiesDirForWAS61(lookFor);
        if (result == null) {
            result = this.getInstallPropertiesDirForWAS60(installDir, lookFor);
        }
        return result;
    }

    File getInstallPropertiesDirForWAS61(String lookFor) {
        File result = null;
        List servers = this.getServerProcessList();
        if (servers.size() != 0) {
            for (WebSphereProcess process : servers) {
                File candidate;
                if (process.getServerRoot() == null || !(candidate = new File(process.getServerRoot(), lookFor)).exists()) continue;
                log.debug((Object)("Getting WAS properties from profile under server.root: " + candidate));
                result = candidate;
                break;
            }
        }
        return result;
    }

    List getServerProcessList() {
        return WebsphereDetector.getServerProcessList();
    }

    File getInstallPropertiesDirForWAS60(String installDir, String lookFor) {
        File result = null;
        File profileDir = new File(installDir + File.separator + "profiles");
        if (profileDir.exists()) {
            String[] profiles;
            File candidate;
            File candidateDir = new File(profileDir + File.separator + "default");
            if (candidateDir.exists() && (candidate = new File(candidateDir, lookFor)).exists()) {
                log.debug((Object)("Getting WAS properties from default profile location: " + candidate));
                result = candidate;
            }
            if (result == null && profileDir.isDirectory() && (profiles = profileDir.list()) != null) {
                for (int i = 0; i < profiles.length; ++i) {
                    File candidate2;
                    candidateDir = new File(profileDir, profiles[i]);
                    if (!candidateDir.exists() || !(candidate2 = new File(candidateDir, lookFor)).exists()) continue;
                    log.debug((Object)("Getting WAS properties from profile non-default location: " + candidate2));
                    result = candidate2;
                    break;
                }
            }
        }
        return result;
    }

    static {
        hasSoapConfig = false;
        isOSGi = false;
        useExt = false;
        useJMX = true;
    }
}

