/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.websphere;

import org.hyperic.hq.plugin.websphere.WebsphereTraceLogParser;
import org.hyperic.hq.product.LogFileTailPlugin;
import org.hyperic.hq.product.TrackEvent;
import org.hyperic.sigar.FileInfo;

public class WebsphereTraceLogFileTrackPlugin
extends LogFileTailPlugin {
    private static final String[] LOG_LEVELS = new String[]{"X,T,F", "W", "A,I", "E,D,<,>"};
    private WebsphereTraceLogParser parser = null;

    private WebsphereTraceLogParser getParser() {
        if (this.parser == null) {
            this.parser = new WebsphereTraceLogParser();
        }
        return this.parser;
    }

    public String[] getLogLevelAliases() {
        return LOG_LEVELS;
    }

    public TrackEvent processLine(FileInfo info, String line) {
        WebsphereTraceLogParser.Entry entry;
        try {
            entry = this.getParser().parse(line);
            if (entry == null) {
                return null;
            }
        }
        catch (Exception e) {
            this.getLog().error((Object)("Error parsing line: '" + line + "'"), (Throwable)e);
            return null;
        }
        return this.newTrackEvent(entry.time, entry.level, entry.subsystem, entry.message);
    }
}

