/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.mysql_stats;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.product.AutoServerDetector;
import org.hyperic.hq.product.GenericPlugin;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.ServerDetector;
import org.hyperic.hq.product.ServerResource;
import org.hyperic.hq.product.ServiceResource;
import org.hyperic.util.config.ConfigResponse;
import org.hyperic.util.exec.Execute;
import org.hyperic.util.exec.ExecuteStreamHandler;
import org.hyperic.util.exec.PumpStreamHandler;
import org.hyperic.util.jdbc.DBUtil;

public class MySqlServerDetector
extends ServerDetector
implements AutoServerDetector {
    private static final String _logCtx = MySqlServerDetector.class.getName();
    private final Log _log = LogFactory.getLog((String)_logCtx);
    private Connection _conn;
    private static final List _ptqlQueries = new ArrayList();
    private String _validQuery;
    private static final String VERSION_4_0_x = "4.0.x";
    private static final String VERSION_4_1_x = "4.1.x";
    private static final String VERSION_5_0_x = "5.0.x";
    private static final String VERSION_5_1_x = "5.1.x";
    private static final String VERSION_5_5_x = "5.5.x";
    private static final String TABLE_SERVICE = "Table";
    private static final String SLAVE_STATUS = "Slave Status";
    private static final String SHOW_SLAVE_STATUS = "Show Slave Status";
    private static final Pattern REGEX_VER_4_0;
    private static final Pattern REGEX_VER_4_1;
    private static final Pattern REGEX_VER_5_0;
    private static final Pattern REGEX_VER_5_1;
    private static final Pattern REGEX_VER_5_5;

    public List getServerResources(ConfigResponse platformConfig) throws PluginException {
        ArrayList servers = new ArrayList();
        Map paths = this.getServerProcessMap();
        for (Map.Entry entry : paths.entrySet()) {
            Long pid = (Long)entry.getKey();
            String dir = (String)entry.getValue();
            this._log.debug((Object)("pid=" + pid + ", dir=" + dir));
            String[] args = paths.size() == 1 ? new String[]{} : MySqlServerDetector.getProcArgs((long)pid);
            List found = this.getServerList(dir, args, pid);
            if (found.isEmpty()) continue;
            servers.addAll(found);
        }
        return servers;
    }

    protected List discoverServices(ConfigResponse serverConfig) throws PluginException {
        ArrayList rtn = new ArrayList();
        String url = serverConfig.getValue("jdbcUrl");
        String user = serverConfig.getValue("jdbcUser");
        String pass = serverConfig.getValue("jdbcPassword");
        pass = pass == null ? "" : pass;
        pass = pass.matches("^\\s*$") ? "" : pass;
        try {
            this._conn = MySqlServerDetector.getConnection(url, user, pass, serverConfig);
            this.setTableServices(rtn, serverConfig);
            this.setSlaveStatusService(rtn, serverConfig);
            this.setMasterSlaveStatusService(rtn, serverConfig);
        }
        catch (SQLException e) {
            throw new PluginException((Throwable)e);
        }
        finally {
            DBUtil.closeConnection((Object)_logCtx, (Connection)this._conn);
        }
        return rtn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTableServices(List services, ConfigResponse serverConfig) {
        String tableRegex = serverConfig.getValue("tableRegex", "");
        if (tableRegex.trim().length() <= 0) {
            this._log.debug((Object)"Table config is blank, skipping table AI");
            return;
        }
        this._log.debug((Object)("Discovering tables with regex " + tableRegex));
        Pattern regex = Pattern.compile(tableRegex, 2);
        Statement stmt = null;
        ResultSet rs = null;
        String sql = "SELECT table_name, table_schema FROM information_schema.tables WHERE lower(table_schema) != 'information_schema' AND engine is not null";
        try {
            stmt = this._conn.createStatement();
            rs = stmt.executeQuery("SELECT table_name, table_schema FROM information_schema.tables WHERE lower(table_schema) != 'information_schema' AND engine is not null");
            int tableNameCol = rs.findColumn("table_name");
            int dbNameCol = rs.findColumn("table_schema");
            boolean debug = this._log.isDebugEnabled();
            while (rs.next()) {
                String table = rs.getString(tableNameCol);
                String dbName = rs.getString(dbNameCol);
                if (!regex.matcher(table).find()) continue;
                if (debug) {
                    this._log.debug((Object)("Adding table " + table));
                }
                ServiceResource service = new ServiceResource();
                service.setType((GenericPlugin)this, TABLE_SERVICE);
                service.setServiceName(dbName + "/" + table);
                ConfigResponse productConfig = new ConfigResponse();
                productConfig.setValue("table", table);
                productConfig.setValue("database", dbName);
                service.setProductConfig(productConfig);
                service.setMeasurementConfig(serverConfig);
                service.setControlConfig(productConfig);
                services.add(service);
            }
        }
        catch (SQLException e) {
            try {
                this._log.warn((Object)e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                DBUtil.closeJDBCObjects((Object)_logCtx, null, (Statement)stmt, rs);
                throw throwable;
            }
            DBUtil.closeJDBCObjects((Object)_logCtx, null, (Statement)stmt, (ResultSet)rs);
        }
        DBUtil.closeJDBCObjects((Object)_logCtx, null, (Statement)stmt, (ResultSet)rs);
    }

    private static final Connection getConnection(String url, String user, String pass, ConfigResponse config) throws SQLException {
        String d = "com.mysql.jdbc.Driver";
        try {
            Driver driver = (Driver)Class.forName("com.mysql.jdbc.Driver").newInstance();
            Properties props = new Properties();
            pass = pass == null ? "" : pass;
            props.put("user", user);
            props.put("password", pass);
            return driver.connect(url, props);
        }
        catch (InstantiationException e) {
            throw new SQLException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new SQLException(e.getMessage());
        }
        catch (ClassNotFoundException e) {
            throw new SQLException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void setSlaveStatusService(List services, ConfigResponse serverConfig) {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this._conn.createStatement();
            rs = stmt.executeQuery(SHOW_SLAVE_STATUS.toLowerCase());
            if (rs.next()) {
                ServiceResource service = new ServiceResource();
                service.setType((GenericPlugin)this, SHOW_SLAVE_STATUS);
                service.setServiceName(SHOW_SLAVE_STATUS);
                ConfigResponse productConfig = new ConfigResponse();
                service.setProductConfig(productConfig);
                service.setMeasurementConfig(serverConfig);
                services.add(service);
            }
        }
        catch (SQLException e) {
            DBUtil.closeJDBCObjects((Object)_logCtx, null, (Statement)stmt, rs);
            return;
            catch (Throwable throwable) {
                DBUtil.closeJDBCObjects((Object)_logCtx, null, (Statement)stmt, rs);
                throw throwable;
            }
        }
        DBUtil.closeJDBCObjects((Object)_logCtx, null, (Statement)stmt, (ResultSet)rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void setMasterSlaveStatusService(List services, ConfigResponse serverConfig) {
        String url = serverConfig.getValue("jdbcUrl");
        String user = serverConfig.getValue("jdbcUser");
        String pass = serverConfig.getValue("jdbcPassword");
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            conn = MySqlServerDetector.getConnection(url, user, pass, serverConfig);
            stmt = conn.createStatement();
            rs = stmt.executeQuery("show full processlist");
            int userCol = rs.findColumn("User");
            int addrCol = rs.findColumn("Host");
            while (rs.next()) {
                String pUser = rs.getString(userCol);
                if (!pUser.equalsIgnoreCase("slave")) continue;
                String addr = rs.getString(addrCol);
                ServiceResource service = new ServiceResource();
                service.setType((GenericPlugin)this, SLAVE_STATUS);
                service.setServiceName("Slave Status " + addr);
                ConfigResponse productConfig = new ConfigResponse();
                service.setProductConfig(productConfig);
                ConfigResponse replConfig = new ConfigResponse();
                replConfig.setValue("slaveAddress", addr);
                service.setMeasurementConfig(replConfig);
                services.add(service);
            }
        }
        catch (SQLException e) {
            DBUtil.closeJDBCObjects((Object)_logCtx, (Connection)conn, stmt, rs);
            return;
            catch (Throwable throwable) {
                DBUtil.closeJDBCObjects((Object)_logCtx, (Connection)conn, stmt, rs);
                throw throwable;
            }
        }
        DBUtil.closeJDBCObjects((Object)_logCtx, (Connection)conn, (Statement)stmt, (ResultSet)rs);
    }

    private Map getServerProcessMap() {
        HashMap<Long, String> servers = new HashMap<Long, String>();
        ArrayList<long[]> pidArray = new ArrayList<long[]>();
        for (String ptql : _ptqlQueries) {
            long[] pids = MySqlServerDetector.getPids((String)ptql);
            if (pids.length <= 0) continue;
            this._validQuery = ptql;
            pidArray.add(pids);
        }
        for (long[] pids : pidArray) {
            for (int i = 0; i < pids.length; ++i) {
                File binary;
                String exe = MySqlServerDetector.getProcExe((long)pids[i]);
                this._log.debug((Object)("exe=" + exe + " pid=" + pids[i]));
                if (exe == null || !(binary = new File(exe)).isAbsolute()) continue;
                servers.put(new Long(pids[i]), binary.getAbsolutePath());
            }
        }
        return servers;
    }

    private List getServerList(String path, String[] args, long pid) throws PluginException {
        ArrayList<ServerResource> servers = new ArrayList<ServerResource>();
        String installdir = MySqlServerDetector.getParentDir((String)path, (int)2);
        String version = this.getVersion(path, "--version");
        if (version == null) {
            this._log.debug((Object)"Version returned null, looking for version in --version output. Trying --help");
            version = this.getVersion(path, "--help");
        }
        if (!this.getTypeInfo().getVersion().equals(version)) {
            return Collections.EMPTY_LIST;
        }
        ServerResource server = this.createServerResource(installdir);
        ConfigResponse cprop = new ConfigResponse();
        cprop.setValue("version", version);
        server.setCustomProperties(cprop);
        ConfigResponse productConfig = new ConfigResponse();
        productConfig.setValue("process.query", this._validQuery + this.getPtqlArgs(args));
        this.populateListeningPorts(pid, productConfig, true);
        this.setProductConfig(server, productConfig);
        this.setMeasurementConfig(server, new ConfigResponse());
        server.setName(MySqlServerDetector.getPlatformName() + " MySQL Stats " + version);
        servers.add(server);
        return servers;
    }

    private String getPtqlArgs(String[] args) {
        StringBuffer rtn = new StringBuffer();
        for (int i = 0; i < args.length; ++i) {
            String[] toks;
            if (args[i] == null || (toks = args[i].split("=", 2)).length < 2) continue;
            rtn.append(",Args.*.ct=" + toks[1]);
        }
        return rtn.toString();
    }

    private String getVersion(String executable, String arg) {
        try {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            Execute exec = new Execute((ExecuteStreamHandler)new PumpStreamHandler((OutputStream)output));
            exec.setCommandline(new String[]{executable, arg});
            int res = exec.execute();
            if (res != 0) {
                return null;
            }
            String out = output.toString();
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("Version detected from output of " + executable + " " + arg + ":\n" + out));
            }
            if (REGEX_VER_4_0.matcher(out).find()) {
                return VERSION_4_0_x;
            }
            if (REGEX_VER_4_1.matcher(out).find()) {
                return VERSION_4_1_x;
            }
            if (REGEX_VER_5_0.matcher(out).find()) {
                return VERSION_5_0_x;
            }
            if (REGEX_VER_5_1.matcher(out).find()) {
                return VERSION_5_1_x;
            }
            if (REGEX_VER_5_5.matcher(out).find()) {
                return VERSION_5_5_x;
            }
        }
        catch (Exception e) {
            this._log.warn((Object)("Could not get the version of mysql: " + e.getMessage()), (Throwable)e);
        }
        return null;
    }

    private void populateListeningPorts(long pid, ConfigResponse productConfig, boolean b) {
        try {
            Class<?> du = Class.forName("org.hyperic.hq.product.DetectionUtil");
            Method plp = du.getMethod("populateListeningPorts", Long.TYPE, ConfigResponse.class, Boolean.TYPE);
            plp.invoke(null, pid, productConfig, b);
        }
        catch (ClassNotFoundException ex) {
            this._log.debug((Object)"[populateListeningPorts] Class 'DetectionUtil' not found", (Throwable)ex);
        }
        catch (NoSuchMethodException ex) {
            this._log.debug((Object)"[populateListeningPorts] Method 'populateListeningPorts' not found", (Throwable)ex);
        }
        catch (Exception ex) {
            this._log.debug((Object)"[populateListeningPorts] Problem with Method 'populateListeningPorts'", (Throwable)ex);
        }
    }

    static {
        _ptqlQueries.add("State.Name.eq=mysqld");
        if (MySqlServerDetector.isWin32()) {
            _ptqlQueries.add("State.Name.eq=mysqld-nt");
        }
        REGEX_VER_4_0 = Pattern.compile("Ver 4.0.[0-9]+");
        REGEX_VER_4_1 = Pattern.compile("Ver 4.1.[0-9]+");
        REGEX_VER_5_0 = Pattern.compile("Ver 5.0.[0-9]+");
        REGEX_VER_5_1 = Pattern.compile("Ver 5.1.[0-9]+");
        REGEX_VER_5_5 = Pattern.compile("Ver 5.5.[0-9]+");
    }
}

