/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.mysql_stats;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.product.JDBCMeasurementPlugin;
import org.hyperic.hq.product.JDBCQueryCache;
import org.hyperic.hq.product.JDBCQueryCacheException;
import org.hyperic.hq.product.Metric;
import org.hyperic.hq.product.MetricNotFoundException;
import org.hyperic.hq.product.MetricUnreachableException;
import org.hyperic.hq.product.MetricValue;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.TypeInfo;
import org.hyperic.util.TimeUtil;
import org.hyperic.util.config.ConfigResponse;
import org.hyperic.util.config.ConfigSchema;
import org.hyperic.util.jdbc.DBUtil;

public class MySqlStatsMeasurementPlugin
extends JDBCMeasurementPlugin {
    private static final String _logCtx = MySqlStatsMeasurementPlugin.class.getName();
    private final Log _log = LogFactory.getLog(MySqlStatsMeasurementPlugin.class);
    static final String PROP_JDBC_DRIVER = "DEFAULT_DRIVER";
    static final String DEFAULT_DRIVER = "com.mysql.jdbc.Driver";
    private static final String AVAIL_SELECT = "select 1";
    private static final String SHOW_DATABASES = "show databases";
    private static final String SLAVE_STATUS = "slavestatus";
    private static final String TABLE_SERVICE = "type=table";
    private static final String SHOW_SLAVE_STATUS = "show slave status";
    private static final String SHOW_GLOBAL_STATUS = "show /*!50002 global */ status";
    private static final String BYTES_BEHIND_MASTER = "Bytes_Behind_Master";
    private static final String SECONDS_BEHIND_MASTER = "Seconds_Behind_Master";
    private static final String LOG_FILES_BEHIND_MASTER = "Log_Files_Behind_Master";
    private static final String SLAVE_SQL_RUNNING = "Slave_SQL_Running";
    private String _driver;
    private static final int CACHE_TIMEOUT = Integer.parseInt(System.getProperty("mysql_stats.cache.timeout", "10000"));
    private Map<String, Map<String, JDBCQueryCache>> _urlQueryCacheMap = new HashMap<String, Map<String, JDBCQueryCache>>();
    private final Map<String, JDBCQueryCache> _tableStatusCacheMap = new HashMap<String, JDBCQueryCache>();
    private static final int TIMEOUT_VALUE = Integer.parseInt(System.getProperty("mysql_stats.jdbc.timeout", "60000"));
    private int _consecutiveErrors = 0;
    private static final int MAX_ERRORS = Integer.parseInt(System.getProperty("mysql_stats.max_errors", "3"));

    protected double getQueryValue(Metric metric) throws MetricNotFoundException, PluginException, MetricUnreachableException {
        String objectName = metric.getObjectName().toLowerCase();
        String alias = metric.getAttributeName();
        boolean sqlException = false;
        try {
            this.setDriver(metric);
            if (objectName.indexOf(SHOW_GLOBAL_STATUS) != -1) {
                double d = this.getGlobalStatusMetric(metric);
                return d;
            }
            if (objectName.indexOf(SHOW_SLAVE_STATUS) != -1) {
                double d = this.getSlaveStatusMetric(metric);
                return d;
            }
            if (objectName.indexOf(SLAVE_STATUS) != -1) {
                double d = this.getMasterSlaveStatusMetric(metric);
                return d;
            }
            if (objectName.indexOf(SHOW_DATABASES) != -1) {
                double d = this.getNumberOfDatabases(metric);
                return d;
            }
            if (objectName.indexOf(TABLE_SERVICE) != -1) {
                double d = this.getTableMetric(metric);
                return d;
            }
        }
        catch (MetricUnreachableException e) {
            throw e;
        }
        catch (SQLException e) {
            sqlException = true;
            this._log.debug((Object)e, (Throwable)e);
            if (metric.isAvail()) {
                double d = 0.0;
                return d;
            }
            throw new MetricNotFoundException("Service " + objectName + ":" + alias + " not found: " + e.getMessage());
        }
        catch (Exception e) {
            this._log.debug((Object)e, (Throwable)e);
            if (metric.isAvail()) {
                double d = 0.0;
                return d;
            }
            throw new MetricNotFoundException("Service " + objectName + ":" + alias + " not found: " + e.getMessage());
        }
        finally {
            this.setErrorState(sqlException);
        }
        throw new MetricNotFoundException("Service " + objectName + ":" + alias + " not found");
    }

    private void setErrorState(boolean sqlExeceptionOccured) {
        if (sqlExeceptionOccured) {
            ++this._consecutiveErrors;
            if (this._consecutiveErrors > MAX_ERRORS) {
                this.setCacheExpireTime(System.currentTimeMillis() + 60000L);
            }
        } else {
            this._consecutiveErrors = 0;
        }
    }

    private void setCacheExpireTime(long expireTime) {
        this._log.info((Object)("Received more than " + MAX_ERRORS + " SQLExceptions, " + "disabling all " + this._tableStatusCacheMap.size() + " JDBCQueryCaches until " + TimeUtil.toString((long)expireTime)));
        for (JDBCQueryCache cache : this._tableStatusCacheMap.values()) {
            cache.setExpireTime(expireTime);
            cache.clearCache();
        }
    }

    private double getTableMetric(Metric metric) throws NumberFormatException, SQLException, JDBCQueryCacheException {
        String table = metric.getObjectProperty("table");
        String dbname = metric.getObjectProperty("database");
        String jdbcUrl = metric.getObjectProperty("jdbcUrl");
        String cacheKey = jdbcUrl + "-" + table;
        String alias = metric.getAttributeName();
        JDBCQueryCache tableCache = this._tableStatusCacheMap.get(cacheKey);
        if (tableCache == null) {
            String sql = new StringBuffer().append("SELECT * FROM information_schema.tables").append(" WHERE lower(table_name) = '").append(table.toLowerCase()).append('\'').append(" AND lower(table_schema) = '").append(dbname.toLowerCase()).append('\'').append(" AND engine is not null").toString();
            tableCache = new JDBCQueryCache(sql, "table_name", (long)CACHE_TIMEOUT);
            this._tableStatusCacheMap.put(cacheKey, tableCache);
        }
        if (metric.isAvail()) {
            alias = "TABLE_ROWS";
        }
        Connection conn = this.getCachedConnection(metric);
        Object cachedVal = null;
        cachedVal = tableCache.get(conn, table, alias);
        if (cachedVal == null) {
            if (metric.isAvail()) {
                return 0.0;
            }
            String msg = "Could not get metric for table " + table;
            throw new SQLException(msg);
        }
        Double val = Double.valueOf(cachedVal.toString());
        if (metric.isAvail()) {
            return 1.0;
        }
        return val;
    }

    public ConfigSchema getConfigSchema(TypeInfo info, ConfigResponse config) {
        return new ConfigSchema();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double getMasterSlaveStatusMetric(Metric metric) throws SQLException, MetricUnreachableException {
        Connection conn = this.getCachedConnection(metric);
        Statement stmt = null;
        ResultSet rs = null;
        boolean isAvail = metric.isAvail();
        String slaveAddr = metric.getObjectProperty("slaveAddress");
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery("show full processlist");
            int userCol = rs.findColumn("User");
            int addrCol = rs.findColumn("Host");
            int timeCol = rs.findColumn("Time");
            while (rs.next()) {
                String pUser = rs.getString(userCol);
                String addr = rs.getString(addrCol);
                if (!pUser.equalsIgnoreCase("slave") && !addr.equals(slaveAddr)) continue;
                if (isAvail) {
                    double d = 1.0;
                    return d;
                }
                double d = rs.getDouble(timeCol);
                return d;
            }
        }
        finally {
            DBUtil.closeJDBCObjects((Object)_logCtx, null, (Statement)stmt, (ResultSet)rs);
        }
        if (isAvail) {
            return 0.0;
        }
        throw new MetricUnreachableException("Cannot retrieve mysql process time for slave " + slaveAddr);
    }

    private double getGlobalStatusMetric(Metric metric) throws NumberFormatException, SQLException, JDBCQueryCacheException {
        JDBCQueryCache globalStatus = this.getQueryCache(metric, SHOW_GLOBAL_STATUS);
        String valColumn = metric.getObjectProperty("value");
        String alias = metric.getAttributeName();
        if (metric.isAvail()) {
            return this.getAvailability(metric).getValue();
        }
        Connection conn = this.getCachedConnection(metric);
        Double val = Double.valueOf(globalStatus.get(conn, alias, valColumn).toString());
        return val;
    }

    private double getSlaveStatusMetric(Metric metric) throws NumberFormatException, MetricUnreachableException, SQLException, JDBCQueryCacheException, MetricNotFoundException {
        String valColumn = metric.getObjectProperty("value");
        String alias = metric.getAttributeName();
        JDBCQueryCache replStatus = this.getQueryCache(metric, SHOW_SLAVE_STATUS);
        if (alias.equalsIgnoreCase(BYTES_BEHIND_MASTER)) {
            double tmp = this.getBytesBehindMaster(metric);
            return tmp >= 0.0 ? tmp : 0.0;
        }
        if (alias.equalsIgnoreCase(LOG_FILES_BEHIND_MASTER)) {
            return this.getLogFilesBehindMaster(metric);
        }
        if (alias.equalsIgnoreCase(SECONDS_BEHIND_MASTER)) {
            Connection conn = this.getCachedConnection(metric);
            Double val = Double.valueOf(replStatus.getOnlyRow(conn, valColumn).toString());
            if (val == null) {
                throw new MetricNotFoundException("query for Seconds_Behind_Master returned null");
            }
            return val;
        }
        if (metric.isAvail()) {
            Connection conn = this.getCachedConnection(metric);
            String s = replStatus.getOnlyRow(conn, SLAVE_SQL_RUNNING).toString();
            return s.equalsIgnoreCase("yes") ? 1.0 : 0.0;
        }
        Connection conn = this.getCachedConnection(metric);
        String s = replStatus.getOnlyRow(conn, valColumn).toString();
        Double val = null;
        val = s.equalsIgnoreCase("yes") ? new Double(1.0) : (s.equalsIgnoreCase("no") ? new Double(0.0) : Double.valueOf(s));
        return val;
    }

    private double getBytesBehindMaster(Metric metric) throws NumberFormatException, SQLException, JDBCQueryCacheException, MetricUnreachableException {
        Connection conn = this.getCachedConnection(metric);
        JDBCQueryCache replStatus = this.getQueryCache(metric, SHOW_SLAVE_STATUS);
        double slaveLogPos = -1.0;
        try {
            slaveLogPos = Double.valueOf(replStatus.getOnlyRow(conn, "Exec_Master_Log_Pos").toString());
        }
        catch (Exception e) {
            slaveLogPos = Double.valueOf(replStatus.getOnlyRow(conn, "Exec_master_log_pos").toString());
        }
        double masterLogPos = Double.valueOf(replStatus.getOnlyRow(conn, "Read_Master_Log_Pos").toString());
        return masterLogPos - slaveLogPos;
    }

    private double getLogFilesBehindMaster(Metric metric) throws SQLException, JDBCQueryCacheException {
        String slaveLogFile;
        Connection conn = this.getCachedConnection(metric);
        JDBCQueryCache replStatus = this.getQueryCache(metric, SHOW_SLAVE_STATUS);
        String masterLogFile = replStatus.getOnlyRow(conn, "Master_Log_File").toString();
        if (masterLogFile.equals(slaveLogFile = replStatus.getOnlyRow(conn, "Relay_Master_Log_File").toString())) {
            return 0.0;
        }
        String[] toks = masterLogFile.split("\\.");
        int masterNum = Integer.valueOf(toks[1]);
        toks = slaveLogFile.split("\\.");
        int slaveNum = Integer.valueOf(toks[1]);
        return masterNum - slaveNum;
    }

    private JDBCQueryCache getQueryCache(Metric metric, String query) {
        JDBCQueryCache queryCache;
        String jdbcUrl = metric.getProperties().getProperty("jdbcUrl");
        String keyColumn = metric.getObjectProperty("key");
        if (!this._urlQueryCacheMap.containsKey(jdbcUrl)) {
            HashMap<String, JDBCQueryCache> queryMap = new HashMap<String, JDBCQueryCache>();
            queryCache = new JDBCQueryCache(query, keyColumn, (long)CACHE_TIMEOUT);
            queryMap.put(query, queryCache);
            this._urlQueryCacheMap.put(jdbcUrl, queryMap);
        } else if (!this._urlQueryCacheMap.get(jdbcUrl).containsKey(query)) {
            queryCache = new JDBCQueryCache(query, keyColumn, (long)CACHE_TIMEOUT);
            this._urlQueryCacheMap.get(jdbcUrl).put(query, queryCache);
        } else {
            queryCache = this._urlQueryCacheMap.get(jdbcUrl).get(query);
        }
        return queryCache;
    }

    protected Connection getCachedConnection(Metric metric) throws SQLException {
        Connection conn = super.getCachedConnection(metric);
        boolean autocommit = conn.getAutoCommit();
        if (!autocommit) {
            conn.setAutoCommit(true);
        }
        return conn;
    }

    private double getNumberOfDatabases(Metric metric) throws MetricUnreachableException {
        double d;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            Connection conn = this.getCachedConnection(metric);
            stmt = conn.createStatement();
            rs = stmt.executeQuery(SHOW_DATABASES);
            double rtn = 0.0;
            while (rs.next()) {
                rtn += 1.0;
            }
            d = rtn;
        }
        catch (Exception e) {
            try {
                throw new MetricUnreachableException(e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                DBUtil.closeJDBCObjects((Object)_logCtx, null, (Statement)stmt, rs);
                throw throwable;
            }
        }
        DBUtil.closeJDBCObjects((Object)_logCtx, null, (Statement)stmt, (ResultSet)rs);
        return d;
    }

    private void setDriver(Metric metric) {
        if (this._driver == null) {
            Properties p = metric.getObjectProperties();
            this._driver = p.getProperty(PROP_JDBC_DRIVER, DEFAULT_DRIVER);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private MetricValue getAvailability(Metric metric) {
        MetricValue metricValue;
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = this.getCachedConnection(metric);
            stmt = conn.createStatement();
            stmt.executeQuery(AVAIL_SELECT).close();
            metricValue = new MetricValue(1.0);
        }
        catch (SQLException e) {
            try {
                this._log.debug((Object)e, (Throwable)e);
            }
            catch (Throwable throwable) {
                DBUtil.closeStatement((Object)_logCtx, stmt);
                throw throwable;
            }
            DBUtil.closeStatement((Object)_logCtx, (Statement)stmt);
            return new MetricValue(0.0);
        }
        DBUtil.closeStatement((Object)_logCtx, (Statement)stmt);
        return metricValue;
    }

    protected Connection getConnection(String url, String user, String password) throws SQLException {
        try {
            password = password == null ? "" : password;
            password = password.matches("^\\s*$") ? "" : password;
            Driver driver = (Driver)Class.forName(this._driver).newInstance();
            Properties props = new Properties();
            props.put("user", user);
            props.put("password", password);
            return driver.connect(this.getJdbcUrl(url), props);
        }
        catch (InstantiationException e) {
            throw new SQLException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new SQLException(e.getMessage());
        }
        catch (ClassNotFoundException e) {
            throw new SQLException(e.getMessage());
        }
    }

    private String getJdbcUrl(String url) {
        if (url == null) {
            return url;
        }
        if (url.indexOf(63) > 0) {
            return url + "&socketTimeout=" + TIMEOUT_VALUE + "&connectTimeout=" + TIMEOUT_VALUE + "&autoReconnect=true";
        }
        return url + "?socketTimeout=" + TIMEOUT_VALUE + "&connectTimeout=" + TIMEOUT_VALUE + "&autoReconnect=true";
    }

    protected String getDefaultURL() {
        return null;
    }

    protected String getQuery(Metric jdsn) {
        return null;
    }

    protected void initQueries() {
    }

    protected void getDriver() throws ClassNotFoundException {
    }
}

