/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.nimbus;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Map;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.nimbus.EffectUtils;
import javax.swing.plaf.nimbus.ImageCache;
import javax.swing.plaf.nimbus.LoweredBorder;
import javax.swing.plaf.nimbus.NimbusDefaults;
import javax.swing.plaf.nimbus.NimbusStyle;
import javax.swing.plaf.nimbus.TableScrollPaneCorner;
import javax.swing.plaf.nimbus.ToolBarSeparatorPainter;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.plaf.synth.SynthStyleFactory;
import sun.security.action.GetPropertyAction;
import sun.swing.ImageIconUIResource;
import sun.swing.plaf.GTKKeybindings;
import sun.swing.plaf.WindowsKeybindings;
import sun.swing.plaf.synth.SynthIcon;

public class NimbusLookAndFeel
extends SynthLookAndFeel {
    private static final String[] COMPONENT_KEYS = new String[]{"ArrowButton", "Button", "CheckBox", "CheckBoxMenuItem", "ColorChooser", "ComboBox", "DesktopPane", "DesktopIcon", "EditorPane", "FileChooser", "FormattedTextField", "InternalFrame", "InternalFrameTitlePane", "Label", "List", "Menu", "MenuBar", "MenuItem", "OptionPane", "Panel", "PasswordField", "PopupMenu", "PopupMenuSeparator", "ProgressBar", "RadioButton", "RadioButtonMenuItem", "RootPane", "ScrollBar", "ScrollBarTrack", "ScrollBarThumb", "ScrollPane", "Separator", "Slider", "SliderTrack", "SliderThumb", "Spinner", "SplitPane", "TabbedPane", "Table", "TableHeader", "TextArea", "TextField", "TextPane", "ToggleButton", "ToolBar", "ToolTip", "Tree", "Viewport"};
    private NimbusDefaults defaults;
    private UIDefaults uiDefaults;
    private DefaultsListener defaultsListener = new DefaultsListener();
    private Map<String, Map<String, Object>> compiledDefaults = null;
    private boolean defaultListenerAdded = false;

    public NimbusLookAndFeel() {
        this.defaults = new NimbusDefaults();
    }

    @Override
    public void initialize() {
        super.initialize();
        this.defaults.initialize();
        NimbusLookAndFeel.setStyleFactory(new SynthStyleFactory(){

            @Override
            public SynthStyle getStyle(JComponent jComponent, Region region) {
                return NimbusLookAndFeel.this.defaults.getStyle(jComponent, region);
            }
        });
    }

    @Override
    public void uninitialize() {
        super.uninitialize();
        this.defaults.uninitialize();
        ImageCache.getInstance().flush();
        UIManager.getDefaults().removePropertyChangeListener(this.defaultsListener);
    }

    @Override
    public UIDefaults getDefaults() {
        if (this.uiDefaults == null) {
            String string = this.getSystemProperty("os.name");
            boolean bl = string != null && string.contains("Windows");
            this.uiDefaults = super.getDefaults();
            this.defaults.initializeDefaults(this.uiDefaults);
            if (bl) {
                WindowsKeybindings.installKeybindings(this.uiDefaults);
            } else {
                GTKKeybindings.installKeybindings(this.uiDefaults);
            }
            this.uiDefaults.put("TitledBorder.titlePosition", (Object)1);
            this.uiDefaults.put("TitledBorder.border", new BorderUIResource(new LoweredBorder()));
            this.uiDefaults.put("TitledBorder.titleColor", this.getDerivedColor("text", 0.0f, 0.0f, 0.23f, 0, true));
            this.uiDefaults.put("TitledBorder.font", new NimbusDefaults.DerivedFont("defaultFont", 1.0f, true, null));
            this.uiDefaults.put("OptionPane.isYesLast", (Object)(!bl ? 1 : 0));
            this.uiDefaults.put("Table.scrollPaneCornerComponent", new UIDefaults.ActiveValue(){

                @Override
                public Object createValue(UIDefaults uIDefaults) {
                    return new TableScrollPaneCorner();
                }
            });
            this.uiDefaults.put("ToolBarSeparator[Enabled].backgroundPainter", new ToolBarSeparatorPainter());
            for (String string2 : COMPONENT_KEYS) {
                String string3 = string2 + ".foreground";
                if (!this.uiDefaults.containsKey(string3)) {
                    this.uiDefaults.put(string3, new NimbusProperty(string2, "textForeground"));
                }
                if (!this.uiDefaults.containsKey(string3 = string2 + ".background")) {
                    this.uiDefaults.put(string3, new NimbusProperty(string2, "background"));
                }
                if (!this.uiDefaults.containsKey(string3 = string2 + ".font")) {
                    this.uiDefaults.put(string3, new NimbusProperty(string2, "font"));
                }
                if (!this.uiDefaults.containsKey(string3 = string2 + ".disabledText")) {
                    this.uiDefaults.put(string3, new NimbusProperty(string2, "Disabled", "textForeground"));
                }
                if (this.uiDefaults.containsKey(string3 = string2 + ".disabled")) continue;
                this.uiDefaults.put(string3, new NimbusProperty(string2, "Disabled", "background"));
            }
            this.uiDefaults.put("FileView.computerIcon", new LinkProperty("FileChooser.homeFolderIcon"));
            this.uiDefaults.put("FileView.directoryIcon", new LinkProperty("FileChooser.directoryIcon"));
            this.uiDefaults.put("FileView.fileIcon", new LinkProperty("FileChooser.fileIcon"));
            this.uiDefaults.put("FileView.floppyDriveIcon", new LinkProperty("FileChooser.floppyDriveIcon"));
            this.uiDefaults.put("FileView.hardDriveIcon", new LinkProperty("FileChooser.hardDriveIcon"));
        }
        return this.uiDefaults;
    }

    public static NimbusStyle getStyle(JComponent jComponent, Region region) {
        return (NimbusStyle)SynthLookAndFeel.getStyle(jComponent, region);
    }

    @Override
    public String getName() {
        return "Nimbus";
    }

    @Override
    public String getID() {
        return "Nimbus";
    }

    @Override
    public String getDescription() {
        return "Nimbus Look and Feel";
    }

    @Override
    public boolean shouldUpdateStyleOnAncestorChanged() {
        return true;
    }

    @Override
    protected boolean shouldUpdateStyleOnEvent(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if ("name" == string || "ancestor" == string || "Nimbus.Overrides" == string || "Nimbus.Overrides.InheritDefaults" == string || "JComponent.sizeVariant" == string) {
            JComponent jComponent = (JComponent)propertyChangeEvent.getSource();
            this.defaults.clearOverridesCache(jComponent);
            return true;
        }
        return super.shouldUpdateStyleOnEvent(propertyChangeEvent);
    }

    public void register(Region region, String string) {
        this.defaults.register(region, string);
    }

    private String getSystemProperty(String string) {
        return AccessController.doPrivileged(new GetPropertyAction(string));
    }

    @Override
    public Icon getDisabledIcon(JComponent jComponent, Icon icon) {
        if (icon instanceof SynthIcon) {
            SynthIcon synthIcon = (SynthIcon)icon;
            BufferedImage bufferedImage = EffectUtils.createCompatibleTranslucentImage(synthIcon.getIconWidth(), synthIcon.getIconHeight());
            Graphics2D graphics2D = bufferedImage.createGraphics();
            synthIcon.paintIcon(jComponent, graphics2D, 0, 0);
            graphics2D.dispose();
            return new ImageIconUIResource(GrayFilter.createDisabledImage(bufferedImage));
        }
        return super.getDisabledIcon(jComponent, icon);
    }

    public Color getDerivedColor(String string, float f, float f2, float f3, int n, boolean bl) {
        return this.defaults.getDerivedColor(string, f, f2, f3, n, bl);
    }

    protected final Color getDerivedColor(Color color, Color color2, float f, boolean bl) {
        int n = NimbusLookAndFeel.deriveARGB(color, color2, f);
        if (bl) {
            return new ColorUIResource(n);
        }
        return new Color(n);
    }

    protected final Color getDerivedColor(Color color, Color color2, float f) {
        return this.getDerivedColor(color, color2, f, true);
    }

    static Object resolveToolbarConstraint(JToolBar jToolBar) {
        LayoutManager layoutManager;
        Container container;
        if (jToolBar != null && (container = jToolBar.getParent()) != null && (layoutManager = container.getLayout()) instanceof BorderLayout) {
            BorderLayout borderLayout = (BorderLayout)layoutManager;
            Object object = borderLayout.getConstraints(jToolBar);
            if (object == "South" || object == "East" || object == "West") {
                return object;
            }
            return "North";
        }
        return "North";
    }

    static int deriveARGB(Color color, Color color2, float f) {
        int n = color.getRed() + Math.round((float)(color2.getRed() - color.getRed()) * f);
        int n2 = color.getGreen() + Math.round((float)(color2.getGreen() - color.getGreen()) * f);
        int n3 = color.getBlue() + Math.round((float)(color2.getBlue() - color.getBlue()) * f);
        int n4 = color.getAlpha() + Math.round((float)(color2.getAlpha() - color.getAlpha()) * f);
        return (n4 & 0xFF) << 24 | (n & 0xFF) << 16 | (n2 & 0xFF) << 8 | n3 & 0xFF;
    }

    static String parsePrefix(String string) {
        if (string == null) {
            return null;
        }
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\"') {
                bl = !bl;
                continue;
            }
            if (c != '[' && c != '.' || bl) continue;
            return string.substring(0, i);
        }
        return null;
    }

    Map<String, Object> getDefaultsForPrefix(String string) {
        if (this.compiledDefaults == null) {
            this.compiledDefaults = new HashMap<String, Map<String, Object>>();
            for (Map.Entry entry : UIManager.getDefaults().entrySet()) {
                if (!(entry.getKey() instanceof String)) continue;
                this.addDefault((String)entry.getKey(), entry.getValue());
            }
            if (!this.defaultListenerAdded) {
                UIManager.getDefaults().addPropertyChangeListener(this.defaultsListener);
                this.defaultListenerAdded = true;
            }
        }
        return this.compiledDefaults.get(string);
    }

    private void addDefault(String string, Object object) {
        if (this.compiledDefaults == null) {
            return;
        }
        String string2 = NimbusLookAndFeel.parsePrefix(string);
        if (string2 != null) {
            Map<String, Object> map = this.compiledDefaults.get(string2);
            if (map == null) {
                map = new HashMap<String, Object>();
                this.compiledDefaults.put(string2, map);
            }
            map.put(string, object);
        }
    }

    private class DefaultsListener
    implements PropertyChangeListener {
        private DefaultsListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("UIDefaults".equals(string)) {
                NimbusLookAndFeel.this.compiledDefaults = null;
            } else {
                NimbusLookAndFeel.this.addDefault(string, propertyChangeEvent.getNewValue());
            }
        }
    }

    private class LinkProperty
    implements UIDefaults.ActiveValue,
    UIResource {
        private String dstPropName;

        private LinkProperty(String string) {
            this.dstPropName = string;
        }

        @Override
        public Object createValue(UIDefaults uIDefaults) {
            return UIManager.get(this.dstPropName);
        }
    }

    private class NimbusProperty
    implements UIDefaults.ActiveValue,
    UIResource {
        private String prefix;
        private String state = null;
        private String suffix;
        private boolean isFont;

        private NimbusProperty(String string, String string2) {
            this.prefix = string;
            this.suffix = string2;
            this.isFont = "font".equals(string2);
        }

        private NimbusProperty(String string, String string2, String string3) {
            this(string, string3);
            this.state = string2;
        }

        @Override
        public Object createValue(UIDefaults uIDefaults) {
            Object object = null;
            if (this.state != null) {
                object = NimbusLookAndFeel.this.uiDefaults.get(this.prefix + "[" + this.state + "]." + this.suffix);
            }
            if (object == null) {
                object = NimbusLookAndFeel.this.uiDefaults.get(this.prefix + "[Enabled]." + this.suffix);
            }
            if (object == null) {
                object = this.isFont ? NimbusLookAndFeel.this.uiDefaults.get("defaultFont") : NimbusLookAndFeel.this.uiDefaults.get(this.suffix);
            }
            return object;
        }
    }
}

