/*
 * Decompiled with CFR 0.152.
 */
package sun.util;

import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.spi.BreakIteratorProvider;
import java.text.spi.CollatorProvider;
import java.text.spi.DateFormatProvider;
import java.text.spi.DateFormatSymbolsProvider;
import java.text.spi.DecimalFormatSymbolsProvider;
import java.text.spi.NumberFormatProvider;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.IllformedLocaleException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.spi.CurrencyNameProvider;
import java.util.spi.LocaleNameProvider;
import java.util.spi.LocaleServiceProvider;
import java.util.spi.TimeZoneNameProvider;
import sun.util.logging.PlatformLogger;
import sun.util.resources.LocaleData;
import sun.util.resources.OpenListResourceBundle;

public final class LocaleServiceProviderPool {
    private static ConcurrentMap<Class<? extends LocaleServiceProvider>, LocaleServiceProviderPool> poolOfPools = new ConcurrentHashMap<Class<? extends LocaleServiceProvider>, LocaleServiceProviderPool>();
    private Set<LocaleServiceProvider> providers = new LinkedHashSet<LocaleServiceProvider>();
    private Map<Locale, LocaleServiceProvider> providersCache = new ConcurrentHashMap<Locale, LocaleServiceProvider>();
    private Set<Locale> availableLocales = null;
    private static volatile List<Locale> availableJRELocales = null;
    private Set<Locale> providerLocales = null;
    private static Locale locale_ja_JP_JP = new Locale("ja", "JP", "JP");
    private static Locale locale_th_TH_TH = new Locale("th", "TH", "TH");

    public static LocaleServiceProviderPool getPool(Class<? extends LocaleServiceProvider> clazz) {
        LocaleServiceProviderPool localeServiceProviderPool;
        LocaleServiceProviderPool localeServiceProviderPool2 = (LocaleServiceProviderPool)poolOfPools.get(clazz);
        if (localeServiceProviderPool2 == null && (localeServiceProviderPool2 = poolOfPools.putIfAbsent(clazz, localeServiceProviderPool = new LocaleServiceProviderPool(clazz))) == null) {
            localeServiceProviderPool2 = localeServiceProviderPool;
        }
        return localeServiceProviderPool2;
    }

    private LocaleServiceProviderPool(final Class<? extends LocaleServiceProvider> clazz) {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() {
                    for (LocaleServiceProvider localeServiceProvider : ServiceLoader.loadInstalled(clazz)) {
                        LocaleServiceProviderPool.this.providers.add(localeServiceProvider);
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            LocaleServiceProviderPool.config(privilegedActionException.toString());
        }
    }

    private static void config(String string) {
        PlatformLogger platformLogger = PlatformLogger.getLogger("sun.util.LocaleServiceProviderPool");
        platformLogger.config(string);
    }

    public static Locale[] getAllAvailableLocales() {
        return (Locale[])AllAvailableLocales.allAvailableLocales.clone();
    }

    public synchronized Locale[] getAvailableLocales() {
        if (this.availableLocales == null) {
            this.availableLocales = new HashSet<Locale>(this.getJRELocales());
            if (this.hasProviders()) {
                this.availableLocales.addAll(this.getProviderLocales());
            }
        }
        Locale[] localeArray = new Locale[this.availableLocales.size()];
        this.availableLocales.toArray(localeArray);
        return localeArray;
    }

    private synchronized Set<Locale> getProviderLocales() {
        if (this.providerLocales == null) {
            this.providerLocales = new HashSet<Locale>();
            if (this.hasProviders()) {
                for (LocaleServiceProvider localeServiceProvider : this.providers) {
                    Locale[] localeArray;
                    for (Locale locale : localeArray = localeServiceProvider.getAvailableLocales()) {
                        this.providerLocales.add(LocaleServiceProviderPool.getLookupLocale(locale));
                    }
                }
            }
        }
        return this.providerLocales;
    }

    public boolean hasProviders() {
        return !this.providers.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<Locale> getJRELocales() {
        if (availableJRELocales != null) return availableJRELocales;
        Class<LocaleServiceProviderPool> clazz = LocaleServiceProviderPool.class;
        synchronized (LocaleServiceProviderPool.class) {
            if (availableJRELocales != null) return availableJRELocales;
            Locale[] localeArray = LocaleData.getAvailableLocales();
            ArrayList<Locale> arrayList = new ArrayList<Locale>(localeArray.length);
            for (Locale locale : localeArray) {
                arrayList.add(LocaleServiceProviderPool.getLookupLocale(locale));
            }
            availableJRELocales = arrayList;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return availableJRELocales;
        }
    }

    private boolean isJRESupported(Locale locale) {
        List<Locale> list = this.getJRELocales();
        return list.contains(LocaleServiceProviderPool.getLookupLocale(locale));
    }

    public <P, S> S getLocalizedObject(LocalizedObjectGetter<P, S> localizedObjectGetter, Locale locale, Object ... objectArray) {
        return this.getLocalizedObjectImpl(localizedObjectGetter, locale, true, null, null, null, objectArray);
    }

    public <P, S> S getLocalizedObject(LocalizedObjectGetter<P, S> localizedObjectGetter, Locale locale, OpenListResourceBundle openListResourceBundle, String string, Object ... objectArray) {
        return this.getLocalizedObjectImpl(localizedObjectGetter, locale, false, null, openListResourceBundle, string, objectArray);
    }

    public <P, S> S getLocalizedObject(LocalizedObjectGetter<P, S> localizedObjectGetter, Locale locale, String string, OpenListResourceBundle openListResourceBundle, String string2, Object ... objectArray) {
        return this.getLocalizedObjectImpl(localizedObjectGetter, locale, false, string, openListResourceBundle, string2, objectArray);
    }

    private <P, S> S getLocalizedObjectImpl(LocalizedObjectGetter<P, S> localizedObjectGetter, Locale locale, boolean bl, String string, OpenListResourceBundle openListResourceBundle, String string2, Object ... objectArray) {
        if (this.hasProviders()) {
            if (string == null) {
                string = string2;
            }
            Locale locale2 = openListResourceBundle != null ? openListResourceBundle.getLocale() : null;
            List<Locale> list = LocaleServiceProviderPool.getLookupLocales(locale);
            S s = null;
            Set<Locale> set = this.getProviderLocales();
            for (int i = 0; i < list.size(); ++i) {
                LocaleServiceProvider localeServiceProvider;
                Locale locale3 = list.get(i);
                if (locale2 == null ? this.isJRESupported(locale3) : locale3.equals(locale2)) break;
                if (!set.contains(locale3) || (localeServiceProvider = this.findProvider(locale3)) == null) continue;
                s = localizedObjectGetter.getObject(localeServiceProvider, locale, string2, objectArray);
                if (s != null) {
                    return s;
                }
                if (!bl) continue;
                LocaleServiceProviderPool.config("A locale sensitive service provider returned null for a localized objects,  which should not happen.  provider: " + localeServiceProvider + " locale: " + locale);
            }
            while (openListResourceBundle != null) {
                locale2 = openListResourceBundle.getLocale();
                if (openListResourceBundle.handleGetKeys().contains(string)) {
                    return null;
                }
                LocaleServiceProvider localeServiceProvider = this.findProvider(locale2);
                if (localeServiceProvider != null && (s = (S)localizedObjectGetter.getObject(localeServiceProvider, locale, string2, objectArray)) != null) {
                    return s;
                }
                openListResourceBundle = openListResourceBundle.getParent();
            }
        }
        return null;
    }

    private LocaleServiceProvider findProvider(Locale locale) {
        if (!this.hasProviders()) {
            return null;
        }
        if (this.providersCache.containsKey(locale)) {
            LocaleServiceProvider localeServiceProvider = this.providersCache.get(locale);
            if (localeServiceProvider != NullProvider.INSTANCE) {
                return localeServiceProvider;
            }
        } else {
            for (LocaleServiceProvider localeServiceProvider : this.providers) {
                Locale[] localeArray;
                for (Locale locale2 : localeArray = localeServiceProvider.getAvailableLocales()) {
                    if (!locale.equals(locale2 = LocaleServiceProviderPool.getLookupLocale(locale2))) continue;
                    LocaleServiceProvider localeServiceProvider2 = this.providersCache.put(locale, localeServiceProvider);
                    return localeServiceProvider2 != null ? localeServiceProvider2 : localeServiceProvider;
                }
            }
            this.providersCache.put(locale, NullProvider.INSTANCE);
        }
        return null;
    }

    private static List<Locale> getLookupLocales(Locale locale) {
        List<Locale> list = new ResourceBundle.Control(){}.getCandidateLocales("", locale);
        return list;
    }

    private static Locale getLookupLocale(Locale locale) {
        Locale locale2 = locale;
        Set<Character> set = locale.getExtensionKeys();
        if (!(set.isEmpty() || locale.equals(locale_ja_JP_JP) || locale.equals(locale_th_TH_TH))) {
            Locale.Builder builder = new Locale.Builder();
            try {
                builder.setLocale(locale);
                builder.clearExtensions();
                locale2 = builder.build();
            }
            catch (IllformedLocaleException illformedLocaleException) {
                LocaleServiceProviderPool.config("A locale(" + locale + ") has non-empty extensions, but has illformed fields.");
                locale2 = new Locale(locale.getLanguage(), locale.getCountry(), locale.getVariant());
            }
        }
        return locale2;
    }

    private static class AllAvailableLocales {
        static final Locale[] allAvailableLocales;

        private AllAvailableLocales() {
        }

        static {
            Class[] classArray = new Class[]{BreakIteratorProvider.class, CollatorProvider.class, DateFormatProvider.class, DateFormatSymbolsProvider.class, DecimalFormatSymbolsProvider.class, NumberFormatProvider.class, CurrencyNameProvider.class, LocaleNameProvider.class, TimeZoneNameProvider.class};
            Locale[] localeArray = LocaleData.getAvailableLocales();
            HashSet<Locale> hashSet = new HashSet<Locale>(localeArray.length);
            for (Locale serializable : localeArray) {
                hashSet.add(LocaleServiceProviderPool.getLookupLocale(serializable));
            }
            for (Serializable serializable : classArray) {
                LocaleServiceProviderPool localeServiceProviderPool = LocaleServiceProviderPool.getPool((Class<? extends LocaleServiceProvider>)serializable);
                hashSet.addAll(localeServiceProviderPool.getProviderLocales());
            }
            allAvailableLocales = hashSet.toArray(new Locale[0]);
        }
    }

    public static interface LocalizedObjectGetter<P, S> {
        public S getObject(P var1, Locale var2, String var3, Object ... var4);
    }

    private static class NullProvider
    extends LocaleServiceProvider {
        private static final NullProvider INSTANCE = new NullProvider();

        private NullProvider() {
        }

        @Override
        public Locale[] getAvailableLocales() {
            throw new RuntimeException("Should not get called.");
        }
    }
}

