/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import org.eclipse.jgit.api.FetchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.InitCommand;
import org.eclipse.jgit.api.errors.InvalidRemoteException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheCheckout;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.FetchResult;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.TagOpt;
import org.eclipse.jgit.transport.URIish;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloneCommand
implements Callable<Git> {
    private String uri;
    private File directory;
    private boolean bare;
    private String remote = "origin";
    private String branch = "HEAD";
    private ProgressMonitor monitor = NullProgressMonitor.INSTANCE;
    private CredentialsProvider credentialsProvider;
    private int timeout;
    private boolean cloneAllBranches;
    private boolean noCheckout;
    private Collection<String> branchesToClone;

    @Override
    public Git call() throws JGitInternalException {
        try {
            URIish u = new URIish(this.uri);
            Repository repository = this.init(u);
            FetchResult result = this.fetch(repository, u);
            if (!this.noCheckout) {
                this.checkout(repository, result);
            }
            return new Git(repository);
        }
        catch (IOException ioe) {
            throw new JGitInternalException(ioe.getMessage(), ioe);
        }
        catch (InvalidRemoteException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
        catch (URISyntaxException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
    }

    private Repository init(URIish u) {
        InitCommand command = Git.init();
        command.setBare(this.bare);
        if (this.directory == null) {
            this.directory = new File(u.getHumanishName(), ".git");
        }
        command.setDirectory(this.directory);
        return command.call().getRepository();
    }

    private FetchResult fetch(Repository repo, URIish u) throws URISyntaxException, JGitInternalException, InvalidRemoteException, IOException {
        RemoteConfig config = new RemoteConfig(repo.getConfig(), this.remote);
        config.addURI(u);
        String dst = this.bare ? "refs/heads/" : "refs/remotes/" + config.getName();
        RefSpec refSpec = new RefSpec();
        refSpec = refSpec.setForceUpdate(true);
        refSpec = refSpec.setSourceDestination("refs/heads/*", dst + "/*");
        config.addFetchRefSpec(refSpec);
        config.update(repo.getConfig());
        repo.getConfig().save();
        FetchCommand command = new FetchCommand(repo);
        command.setRemote(this.remote);
        command.setProgressMonitor(this.monitor);
        command.setTagOpt(TagOpt.FETCH_TAGS);
        command.setTimeout(this.timeout);
        if (this.credentialsProvider != null) {
            command.setCredentialsProvider(this.credentialsProvider);
        }
        List<RefSpec> specs = this.calculateRefSpecs(dst);
        command.setRefSpecs(specs);
        return command.call();
    }

    private List<RefSpec> calculateRefSpecs(String dst) {
        RefSpec wcrs = new RefSpec();
        wcrs = wcrs.setForceUpdate(true);
        wcrs = wcrs.setSourceDestination("refs/heads/*", dst + "/*");
        ArrayList<RefSpec> specs = new ArrayList<RefSpec>();
        if (this.cloneAllBranches) {
            specs.add(wcrs);
        } else if (this.branchesToClone != null && this.branchesToClone.size() > 0) {
            for (String selectedRef : this.branchesToClone) {
                if (!wcrs.matchSource(selectedRef)) continue;
                specs.add(wcrs.expandFromSource(selectedRef));
            }
        }
        return specs;
    }

    private void checkout(Repository repo, FetchResult result) throws JGitInternalException, MissingObjectException, IncorrectObjectTypeException, IOException {
        Ref foundBranch;
        Ref head = result.getAdvertisedRef(this.branch);
        if (this.branch.equals("HEAD") && (foundBranch = this.findBranchToCheckout(result)) != null) {
            head = foundBranch;
        }
        if (head == null || head.getObjectId() == null) {
            return;
        }
        if (head.getName().startsWith("refs/heads/")) {
            RefUpdate newHead = repo.updateRef("HEAD");
            newHead.disableRefLog();
            newHead.link(head.getName());
            this.addMergeConfig(repo, head);
        }
        RevCommit commit = this.parseCommit(repo, head);
        boolean detached = !head.getName().startsWith("refs/heads/");
        RefUpdate u = repo.updateRef("HEAD", detached);
        u.setNewObjectId(commit.getId());
        u.forceUpdate();
        if (!this.bare) {
            DirCache dc = repo.lockDirCache();
            DirCacheCheckout co = new DirCacheCheckout(repo, dc, commit.getTree());
            co.checkout();
        }
    }

    private Ref findBranchToCheckout(FetchResult result) {
        Ref foundBranch = null;
        Ref idHEAD = result.getAdvertisedRef("HEAD");
        for (Ref r : result.getAdvertisedRefs()) {
            String n = r.getName();
            if (!n.startsWith("refs/heads/") || idHEAD == null || !r.getObjectId().equals(idHEAD.getObjectId())) continue;
            foundBranch = r;
            break;
        }
        return foundBranch;
    }

    private void addMergeConfig(Repository repo, Ref head) throws IOException {
        String branchName = Repository.shortenRefName(head.getName());
        repo.getConfig().setString("branch", branchName, "remote", this.remote);
        repo.getConfig().setString("branch", branchName, "merge", head.getName());
        repo.getConfig().save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RevCommit parseCommit(Repository repo, Ref ref) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        RevCommit commit;
        RevWalk rw = new RevWalk(repo);
        try {
            commit = rw.parseCommit(ref.getObjectId());
            Object var6_5 = null;
            rw.release();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            rw.release();
            throw throwable;
        }
        return commit;
    }

    public CloneCommand setURI(String uri) {
        this.uri = uri;
        return this;
    }

    public CloneCommand setDirectory(File directory) {
        this.directory = directory;
        return this;
    }

    public CloneCommand setBare(boolean bare) {
        this.bare = bare;
        return this;
    }

    public CloneCommand setRemote(String remote) {
        this.remote = remote;
        return this;
    }

    public CloneCommand setBranch(String branch) {
        this.branch = branch;
        return this;
    }

    public CloneCommand setProgressMonitor(ProgressMonitor monitor) {
        this.monitor = monitor;
        return this;
    }

    public CloneCommand setCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
        return this;
    }

    public CloneCommand setTimeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    public CloneCommand setCloneAllBranches(boolean cloneAllBranches) {
        this.cloneAllBranches = cloneAllBranches;
        return this;
    }

    public CloneCommand setBranchesToClone(Collection<String> branchesToClone) {
        this.branchesToClone = branchesToClone;
        return this;
    }

    public CloneCommand setNoCheckout(boolean noCheckout) {
        this.noCheckout = noCheckout;
        return this;
    }
}

