/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.weblogic;

import java.security.PrivilegedAction;
import org.hyperic.hq.plugin.weblogic.WeblogicAction;
import org.hyperic.hq.plugin.weblogic.WeblogicAuth;
import org.hyperic.hq.plugin.weblogic.WeblogicProductPlugin;
import org.hyperic.hq.product.ControlPlugin;
import org.hyperic.hq.product.Metric;

public class WeblogicAuthControl
implements PrivilegedAction {
    private static final boolean useJAAS = WeblogicProductPlugin.useJAAS();
    private static final int RUN_ACTION = 1;
    private static final int RUN_STATUS = 2;
    private WeblogicAction plugin;
    private Metric metric;
    private String action;
    private int method;
    private boolean active = false;

    public WeblogicAuthControl(WeblogicAction plugin, Metric metric) {
        this.plugin = plugin;
        this.metric = metric;
    }

    public Object run() {
        switch (this.method) {
            case 1: {
                this.plugin.doWeblogicAction(this.action);
                break;
            }
            case 2: {
                if (this.plugin.isWeblogicRunning()) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            default: {
                throw new IllegalStateException("unknown run method: " + this.method);
            }
        }
        return null;
    }

    public void doAction(String action) {
        if (useJAAS) {
            this.doActionAs(action);
        } else {
            this.plugin.doWeblogicAction(action);
        }
    }

    public boolean isRunning() {
        if (!this.active && useJAAS) {
            return this.isRunningAs();
        }
        return this.plugin.isWeblogicRunning();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doActionAs(String action) {
        WeblogicAuth auth = WeblogicAuth.getInstance(this.metric);
        this.active = true;
        this.action = action;
        this.method = 1;
        try {
            auth.runAs(this);
        }
        catch (SecurityException e) {
            ControlPlugin plugin = (ControlPlugin)this.plugin;
            plugin.setResult(-1);
            plugin.setMessage(e.getMessage());
            if (action.equals("start")) {
                this.run();
            }
        }
        finally {
            this.active = false;
        }
    }

    public boolean isRunningAs() {
        WeblogicAuth auth = WeblogicAuth.getInstance(this.metric);
        this.method = 2;
        try {
            Object obj = auth.runAs(this);
            return (Boolean)obj;
        }
        catch (SecurityException e) {
            return false;
        }
    }
}

