/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.weblogic;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.hyperic.hq.plugin.weblogic.WeblogicAction;
import org.hyperic.hq.plugin.weblogic.WeblogicAuthControl;
import org.hyperic.hq.plugin.weblogic.WeblogicMetric;
import org.hyperic.hq.plugin.weblogic.WeblogicUtil;
import org.hyperic.hq.product.GenericPlugin;
import org.hyperic.hq.product.Metric;
import org.hyperic.hq.product.MetricNotFoundException;
import org.hyperic.hq.product.MetricUnreachableException;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.ServerControlPlugin;
import org.hyperic.hq.product.TypeInfo;
import org.hyperic.util.config.ConfigOption;
import org.hyperic.util.config.ConfigResponse;
import org.hyperic.util.config.ConfigSchema;

public class WeblogicControlPlugin
extends ServerControlPlugin
implements WeblogicAction {
    public static final int DEFAULT_TIMEOUT = 600;
    private static final String[] actions = new String[]{"start", "stop", "runGarbageCollector"};
    private static final List commands = Arrays.asList(actions);
    protected static final String DEFAULT_SCRIPT = "startWebLogic.sh";
    static final String SERVER_METRIC = WeblogicMetric.template(WeblogicMetric.SERVER_RUNTIME, "StateVal");
    static final String ADMIN_METRIC = WeblogicMetric.template("%domain%:Name=%server%,Type=Server", "StateVal");
    private WeblogicAuthControl authControl;
    private Metric lifecycleMetric = null;
    private Metric adminMetric = null;
    private Metric jvmMetric = null;

    public WeblogicControlPlugin() {
        this.setTimeout(600);
        this.setControlProgram(DEFAULT_SCRIPT);
    }

    public void configure(ConfigResponse config) throws PluginException {
        super.configure(config);
        this.authControl = new WeblogicAuthControl(this, this.getLifecycleMetric());
    }

    public ConfigSchema getConfigSchema(TypeInfo info, ConfigResponse config) {
        ConfigOption option;
        ConfigSchema schema = super.getConfigSchema(info, config);
        if (info.isServer("Weblogic") && (option = schema.getOption("program")) != null) {
            option.setOptional(true);
        }
        return schema;
    }

    public List getActions() {
        return commands;
    }

    private Metric configureMetric(String template) {
        template = WeblogicMetric.translateNode(template, this.getConfig());
        String metric = Metric.translate((String)template, (ConfigResponse)this.getConfig());
        this.getLog().debug((Object)("configureMetric=" + metric));
        try {
            return Metric.parse((String)metric);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected Metric getLifecycleMetric() {
        if (this.lifecycleMetric == null) {
            this.lifecycleMetric = this.configureMetric(SERVER_METRIC);
        }
        return this.lifecycleMetric;
    }

    private Metric getJVMMetric() {
        if (this.jvmMetric == null) {
            String jvmObjectName = WeblogicMetric.getObjectTemplate((GenericPlugin)this, "JVMRuntime");
            String jvmMetric = WeblogicMetric.template(jvmObjectName, "Name");
            this.jvmMetric = this.configureMetric(jvmMetric);
        }
        return this.jvmMetric;
    }

    protected Metric getAdminMetric() {
        if (this.adminMetric == null) {
            String metric = Metric.translate((String)ADMIN_METRIC, (ConfigResponse)this.getConfig());
            this.getLog().debug((Object)("adminMetric=" + metric));
            try {
                return Metric.parse((String)metric);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return this.adminMetric;
    }

    protected boolean isRunning() {
        return this.authControl.isRunning();
    }

    public boolean isWeblogicRunning() {
        boolean res;
        block2: {
            res = false;
            Metric metric = this.getLifecycleMetric();
            try {
                Integer state = (Integer)WeblogicUtil.getRemoteMBeanValue(metric);
                double val = WeblogicUtil.convertStateVal(state);
                res = val == 1.0;
            }
            catch (Exception e) {
                if (!this.getLog().isDebugEnabled()) break block2;
                this.getLog().error((Object)e);
            }
        }
        this.getLog().error((Object)("[isWeblogicRunning] " + res));
        return res;
    }

    protected boolean isBackgroundCommand() {
        return true;
    }

    protected void start() {
        File script = new File(this.getControlProgram());
        if (!script.exists()) {
            this.setResult(-1);
            this.setMessage("Control program does not exist: " + this.getControlProgram());
            return;
        }
        if (this.isWeblogicRunning()) {
            this.setResult(-1);
            this.setMessage("Server already running");
            return;
        }
        super.start(null);
        if (this.isWeblogicRunning()) {
            this.setResult(0);
            this.setMessage("Server started");
            return;
        }
        this.setResult(-1);
        if (this.getMessage() == null) {
            this.setMessage("Server did not start");
        }
    }

    protected Object invokeAction(Metric metric, String action) {
        try {
            Object obj = WeblogicUtil.invoke(metric, action);
            this.setResult(0);
            if (obj != null) {
                this.setMessage(obj.toString());
            }
            return obj;
        }
        catch (MetricNotFoundException e) {
            this.setMessage(e.getMessage());
            this.setResult(-1);
        }
        catch (MetricUnreachableException e) {
            this.setMessage(e.getMessage());
            this.setResult(-1);
        }
        catch (PluginException e) {
            if (action.equals("shutdown") && !this.isRunning()) {
                this.setResult(0);
            }
            this.setMessage(e.getMessage());
            this.setResult(-2);
        }
        return null;
    }

    public void doAction(String action) throws PluginException {
        this.authControl.doAction(action);
    }

    public void doWeblogicAction(String action) {
        String method;
        Metric metric;
        if (action.equals("start")) {
            this.start();
            return;
        }
        if (action.equals("stop")) {
            metric = this.getLifecycleMetric();
            method = "shutdown";
        } else if (action.equals("runGarbageCollector")) {
            metric = this.getJVMMetric();
            method = "runGC";
        } else {
            return;
        }
        this.invokeAction(metric, method);
    }
}

