/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.weblogic;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.management.MBeanServer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.plugin.weblogic.WeblogicConfig;
import org.hyperic.hq.plugin.weblogic.WeblogicLogFileTrackPlugin;
import org.hyperic.hq.plugin.weblogic.WeblogicProductPlugin;
import org.hyperic.hq.plugin.weblogic.jmx.ApplicationQuery;
import org.hyperic.hq.plugin.weblogic.jmx.NodeManagerQuery;
import org.hyperic.hq.plugin.weblogic.jmx.ServerQuery;
import org.hyperic.hq.plugin.weblogic.jmx.ServiceQuery;
import org.hyperic.hq.plugin.weblogic.jmx.WeblogicDiscover;
import org.hyperic.hq.plugin.weblogic.jmx.WeblogicDiscoverException;
import org.hyperic.hq.plugin.weblogic.jmx.WeblogicQuery;
import org.hyperic.hq.plugin.weblogic.jmx.WeblogicRuntimeDiscoverer;
import org.hyperic.hq.product.AutoServerDetector;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.RuntimeDiscoverer;
import org.hyperic.hq.product.ServerDetector;
import org.hyperic.hq.product.ServerResource;
import org.hyperic.hq.product.ServiceResource;
import org.hyperic.sigar.SigarException;
import org.hyperic.util.config.ConfigResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WeblogicDetector
extends ServerDetector
implements AutoServerDetector {
    private static final String PTQL_QUERY = "State.Name.eq=java,Args.-1.eq=weblogic.Server";
    private static final String SCRIPT_EXT = WeblogicDetector.isWin32() ? ".cmd" : ".sh";
    private static final String ADMIN_START = "startWebLogic" + SCRIPT_EXT;
    public static final String NODE_START = "bin/startManagedWebLogic" + SCRIPT_EXT;
    static final String PROP_MX_SERVER = "-Dweblogic.management.server";
    private static final Log log = LogFactory.getLog(WeblogicDetector.class);

    public WeblogicDetector() {
        this.setName("Weblogic");
    }

    public RuntimeDiscoverer getRuntimeDiscoverer() {
        if (WeblogicProductPlugin.NEW_DISCOVERY) {
            return super.getRuntimeDiscoverer();
        }
        return new WeblogicRuntimeDiscoverer(this);
    }

    void adjustWeblogicClassPath(String installpath) {
        this.adjustClassPath(installpath);
    }

    public List getServerResources(ConfigResponse platformConfig) throws PluginException {
        this.getLog().debug((Object)("[getServerResources] platformConfig=" + platformConfig));
        ArrayList servers = new ArrayList();
        List<WLSProcWithPid> procs = this.getServerProcessList();
        for (WLSProcWithPid proc : procs) {
            try {
                List s = this.discoverServer(proc);
                if (s == null) continue;
                servers.addAll(s);
            }
            catch (SigarException e) {
                this.getLog().debug((Object)e.getMessage(), (Throwable)e);
                throw new PluginException((Throwable)e);
            }
            catch (PluginException ex) {
                this.getLog().debug((Object)ex.getMessage(), (Throwable)ex);
                throw ex;
            }
        }
        return servers;
    }

    private List discoverServer(WLSProcWithPid proc) throws PluginException, SigarException {
        this.getLog().debug((Object)("Looking at: " + proc.getPath()));
        File installDir = new File(proc.getPath());
        File configXML = new File(proc.getPath(), "config/config.xml");
        if (!configXML.exists()) {
            configXML = new File(proc.getPath(), "config.xml");
        }
        WeblogicConfig cfg = new WeblogicConfig();
        try {
            cfg.read(configXML);
        }
        catch (IOException e) {
            throw new PluginException("Failed to read " + configXML + ": " + e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            throw new PluginException("Failed to parse " + configXML + ": " + e.getMessage(), (Throwable)e);
        }
        WeblogicConfig.Server srvConfig = cfg.getServer(proc.getName());
        this.getLog().debug((Object)("srvConfig=" + srvConfig));
        if (srvConfig == null) {
            throw new PluginException("server '" + proc.getName() + "' not found in " + configXML);
        }
        if (this.getName().indexOf(srvConfig.getVersion()) < 0) {
            this.getLog().debug((Object)("server '" + proc.getName() + " is not a " + this.getName()));
            return null;
        }
        ConfigResponse productConfig = new ConfigResponse((Map)srvConfig.getProperties());
        String[] dirs = new String[]{proc.getName(), "logs"};
        File wlsLog = null;
        for (int i = 0; i < dirs.length && !(wlsLog = new File(installDir, dirs[i] + File.separator + proc.getName() + ".log")).exists(); ++i) {
        }
        productConfig.setValue(WeblogicLogFileTrackPlugin.PROP_FILES_SERVER, wlsLog.toString());
        ConfigResponse controlConfig = new ConfigResponse();
        File script = new File(installDir, "../../" + ADMIN_START);
        try {
            controlConfig.setValue("program", script.getCanonicalPath());
        }
        catch (IOException ex) {
            controlConfig.setValue("program", script.getPath());
            this.getLog().debug((Object)ex);
        }
        boolean hasCreds = false;
        Properties props = this.getManager().getProperties();
        String[] credProps = new String[]{"admin.username", "admin.password", "admin.url", "jvm.runtime"};
        for (int i = 0; i < credProps.length; ++i) {
            String key = credProps[i];
            String val = props.getProperty(srvConfig.domain + "." + key, props.getProperty(key));
            if (val != null) {
                productConfig.setValue(key, val);
                hasCreds = true;
                continue;
            }
            hasCreds = false;
        }
        this.populateListeningPorts(proc.getPid(), productConfig, true);
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((Object)(this.getName() + " config: " + productConfig));
        }
        String installpath = WeblogicDetector.getCanonicalPath((String)(installDir.getPath() + File.separator + "servers" + File.separator + srvConfig.name));
        log.debug((Object)("[discoverServer] installDir=" + installDir));
        log.debug((Object)("[discoverServer] installpath=" + installpath));
        if (!new File(installpath).exists()) {
            installpath = WeblogicDetector.getCanonicalPath((String)installDir.getPath());
        }
        ArrayList<ServerResource> servers = new ArrayList<ServerResource>();
        ServerResource server = this.createServerResource(installpath);
        String name = this.getTypeInfo().getName() + " " + srvConfig.domain + " " + srvConfig.name;
        if (WeblogicProductPlugin.usePlatformName && WeblogicProductPlugin.NEW_DISCOVERY) {
            name = WeblogicDetector.getPlatformName() + " " + name;
        }
        server.setName(name);
        this.setIdentifier(server, name);
        log.debug((Object)("[discoverServer] identifier=" + server.getIdentifier()));
        this.setProductConfig(server, productConfig);
        this.setControlConfig(server, controlConfig);
        if (hasCreds) {
            server.setMeasurementConfig();
        }
        servers.add(server);
        installpath = WeblogicDetector.getInstallRoot(installpath);
        if (installpath != null) {
            this.adjustClassPath(installpath);
        }
        return servers;
    }

    private static boolean isAdminDir(String path) {
        if (path.startsWith("/")) {
            File config = new File(path, "config.xml.booted");
            return config.exists();
        }
        return false;
    }

    private List<WLSProcWithPid> getServerProcessList() {
        ArrayList<WLSProcWithPid> servers = new ArrayList<WLSProcWithPid>();
        long[] pids = WeblogicDetector.getPids((String)PTQL_QUERY);
        for (int i = 0; i < pids.length; ++i) {
            this.getLog().debug((Object)("pid = '" + pids[i] + "'"));
            String cwd = null;
            String name = null;
            String[] args = WeblogicDetector.getProcArgs((long)pids[i]);
            this.getLog().debug((Object)("[" + pids[i] + "] args = " + Arrays.asList(args)));
            if (this.isValidProc(args)) {
                this.getLog().debug((Object)("[" + pids[i] + "] is valid"));
                try {
                    cwd = WeblogicDetector.getSigar().getProcExe(pids[i]).getCwd();
                }
                catch (SigarException e) {
                    this.getLog().debug((Object)("[" + pids[i] + "] Error getting process info, reason: '" + e.getMessage() + "'"));
                }
                for (int j = 0; j < args.length; ++j) {
                    String path;
                    int ix;
                    String arg = args[j];
                    if (arg.startsWith("-Dweblogic.Name")) {
                        name = arg.substring(arg.indexOf("=") + 1).trim();
                        continue;
                    }
                    if (cwd != null || !arg.startsWith("-D") || (ix = arg.indexOf("=")) == -1 || !WeblogicDetector.isAdminDir(path = arg.substring(ix + 1).trim())) continue;
                    cwd = path;
                }
                this.getLog().debug((Object)("[" + pids[i] + "] cwd = '" + cwd + "' name = '" + name + "'"));
                if (cwd == null) continue;
                servers.add(new WLSProcWithPid(cwd, name, pids[i]));
                continue;
            }
            this.getLog().debug((Object)("[" + pids[i] + "] is not valid"));
        }
        return servers;
    }

    public abstract boolean isValidProc(String[] var1);

    private static String getInstallRoot(String installpath) {
        String jar = "server" + File.separator + "lib" + File.separator + "weblogic.jar";
        for (File dir = new File(installpath); dir != null; dir = dir.getParentFile()) {
            if (!new File(dir, jar).exists()) continue;
            return dir.getAbsolutePath();
        }
        return null;
    }

    public static String getRunningInstallPath() {
        String installpath = null;
        long[] pids = WeblogicDetector.getPids((String)PTQL_QUERY);
        block0: for (int i = 0; i < pids.length; ++i) {
            String[] args = WeblogicDetector.getProcArgs((long)pids[i]);
            for (int j = 1; j < args.length; ++j) {
                int ix;
                String arg = args[j];
                if (!arg.startsWith("-D") || (ix = arg.indexOf("=")) == -1) continue;
                if (arg.startsWith("=")) {
                    arg = arg.substring(1, arg.length());
                }
                if (!new File(arg = arg.substring(ix + 1).trim()).exists() || (installpath = WeblogicDetector.getInstallRoot(arg)) == null) continue;
                log.debug((Object)("weblogic.installpath=" + installpath + " (derived from " + args[j] + ")"));
                continue block0;
            }
        }
        return installpath;
    }

    protected List discoverServices(ConfigResponse config) throws PluginException {
        this.getLog().debug((Object)("[discoverServices] config=" + config));
        ArrayList services = new ArrayList();
        ArrayList<ServiceResource> aServices = new ArrayList<ServiceResource>();
        try {
            WeblogicDiscover discover = new WeblogicDiscover(this.getTypeInfo().getVersion(), config.toProperties());
            MBeanServer mServer = discover.getMBeanServer();
            discover.init(mServer);
            NodeManagerQuery nodemgrQuery = new NodeManagerQuery();
            ServerQuery serverQuery = new ServerQuery();
            serverQuery.setDiscover(discover);
            serverQuery.setName(config.getValue("server"));
            ArrayList servers = new ArrayList();
            discover.find(mServer, serverQuery, servers);
            WeblogicQuery[] serviceQueries = discover.getServiceQueries();
            for (int j = 0; j < serviceQueries.length; ++j) {
                WeblogicQuery serviceQuery = serviceQueries[j];
                serviceQuery.setParent(serverQuery);
                serviceQuery.setVersion(serverQuery.getVersion());
                discover.find(mServer, serviceQuery, services);
            }
            for (int k = 0; k < services.size(); ++k) {
                boolean valid = true;
                ServiceQuery service = (ServiceQuery)services.get(k);
                if (service instanceof ApplicationQuery) {
                    valid = ((ApplicationQuery)service).isEAR();
                }
                if (valid) {
                    aServices.add(WeblogicDetector.generateService(service));
                    continue;
                }
                log.debug((Object)("skipped service:" + service.getName()));
            }
        }
        catch (WeblogicDiscoverException ex) {
            this.getLog().debug((Object)ex.getMessage(), (Throwable)((Object)ex));
        }
        return aServices;
    }

    public static ServiceResource generateService(ServiceQuery service) throws PluginException {
        ServiceResource aiservice = new ServiceResource();
        ConfigResponse productConfig = new ConfigResponse((Map)service.getResourceConfig());
        ConfigResponse metricConfig = new ConfigResponse();
        ConfigResponse cprops = new ConfigResponse((Map)service.getCustomProperties());
        String notes = service.getDescription();
        if (notes != null) {
            aiservice.setDescription(notes);
        }
        aiservice.setType(service.getResourceName());
        String name = service.getResourceFullName();
        if (name.length() >= 200) {
            name = name.substring(0, 199);
        }
        aiservice.setName(name);
        if (service.hasControl() && !service.isServer61()) {
            ConfigResponse controlConfig = new ConfigResponse((Map)service.getControlConfig());
            aiservice.setControlConfig(controlConfig);
        }
        aiservice.setProductConfig(productConfig);
        aiservice.setMeasurementConfig(metricConfig);
        aiservice.setCustomProperties(cprops);
        if (service.hasResponseTime()) {
            ConfigResponse rtConfig = new ConfigResponse((Map)service.getResponseTimeConfig());
            aiservice.setResponseTimeConfig(rtConfig);
        }
        log.debug((Object)("discovered service: " + aiservice.getName()));
        return aiservice;
    }

    abstract void setIdentifier(ServerResource var1, String var2);

    private void populateListeningPorts(long pid, ConfigResponse productConfig, boolean b) {
        try {
            Class<?> du = Class.forName("org.hyperic.hq.product.DetectionUtil");
            Method plp = du.getMethod("populateListeningPorts", Long.TYPE, ConfigResponse.class, Boolean.TYPE);
            plp.invoke(null, pid, productConfig, b);
        }
        catch (ClassNotFoundException ex) {
            log.debug((Object)"[populateListeningPorts] Class 'DetectionUtil' not found", (Throwable)ex);
        }
        catch (NoSuchMethodException ex) {
            log.debug((Object)"[populateListeningPorts] Method 'populateListeningPorts' not found", (Throwable)ex);
        }
        catch (Exception ex) {
            log.debug((Object)"[populateListeningPorts] Problem with Method 'populateListeningPorts'", (Throwable)ex);
        }
    }

    protected class WLSProcWithPid
    extends WLSProc {
        protected long pid;

        public WLSProcWithPid(String path, String name, long pid) {
            super(path, name);
            this.pid = pid;
        }

        public long getPid() {
            return this.pid;
        }

        public void setPid(long pid) {
            this.pid = pid;
        }
    }

    public class WLSProc {
        private String path;
        private String name;

        public WLSProc(String path, String name) {
            this.path = path;
            this.name = name;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

