/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.weblogic;

import java.io.IOException;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.plugin.weblogic.WeblogicUtil;
import org.hyperic.hq.product.ControlPlugin;
import org.hyperic.hq.product.Metric;
import org.hyperic.hq.product.MetricNotFoundException;
import org.hyperic.hq.product.MetricUnreachableException;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.jmx.MBeanUtil;
import org.hyperic.util.config.ConfigResponse;

public class WeblogicServiceControlPlugin
extends ControlPlugin {
    private static final Log log = LogFactory.getLog(WeblogicServiceControlPlugin.class);

    public void doAction(String action, String[] args) throws PluginException {
        this.invokeMethod(action, args);
    }

    protected Object invoke(MBeanServerConnection mServer, String objectName, String method, Object[] args, String[] sig) throws MetricUnreachableException, MetricNotFoundException, PluginException {
        MBeanInfo info;
        ObjectName obj;
        try {
            obj = new ObjectName(objectName);
        }
        catch (MalformedObjectNameException e1) {
            throw new PluginException("Unable to create an ObjectName from " + objectName);
        }
        try {
            info = mServer.getMBeanInfo(obj);
        }
        catch (Exception e1) {
            throw new PluginException("Unable to obtain MBeanInfo from " + objectName);
        }
        if (sig.length == 0) {
            MBeanUtil.OperationParams params = MBeanUtil.getOperationParams((MBeanInfo)info, (String)method, (Object[])args);
            if (params.isAttribute) {
                if (method.startsWith("set")) {
                    try {
                        mServer.setAttribute(obj, new Attribute(method.substring(3), params.arguments[0]));
                    }
                    catch (AttributeNotFoundException e) {
                        throw new MetricNotFoundException(e.getMessage(), (Throwable)e);
                    }
                    catch (Exception e) {
                        throw new PluginException((Throwable)e);
                    }
                    return null;
                }
                try {
                    return mServer.getAttribute(obj, method.substring(3));
                }
                catch (AttributeNotFoundException e) {
                    throw new MetricNotFoundException(e.getMessage(), (Throwable)e);
                }
                catch (Exception e) {
                    throw new PluginException((Throwable)e);
                }
            }
            sig = params.signature;
            args = params.arguments;
        }
        try {
            return mServer.invoke(obj, method, args, sig);
        }
        catch (Exception e) {
            throw new PluginException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invokeMethod(ControlPlugin plugin, String objectName, String action, String[] args) {
        JMXConnector jmxConnector;
        log.debug((Object)("invoking " + action + " " + MBeanUtil.anyToString((Object)args)));
        try {
            jmxConnector = WeblogicUtil.getManagedServerConnection(plugin.getConfig().toProperties());
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            plugin.setMessage(e.getMessage());
            plugin.setResult(-1);
            return;
        }
        try {
            String result = null;
            Object obj = this.invoke(jmxConnector.getMBeanServerConnection(), objectName, action, args, new String[0]);
            if (obj != null) {
                result = MBeanUtil.anyToString((Object)obj);
            }
            log.debug((Object)(objectName + "." + action + "() returned: " + obj));
            plugin.setResult(0);
            if (result != null) {
                plugin.setMessage(result);
            }
        }
        catch (PluginException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            plugin.setMessage(e.getMessage());
            plugin.setResult(-1);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            plugin.setMessage(e.getMessage());
            plugin.setResult(-1);
        }
        finally {
            try {
                jmxConnector.close();
            }
            catch (IOException e) {
                log.warn((Object)"Error closing remote JMX connection", (Throwable)e);
            }
        }
    }

    protected void invokeMethod(String action, String[] args) {
        String objectName = this.getTypeProperty("OBJECT_NAME");
        objectName = Metric.translate((String)objectName, (ConfigResponse)this.getConfig());
        this.invokeMethod(this, objectName, action, args);
    }
}

