/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.weblogic.jmx;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.plugin.weblogic.jmx.AttributeLister;

public class AttributeGetter {
    public static final String PROP_ATTR_EXPIRE = "weblogic.attrcache.expire";
    private static Log log = LogFactory.getLog(AttributeGetter.class);
    private static Map attrCache = Collections.synchronizedMap(new HashMap());
    private static final int MINUTE = 60000;
    private static final int EXPIRE_DEFAULT = 300000;
    private long timestamp = 0L;
    private int expire = 300000;
    private HashMap values = new HashMap();
    private String[] attrs;
    private ObjectName name;

    public static AttributeGetter getInstance(AttributeLister lister, ObjectName name) {
        AttributeGetter getter = (AttributeGetter)attrCache.get(name);
        if (getter == null) {
            String[] attrs = lister.getAttributeNames(name);
            if (attrs == null) {
                return null;
            }
            getter = new AttributeGetter();
            getter.attrs = attrs;
            getter.name = name;
            String expire = System.getProperty(PROP_ATTR_EXPIRE);
            if (expire != null) {
                getter.expire = Integer.parseInt(expire) * 60000;
            }
            log.debug((Object)(name + " expire=" + getter.expire / 60000));
            attrCache.put(name, getter);
        }
        return getter;
    }

    public Object getAttribute(MBeanServer server, String attrName) throws InstanceNotFoundException, ReflectionException, AttributeNotFoundException {
        Object value;
        long timeNow = System.currentTimeMillis();
        if (timeNow - this.timestamp > (long)this.expire) {
            AttributeList attrList;
            if (log.isDebugEnabled()) {
                log.debug((Object)("server.getAttributes(" + this.name + ", " + Arrays.asList(this.attrs) + ")"));
            }
            if ((attrList = server.getAttributes(this.name, this.attrs)) == null) {
                throw new AttributeNotFoundException(this.name.toString());
            }
            for (Attribute attr : attrList) {
                this.values.put(attr.getName(), attr.getValue());
            }
            this.timestamp = timeNow;
        }
        if ((value = this.values.get(attrName)) == null) {
            throw new AttributeNotFoundException(attrName);
        }
        return value;
    }
}

