/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.weblogic.jmx;

import java.util.HashMap;
import javax.management.ObjectName;
import org.hyperic.hq.plugin.weblogic.jmx.AttributeLister;

public final class WeblogicAttributes
implements AttributeLister {
    private static final HashMap ATTR_NAMES;
    public static final WeblogicAttributes instance;
    private static final String[] ApplicationConfig;
    private static final String[] ConnectorServiceRuntime;
    private static final String[] EJBComponentRuntime;
    private static final String[] ExecuteQueueRuntime;
    private static final String[] JDBCConnectionPoolRuntime;
    private static final String[] JMSDestinationRuntime;
    private static final String[] JMSRuntime;
    private static final String[] JMSServerRuntime;
    private static final String[] JTARuntime;
    private static final String[] JVMRuntime;
    private static final String[] ServerRuntime;
    private static final String[] ServerSecurityRuntime;
    private static final String[] TimeServiceRuntime;
    private static final String[] TransactionResourceRuntime;
    private static final String[] WebAppComponentRuntime;

    public String[] getAttributeNames(ObjectName name) {
        return (String[])ATTR_NAMES.get(name.getKeyProperty("Type"));
    }

    static {
        ApplicationConfig = new String[]{"Deployed"};
        ConnectorServiceRuntime = new String[]{"ConnectionPoolCurrentCount", "ConnectionPoolsTotalCount"};
        EJBComponentRuntime = new String[]{"Name", "Status"};
        ExecuteQueueRuntime = new String[]{"ExecuteThreadCurrentIdleCount", "Name", "PendingRequestCurrentCount", "ServicedRequestTotalCount"};
        JDBCConnectionPoolRuntime = new String[]{"ActiveConnectionsCurrentCount", "ActiveConnectionsHighCount", "ConnectionsTotalCount", "FailuresToReconnectCount", "LeakedConnectionCount", "MaxCapacity", "PoolState", "WaitSecondsHighCount", "WaitingForConnectionCurrentCount", "WaitingForConnectionHighCount"};
        JMSDestinationRuntime = new String[]{"BytesCurrentCount", "BytesHighCount", "BytesPendingCount", "BytesReceivedCount", "BytesThresholdTime", "ConsumersCurrentCount", "ConsumersHighCount", "ConsumersTotalCount", "MessagesCurrentCount", "MessagesHighCount", "MessagesPendingCount", "MessagesReceivedCount", "MessagesThresholdTime", "Name"};
        JMSRuntime = new String[]{"ConnectionsCurrentCount", "ConnectionsHighCount", "ConnectionsTotalCount", "JMSServersCurrentCount", "JMSServersHighCount", "JMSServersTotalCount"};
        JMSServerRuntime = new String[]{"BytesCurrentCount", "BytesHighCount", "BytesPendingCount", "BytesReceivedCount", "BytesThresholdTime", "DestinationsCurrentCount", "DestinationsHighCount", "DestinationsTotalCount", "MessagesCurrentCount", "MessagesHighCount", "MessagesPendingCount", "MessagesReceivedCount", "MessagesThresholdTime", "Name", "SessionPoolsCurrentCount", "SessionPoolsHighCount", "SessionPoolsTotalCount"};
        JTARuntime = new String[]{"ActiveTransactionsTotalCount", "SecondsActiveTotalCount", "TransactionAbandonedTotalCount", "TransactionCommittedTotalCount", "TransactionHeuristicsTotalCount", "TransactionRolledBackAppTotalCount", "TransactionRolledBackResourceTotalCount", "TransactionRolledBackSystemTotalCount", "TransactionRolledBackTimeoutTotalCount", "TransactionRolledBackTotalCount", "TransactionTotalCount"};
        JVMRuntime = new String[]{"HeapFreeCurrent", "HeapSizeCurrent"};
        ServerRuntime = new String[]{"OpenSocketsCurrentCount", "RestartsTotalCount", "SocketsOpenedTotalCount", "State", "StateVal"};
        ServerSecurityRuntime = new String[]{"InvalidLoginAttemptsTotalCount", "InvalidLoginUsersHighCount", "LoginAttemptsWhileLockedTotalCount", "UnlockedUsersTotalCount", "UserLockoutTotalCount"};
        TimeServiceRuntime = new String[]{"ExceptionCount", "ExecutionsPerMinute", "ScheduledTriggerCount"};
        TransactionResourceRuntime = new String[]{"Name", "TransactionCommittedTotalCount", "TransactionHeuristicCommitTotalCount", "TransactionHeuristicHazardTotalCount", "TransactionHeuristicMixedTotalCount", "TransactionHeuristicRollbackTotalCount", "TransactionHeuristicsTotalCount", "TransactionRolledBackTotalCount", "TransactionTotalCount"};
        WebAppComponentRuntime = new String[]{"OpenSessionsCurrentCount", "OpenSessionsHighCount", "SessionsOpenedTotalCount", "Status"};
        HashMap<String, String[]> attrs = new HashMap<String, String[]>();
        instance = new WeblogicAttributes();
        attrs.put("ApplicationConfig", ApplicationConfig);
        attrs.put("ConnectorServiceRuntime", ConnectorServiceRuntime);
        attrs.put("ExecuteQueueRuntime", ExecuteQueueRuntime);
        attrs.put("JDBCConnectionPoolRuntime", JDBCConnectionPoolRuntime);
        attrs.put("JMSDestinationRuntime", JMSDestinationRuntime);
        attrs.put("JMSRuntime", JMSRuntime);
        attrs.put("JMSServerRuntime", JMSServerRuntime);
        attrs.put("JTARuntime", JTARuntime);
        attrs.put("JVMRuntime", JVMRuntime);
        attrs.put("ServerSecurityRuntime", ServerSecurityRuntime);
        attrs.put("TimeServiceRuntime", TimeServiceRuntime);
        attrs.put("TransactionResourceRuntime", TransactionResourceRuntime);
        attrs.put("WebAppComponentRuntime", WebAppComponentRuntime);
        ATTR_NAMES = attrs;
    }
}

