/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.weblogic.jmx;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.plugin.weblogic.WeblogicConfig;

public class WeblogicQuery {
    protected static final String ATTR_NOTES = "Notes";
    protected Map attrs = new HashMap();
    private WeblogicQuery parent;
    private String name;
    private String version;
    private static final WeblogicQuery[] NOOP_CHILD_QUERIES = new WeblogicQuery[0];
    private static final String[] NOOP_ATTRIBUTE_NAMES = new String[0];
    private static final Properties NOOP_PROPERTIES = new Properties();
    private static final Log log = LogFactory.getLog(WeblogicQuery.class);

    public WeblogicQuery cloneInstance() {
        WeblogicQuery query;
        try {
            query = (WeblogicQuery)this.getClass().newInstance();
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        query.setParent(this.getParent());
        query.setName(this.getName());
        query.setVersion(this.getVersion());
        return query;
    }

    public String[] getAttributeNames() {
        return NOOP_ATTRIBUTE_NAMES;
    }

    public String[] getCustomPropertiesNames() {
        return NOOP_ATTRIBUTE_NAMES;
    }

    public boolean getAttributes(MBeanServer mServer, ObjectName name) {
        return this.getAttributes(mServer, name, this.getAttributeNames());
    }

    protected void logAttrFailure(ObjectName name, String[] attrNames, Exception e) {
        if (log.isDebugEnabled()) {
            String msg = "attributes " + Arrays.asList(attrNames) + " not found for '" + name + "' : " + e;
            log.debug((Object)msg);
        }
    }

    public boolean getAttributes(MBeanServer mServer, ObjectName name, String[] attrNames) {
        AttributeList list;
        if (name == null) {
            return false;
        }
        if (attrNames.length == 0) {
            this.setName(name.getKeyProperty("Name"));
            return true;
        }
        try {
            list = mServer.getAttributes(name, attrNames);
        }
        catch (InstanceNotFoundException e) {
            this.logAttrFailure(name, attrNames, e);
            return false;
        }
        catch (ReflectionException e) {
            this.logAttrFailure(name, attrNames, e);
            return false;
        }
        if (list == null) {
            return false;
        }
        for (int i = 0; i < list.size(); ++i) {
            Attribute attr = (Attribute)list.get(i);
            Object obj = attr.getValue();
            if (obj == null) continue;
            this.attrs.put(attr.getName(), obj.toString());
        }
        return true;
    }

    public String getAttribute(String name) {
        return (String)this.attrs.get(name);
    }

    public String getAttribute(String name, String defval) {
        String attr = this.getAttribute(name);
        if (attr == null) {
            return defval;
        }
        return attr;
    }

    public WeblogicQuery[] getChildQueries() {
        return NOOP_CHILD_QUERIES;
    }

    public String getResourceType() {
        return null;
    }

    public String getPropertyName() {
        return null;
    }

    public String getMBeanType() {
        return null;
    }

    public String getMBeanAlias() {
        return this.getMBeanType();
    }

    public String getMBeanNameProperty() {
        return this.getName();
    }

    public boolean skipParentScope() {
        return false;
    }

    public String getScope() {
        StringBuffer scope = new StringBuffer();
        scope.append("Type=");
        scope.append(this.getMBeanType());
        for (WeblogicQuery query = this.getParent(); query != null; query = query.getParent()) {
            if (this.skipParentScope()) continue;
            scope.append(",");
            scope.append(query.getMBeanAlias());
            scope.append("=");
            scope.append(query.getMBeanNameProperty());
        }
        return scope.toString();
    }

    public WeblogicQuery getParent() {
        return this.parent;
    }

    public WeblogicQuery getResourceParent() {
        return this.getParent();
    }

    public String getResourceName() {
        return this.getResourceParent().getResourceType() + " " + this.getResourceType();
    }

    public String getFullName() {
        StringBuffer name = new StringBuffer();
        ArrayList<String> names = new ArrayList<String>();
        WeblogicQuery query = this;
        do {
            names.add(query.getQualifiedName());
        } while ((query = query.getParent()) != null);
        for (int i = names.size() - 1; i >= 0; --i) {
            name.append(names.get(i));
            if (i == 0) continue;
            name.append(" ");
        }
        return name.toString();
    }

    public String getResourceFullName() {
        return "Weblogic " + this.getFullName() + " " + this.getResourceType();
    }

    public void setParent(WeblogicQuery value) {
        this.parent = value;
    }

    public String getQualifiedName() {
        return this.getName();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isServer61() {
        return WeblogicQuery.isServer61(this.version);
    }

    public static boolean isServer61(String version) {
        return "6.1".equals(version);
    }

    public boolean isServer91() {
        return WeblogicQuery.isServer91(this.version);
    }

    public static boolean isServer91(String version) {
        return WeblogicConfig.majorVersion(version) >= 9;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getDescription() {
        return null;
    }

    public void configure(Properties props) {
        props.setProperty(this.getPropertyName(), this.getName());
    }

    public boolean hasControl() {
        return true;
    }

    public Properties getControlConfig() {
        return NOOP_PROPERTIES;
    }

    public boolean hasResponseTime() {
        Properties config = this.getResponseTimeConfig();
        return config != NOOP_PROPERTIES;
    }

    public Properties getResponseTimeConfig() {
        return NOOP_PROPERTIES;
    }

    public Properties getResourceConfig() {
        Properties props = new Properties();
        this.configure(props);
        return props;
    }

    public Properties getCustomProperties() {
        String[] names = this.getCustomPropertiesNames();
        if (names.length == 0) {
            return NOOP_PROPERTIES;
        }
        Properties cprops = new Properties();
        for (int i = 0; i < names.length; ++i) {
            String value = this.getAttribute(names[i]);
            if (value == null) continue;
            cprops.setProperty(names[i], value);
        }
        return cprops;
    }
}

