/*
 * Decompiled with CFR 0.152.
 */
package com.hyperic.hq.plugin.system;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VMGuestAppMonitor {
    public static final String RESET_VM_FLAG = "appStateNeedReset";
    private static final String BUGUS_FLAG = "BOGUS_FLAG";
    static Log log = LogFactory.getLog(VMGuestAppMonitor.class);

    public native int postState(String var1);

    public native String getAppStatus();

    public static void printError(int res) {
        switch (res) {
            case 0: {
                System.out.println("No error");
                break;
            }
            case 1: {
                System.out.println("Other error");
                break;
            }
            case 2: {
                System.out.println("Not running in a VM");
                break;
            }
            case 3: {
                System.out.println("Monitoring is not enabled");
                break;
            }
            case 4: {
                System.out.println("Monitoring is not supported");
            }
        }
    }

    public final ReturnCodeType requestStatusChange(String newStatus) {
        int returnCode = this.postState(newStatus);
        ReturnCodeType enumReturnCode = ReturnCodeType.valueOf(returnCode);
        log.info((Object)("[" + this.getClass().getName() + ".requestStatusChange()]: return code: " + returnCode + "(" + enumReturnCode.name() + ")"));
        return enumReturnCode;
    }

    public final ReturnCodeType reset_VM() {
        ReturnCodeType enumReturnCode = this.requestStatusChange(RESET_VM_FLAG);
        if (enumReturnCode != ReturnCodeType.Success) {
            throw new UnsupportedOperationException("Unable to reset VM due to : " + enumReturnCode.name());
        }
        return enumReturnCode;
    }

    public final ReturnCodeType reset_platform() {
        return this.reset_VM();
    }

    public final boolean isClientSupported() {
        ReturnCodeType enumReturnCode = this.requestStatusChange(BUGUS_FLAG);
        return enumReturnCode == ReturnCodeType.OtherError;
    }

    public static void main(String[] args) throws Exception {
        VMGuestAppMonitor appMon = new VMGuestAppMonitor();
        VMGuestAppMonitor.printError(appMon.postState("needReset"));
        System.out.println(appMon.getAppStatus());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ReturnCodeType {
        Success,
        OtherError,
        PhysicalMachineContext,
        MonitoringDisabled,
        MonitoringUnsupported,
        Unknown;


        private static final ReturnCodeType valueOf(int returnCode) {
            ReturnCodeType[] values = ReturnCodeType.values();
            return returnCode >= values.length - 1 ? Unknown : values[returnCode];
        }
    }
}

