/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.system;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.hyperic.hq.appdef.shared.AIServiceValue;
import org.hyperic.hq.plugin.system.SystemPlugin;
import org.hyperic.hq.plugin.system.SystemServerDetector;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.PluginManager;
import org.hyperic.sigar.FileInfo;
import org.hyperic.sigar.FileSystem;
import org.hyperic.sigar.FileSystemMap;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.win32.Pdh;
import org.hyperic.util.StringUtil;
import org.hyperic.util.config.ConfigResponse;
import org.hyperic.util.config.EncodingException;
import org.hyperic.util.security.MD5;

public class FileSystemDetector
extends SystemServerDetector {
    private static final String PROP_DISCOVER_NFS = "system.nfs.discover";
    private boolean _discoverNfs;

    public void init(PluginManager manager) throws PluginException {
        super.init(manager);
        this._discoverNfs = "true".equals(manager.getProperty(PROP_DISCOVER_NFS));
    }

    protected String getServerType() {
        return "FileServer";
    }

    protected ArrayList getSystemServiceValues(Sigar sigar, ConfigResponse config) throws SigarException {
        ArrayList<AIServiceValue> services = new ArrayList<AIServiceValue>();
        if (FileSystemDetector.isWin32()) {
            List<String> disks = Arrays.asList(Pdh.getInstances((String)"PhysicalDisk"));
            for (String disk : disks) {
                if (disk.equalsIgnoreCase("_total")) continue;
                AIServiceValue svc = this.createSystemService(SystemPlugin.PHYSICAL_DISK_SERVICE, this.getFullServiceName(disk), "name", disk);
                services.add(svc);
            }
        }
        FileSystem[] fslist = sigar.getFileSystemList();
        block4: for (int i = 0; i < fslist.length; ++i) {
            FileSystem fs = fslist[i];
            String dirName = fs.getDirName();
            switch (fs.getType()) {
                case 2: 
                case 3: {
                    break;
                }
                default: {
                    continue block4;
                }
            }
            String genericType = fs.getTypeName();
            String type = fs.getSysTypeName();
            String mntInfo = "";
            if (!fs.getDevName().equals(dirName)) {
                mntInfo = " mounted on " + dirName;
            }
            String info = "File System " + fs.getDevName() + mntInfo + " (" + genericType + "/" + type + ")";
            if (fs.getType() == 3 && !this._discoverNfs) {
                this.getLog().debug((Object)("system.nfs.discover=false, skipping " + info));
                continue;
            }
            AIServiceValue svc = this.createSystemService(SystemPlugin.FILE_MOUNT_SERVICE, this.getFullServiceName(info), "mount", dirName);
            services.add(svc);
        }
        String[] fileTypes = new String[]{SystemPlugin.FILE_SERVICE, SystemPlugin.DIR_SERVICE, SystemPlugin.DIR_TREE_SERVICE, "Script"};
        for (int i = 0; i < fileTypes.length; ++i) {
            String type = fileTypes[i];
            services.addAll(this.getFileServices(sigar, type));
            services.addAll(this.getFileServiceImports(sigar, type));
        }
        return services;
    }

    private boolean canRead(File file) {
        if (!file.exists()) {
            log.warn((Object)(file + ": does not exist"));
            return false;
        }
        if (!file.canRead()) {
            log.warn((Object)(file + ": cannot read"));
            return false;
        }
        return true;
    }

    private List getFileServiceImports(Sigar sigar, String type) {
        ArrayList<AIServiceValue> services = new ArrayList<AIServiceValue>();
        String prop = "system." + type + ".import";
        String val = this.getManagerProperty(prop);
        if (val == null) {
            return services;
        }
        log.debug((Object)("Importing " + prop + "=" + val));
        List files = StringUtil.explode((String)val, (String)",");
        boolean isDirType = type.indexOf("Directory") != -1;
        for (int i = 0; i < files.size(); ++i) {
            File file;
            boolean recurse;
            String path = (String)files.get(i);
            boolean bl = recurse = path.charAt(0) == '+';
            if (recurse) {
                path = path.substring(1);
            }
            if (!this.canRead(file = new File(path))) continue;
            boolean isDir = file.isDirectory();
            if (isDirType && !isDir) {
                log.warn((Object)(file + ": not a directory"));
                continue;
            }
            if (isDirType && isDir || !isDir) {
                AIServiceValue svc = this.createSystemService(type, path, "path", path);
                this.setFileProperties(sigar, svc, path);
                services.add(svc);
                continue;
            }
            this.addFileServices(services, recurse, file, sigar, type);
        }
        return services;
    }

    private void addFileServices(List services, boolean recurse, File dir, Sigar sigar, String type) {
        String[] dents = dir.list();
        if (dents == null) {
            log.warn((Object)(dir + ": failed to list"));
            return;
        }
        for (int i = 0; i < dents.length; ++i) {
            File ent = new File(dir, dents[i]);
            String path = ent.getPath();
            if (!this.canRead(ent)) continue;
            if (ent.isDirectory()) {
                if (!recurse) continue;
                this.addFileServices(services, recurse, ent, sigar, type);
                continue;
            }
            AIServiceValue svc = this.createSystemService(type, path, "path", path);
            this.setFileProperties(sigar, svc, path);
            services.add(svc);
        }
    }

    private List getFileServices(Sigar sigar, String type) {
        boolean isDebug = log.isDebugEnabled();
        List serviceConfigs = this.getServiceConfigs(type);
        ArrayList<AIServiceValue> services = new ArrayList<AIServiceValue>();
        for (int i = 0; i < serviceConfigs.size(); ++i) {
            ConfigResponse serviceConfig = (ConfigResponse)serviceConfigs.get(i);
            String name = serviceConfig.getValue("resource.name");
            String file = serviceConfig.getValue("path");
            AIServiceValue svc = this.createSystemService(type, name);
            if (isDebug) {
                log.debug((Object)("Getting cprops for " + name + " " + type + "=" + file));
            }
            this.setFileProperties(sigar, svc, file);
            services.add(svc);
        }
        return services;
    }

    private void setFileProperties(Sigar sigar, AIServiceValue svc, String file) {
        ConfigResponse cprops = new ConfigResponse();
        boolean isDirectory = new File(file).isDirectory();
        if (!isDirectory) {
            try {
                cprops.setValue("md5", MD5.getDigestString((File)new File(file)));
            }
            catch (IOException e) {
                this.getLog().debug((Object)("Error getting md5 for " + file + ": " + e));
            }
        }
        if (!FileSystemDetector.isWin32()) {
            try {
                FileInfo info = sigar.getFileInfo(file);
                cprops.setValue("permissions", info.getPermissionsString());
            }
            catch (SigarException e) {
                // empty catch block
            }
        }
        try {
            FileSystemMap mounts = sigar.getFileSystemMap();
            FileSystem fs = mounts.getMountPoint(file);
            if (fs != null) {
                cprops.setValue("fs", fs.getDirName());
            }
        }
        catch (SigarException e) {
            // empty catch block
        }
        try {
            svc.setCustomProperties(cprops.encode());
        }
        catch (EncodingException e) {
            this.getLog().error((Object)("Error encoding cprops: " + e.getMessage()));
        }
    }
}

