/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.cm.filemonitor;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.hyperic.cm.filemonitor.ChangeEventProcessor;
import org.hyperic.cm.filemonitor.ConfigProcessor;
import org.hyperic.cm.filemonitor.FileMonitor;
import org.hyperic.cm.filemonitor.Watcher;
import org.hyperic.cm.filemonitor.data.EventMessage;
import org.hyperic.cm.filemonitor.dto.AgentConfigurationDto;
import org.hyperic.cm.versioncontrol.ApplicationConfigVersionControl;
import org.hyperic.cm.versioncontrol.api.IVersionControlDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportResource;
import org.springframework.oxm.Unmarshaller;
import org.springframework.oxm.jaxb.Jaxb2Marshaller;

@Configuration
@Import(value={ApplicationConfigVersionControl.class})
@ImportResource(value={"classpath:/application-context.xml"})
public class ApplicationConfigFsmonitor {
    @Autowired
    IVersionControlDao versionControlDao;
    private static BlockingQueue<EventMessage> senderQueue = new ArrayBlockingQueue<EventMessage>(1000, true);

    @Bean(destroyMethod="onDestroy")
    public ChangeEventProcessor changeEventProcessor() {
        ChangeEventProcessor processor = new ChangeEventProcessor(senderQueue);
        return processor;
    }

    @Bean
    public ConfigProcessor configProcessor() {
        return new ConfigProcessor();
    }

    @Bean
    public Watcher watcher() {
        return new Watcher(senderQueue);
    }

    @Bean(destroyMethod="stop")
    public FileMonitor fileMonitor() {
        return new FileMonitor();
    }

    @Bean
    public Unmarshaller xmlUnmarshaller() {
        Jaxb2Marshaller marshaller = new Jaxb2Marshaller();
        marshaller.setClassesToBeBound(new Class[]{AgentConfigurationDto.class});
        return marshaller;
    }
}

