/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.cm.filemonitor;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.hyperic.cm.filemonitor.ApplicationConfigFsmonitor;
import org.hyperic.cm.filemonitor.BaselineAdder;
import org.hyperic.cm.filemonitor.ChangeEventProcessor;
import org.hyperic.cm.filemonitor.ConfigProcessor;
import org.hyperic.cm.filemonitor.IChangeListener;
import org.hyperic.cm.filemonitor.IFileMonitor;
import org.hyperic.cm.filemonitor.MonitorStatus;
import org.hyperic.cm.filemonitor.Watcher;
import org.hyperic.cm.filemonitor.data.EventActionsEnum;
import org.hyperic.cm.filemonitor.data.EventMessage;
import org.hyperic.cm.filemonitor.data.WatchedDirInfo;
import org.hyperic.cm.filemonitor.dto.AgentConfigurationDto;
import org.hyperic.cm.filemonitor.dto.ConfigDefDto;
import org.hyperic.cm.filemonitor.dto.TemplateDto;
import org.hyperic.cm.filemonitor.standalone.ChangeListenerObj;
import org.hyperic.cm.filemonitor.utils.FileWalker;
import org.hyperic.cm.versioncontrol.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.oxm.Unmarshaller;
import org.springframework.oxm.XmlMappingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileMonitor
implements IFileMonitor,
IChangeListener {
    private static BlockingQueue<String> messageQueue = null;
    public static FileMonitor fileMonitor = null;
    @Autowired
    private ChangeEventProcessor changeEventProcessor;
    @Autowired
    private ConfigProcessor configProcessor;
    @Autowired
    private Watcher watcher;
    private MonitorStatus status = MonitorStatus.STOPPED;
    private static Logger log = LoggerFactory.getLogger(FileMonitor.class);
    private Map<String, IChangeListener> folderListenerMap = new HashMap<String, IChangeListener>();
    private Collection<IChangeListener> listeners;
    private static FileMonitor instance = FileMonitor.getSpringInstance();
    private static ApplicationContext context;
    @Autowired
    private Unmarshaller xmlUnmarshaller;

    protected FileMonitor() {
        if (log.isInfoEnabled()) {
            log.info("Creating Frantic agent.");
        }
    }

    public static FileMonitor getInstance() {
        return instance;
    }

    private static FileMonitor getSpringInstance() {
        if (context == null) {
            context = new AnnotationConfigApplicationContext(new Class[]{ApplicationConfigFsmonitor.class});
        }
        FileMonitor fma = (FileMonitor)context.getBean("fileMonitor", FileMonitor.class);
        return fma;
    }

    private void generateBaselineEvents(Map<String, WatchedDirInfo> dirsMap) {
        for (String path : dirsMap.keySet()) {
            log.info("generateBaselineEvents for " + path);
            WatchedDirInfo info = dirsMap.get(path);
            BaselineAdder callable = new BaselineAdder(this.watcher, info.isRecursive(), info.getFilter());
            FileWalker.walkDfs(new File(path), callable);
        }
        this.watcher.simulateEvent(EventActionsEnum.REGISTER_COMPLETE, null, null);
    }

    private Map<String, WatchedDirInfo> getMonitoredFolderMap(String installPath, Collection<ConfigDefDto> configDefDtos) {
        HashMap<String, WatchedDirInfo> dirsMap = new HashMap<String, WatchedDirInfo>();
        for (ConfigDefDto configDef : configDefDtos) {
            this.configProcessor.process(dirsMap, installPath, configDef);
        }
        return dirsMap;
    }

    private Collection<String> addMonitoredDirs(String installPath, List<ConfigDefDto> configDefs, IChangeListener listener) {
        Map<String, WatchedDirInfo> dirsMap = this.getMonitoredFolderMap(installPath, configDefs);
        this.generateBaselineEvents(dirsMap);
        if (listener != null) {
            for (String dir : dirsMap.keySet()) {
                this.folderListenerMap.put(dir, listener);
            }
        }
        this.watcher.addUpdateWatchedDirs(dirsMap);
        return dirsMap.keySet();
    }

    @Override
    public Collection<String> addMonitoredDirs(String basePath, String xml, IChangeListener listener) {
        Collection<TemplateDto> tDtos = this.xmlToDtos(xml);
        if (tDtos == null || tDtos.size() <= 0) {
            return null;
        }
        ArrayList<String> addedFolders = new ArrayList<String>();
        for (TemplateDto tDto : tDtos) {
            Collection<String> added = this.addMonitoredDirs(basePath, tDto.getConfigDefs(), listener);
            addedFolders.addAll(added);
        }
        return addedFolders;
    }

    public Collection<TemplateDto> xmlToDtos(String xml) {
        StringReader reader = new StringReader(xml);
        StreamSource source = new StreamSource(reader);
        AgentConfigurationDto configDto = this.loadTemplatesFromXml(source);
        List<TemplateDto> tDtos = configDto.getTemplates();
        return tDtos;
    }

    @Override
    public void removeMonitoredDirs(Collection<String> monitoredPaths) {
        for (String dir : monitoredPaths) {
            this.folderListenerMap.remove(dir);
        }
        this.watcher.removeWatchedDirs(monitoredPaths);
    }

    public void addConfigFiles(String installPath, Collection<ConfigDefDto> configDefDtos) {
        Map<String, WatchedDirInfo> dirsMap = this.getMonitoredFolderMap(installPath, configDefDtos);
        this.generateBaselineEvents(dirsMap);
        this.watcher.addUpdateWatchedDirs(dirsMap);
    }

    @Override
    public void setAppDataDir(String path) {
        log.info("File Monitor appDataDir set to " + path);
        this.changeEventProcessor.setVersionContorlDir(path);
    }

    @Override
    public void setMaxDiffSize(Long sizeInKb) {
        this.changeEventProcessor.setMaxDiffSize(sizeInKb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        MonitorStatus monitorStatus = this.status;
        synchronized (monitorStatus) {
            log.info("Entered FileMonitor.start()");
            if (this.status == MonitorStatus.STOPPED) {
                Thread rocessorThread = new Thread((Runnable)this.changeEventProcessor, ChangeEventProcessor.class.getSimpleName());
                rocessorThread.start();
                Thread t = new Thread((Runnable)this.watcher, Watcher.class.getSimpleName());
                t.start();
                this.status = MonitorStatus.STARTED;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        MonitorStatus monitorStatus = this.status;
        synchronized (monitorStatus) {
            log.info("Entered FileMonitor.stop()");
            if (this.status != MonitorStatus.STOPPED) {
                this.watcher.stopWatching();
                this.changeEventProcessor.setStop(true);
                this.status = MonitorStatus.STOPPED;
            }
        }
    }

    @Override
    public void onChange(EventMessage item) {
        if (EventActionsEnum.REGISTER.equals((Object)item.getType())) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("---BENCHMARK--- onChange event start");
        }
        if (this.folderListenerMap.size() > 0) {
            boolean suspectedDir;
            File f;
            String evPath = EventActionsEnum.RENAME == item.getType() ? item.getOldFullPath() : item.getFullPath();
            IChangeListener listener = null;
            String path = evPath;
            File file = f = path == null ? null : new File(path);
            if (f == null) {
                log.error("FileMonitor onChange(EventMessage item) - Path is null for event: " + (Object)((Object)item.getType()) + ", old path: " + item.getOldFullPath() + ", new path: " + item.getFullPath());
                return;
            }
            boolean bl = suspectedDir = Utils.getFileExtension((String)f.getName()) == null;
            if (!suspectedDir) {
                String string = path = f == null ? null : f.getParent();
            }
            while (path != null) {
                IChangeListener iChangeListener = listener = path == null ? null : this.folderListenerMap.get(path);
                if (listener == null) {
                    path = f.getParent();
                    File file2 = f = path == null ? null : new File(path);
                }
                if (listener == null) continue;
            }
            if (listener != null) {
                listener.onChange(item);
            } else if (suspectedDir && EventActionsEnum.DELETE.equals((Object)item.getType())) {
                HashSet<IChangeListener> lSet = new HashSet<IChangeListener>();
                for (Map.Entry<String, IChangeListener> entry : this.folderListenerMap.entrySet()) {
                    if (!entry.getKey().startsWith(evPath)) continue;
                    lSet.add(entry.getValue());
                }
                if (lSet.size() > 0) {
                    for (IChangeListener l : lSet) {
                        l.onChange(item);
                    }
                } else {
                    log.warn("No listener mapped for file event: " + evPath);
                }
            } else {
                log.warn("No listener mapped for file event: " + evPath);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("---BENCHMARK--- onChange before fire");
        }
        if (this.listeners != null) {
            for (IChangeListener listener : this.listeners) {
                listener.onChange(item);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("---BENCHMARK--- onChange event fired");
        }
    }

    @Override
    public void addListener(IChangeListener listener) {
        if (this.listeners == null) {
            this.listeners = new LinkedList<IChangeListener>();
        }
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(IChangeListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    @Override
    public MonitorStatus getStatus() {
        return this.status;
    }

    public AgentConfigurationDto loadTemplatesFromXml() throws IOException {
        InputStream in = this.getClass().getResourceAsStream("kb.xml");
        AgentConfigurationDto conf = this.loadTemplatesFromXml(in);
        in.close();
        return conf;
    }

    public AgentConfigurationDto loadTemplatesFromXml(InputStream is) {
        StreamSource source = new StreamSource(is);
        return this.loadTemplatesFromXml(source);
    }

    private AgentConfigurationDto loadTemplatesFromXml(Source source) {
        Object obj = null;
        try {
            obj = this.xmlUnmarshaller.unmarshal(source);
        }
        catch (XmlMappingException e) {
            log.error("Could not parse the configuration XML", (Throwable)e);
        }
        catch (IOException e) {
            log.error("Could not read the XML stream", (Throwable)e);
        }
        if (!(obj instanceof AgentConfigurationDto)) {
            log.error("Given XML is not a valid configuration");
            return null;
        }
        return (AgentConfigurationDto)obj;
    }

    public static void main(String[] args) {
        TemplateDto template;
        String tAppName;
        if (args.length < 2) {
            System.out.println("Usage: <install path> <app name>");
            return;
        }
        String installPath = args[0];
        String appName = args[1];
        FileMonitor fm = FileMonitor.getInstance();
        AgentConfigurationDto conf = null;
        try {
            conf = fm.loadTemplatesFromXml();
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        if (conf == null || conf.getTemplates() == null || conf.getTemplates().size() <= 0) {
            return;
        }
        Iterator<TemplateDto> iterator = conf.getTemplates().iterator();
        if (iterator.hasNext() && (tAppName = (template = iterator.next()).getAppName()) != null && tAppName.length() > 0 && tAppName.equals(appName)) {
            fm.addConfigFiles(installPath, template.getConfigDefs());
        }
        messageQueue = new ArrayBlockingQueue<String>(2);
        ChangeListenerObj r = new ChangeListenerObj(messageQueue, true);
        fm.addListener(r);
        fm.start();
        while (true) {
            try {
                while (true) {
                    messageQueue.take();
                }
            }
            catch (InterruptedException e) {
                log.error(e.getMessage(), (Throwable)e);
                continue;
            }
            break;
        }
    }
}

