/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.hq.plugin.tcserver.plugin.serverconfig;

import com.springsource.hq.plugin.tcserver.plugin.serverconfig.AbstractDocumentCreator;
import com.springsource.hq.plugin.tcserver.plugin.serverconfig.ServerXmlParser;
import com.springsource.hq.plugin.tcserver.plugin.serverconfig.XmlPropertiesFileRetriever;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.hyperic.hq.product.PluginException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerXmlPropertiesRetriever
extends AbstractDocumentCreator
implements XmlPropertiesFileRetriever {
    @Override
    public Map<String, String> getPropertiesFromFile(String filePath, String nodeName, String nodeAttributeName, String nodeAttributeValue) throws PluginException {
        Element serverElement;
        ServerXmlParser serverParser = new ServerXmlParser();
        try {
            serverElement = serverParser.parse(this.createDocument(filePath));
        }
        catch (ParserConfigurationException e) {
            throw new PluginException("Parser exception: " + e.getMessage(), (Throwable)e);
        }
        catch (SAXException e) {
            throw new PluginException("Error parsing file: " + e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new PluginException("File error: " + e.getMessage(), (Throwable)e);
        }
        return this.getPropertiesFromServerElementByAttribute(serverElement, nodeName, nodeAttributeName, nodeAttributeValue);
    }

    private Map<String, String> getPropertiesFromServerElementByAttribute(Element serverElement, String nodeName, String nodeAttributeName, String nodeAttributeValue) {
        LinkedHashMap<String, String> listenerProperties = new LinkedHashMap<String, String>();
        NodeList children = serverElement.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Element listenerElement;
            if (nodeName.equals(children.item(i).getNodeName()) && (listenerElement = (Element)children.item(i)).getAttribute(nodeAttributeName).equals(nodeAttributeValue)) {
                NamedNodeMap nodeMap = listenerElement.getAttributes();
                int j = 0;
                while (j < nodeMap.getLength()) {
                    listenerProperties.put(nodeMap.item(j).getNodeName(), nodeMap.item(j).getNodeValue());
                    ++j;
                }
                break;
            }
            ++i;
        }
        return listenerProperties;
    }
}

