/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.hq.plugin.tcserver.plugin.serverconfig.environment;

import com.springsource.hq.plugin.tcserver.plugin.serverconfig.environment.DefaultJvmOptionsConverter;
import com.springsource.hq.plugin.tcserver.plugin.serverconfig.environment.EnvironmentRepository;
import com.springsource.hq.plugin.tcserver.plugin.serverconfig.environment.JvmOptionsConverter;
import com.springsource.hq.plugin.tcserver.plugin.serverconfig.environment.WindowsSpecificNonJvmOptsUtil;
import com.springsource.hq.plugin.tcserver.serverconfig.configuration.jvm.Environment;
import com.springsource.hq.plugin.tcserver.serverconfig.configuration.jvm.JvmOptions;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.product.Metric;
import org.hyperic.hq.product.PluginException;
import org.hyperic.util.config.ConfigResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WindowsFileEnvironmentRepository
implements EnvironmentRepository {
    private JvmOptionsConverter jvmOptionsConverter = new DefaultJvmOptionsConverter();
    private WindowsSpecificNonJvmOptsUtil windowsOptsUtil = new WindowsSpecificNonJvmOptsUtil();
    private final Log logger = LogFactory.getLog(this.getClass());

    @Override
    public void save(String backupFileName, ConfigResponse config, Environment environment) throws PluginException {
        BufferedReader wrapperconfFileReader = null;
        FileOutputStream newWrapperconf = null;
        try {
            try {
                wrapperconfFileReader = new BufferedReader(new FileReader(backupFileName));
            }
            catch (FileNotFoundException e) {
                throw new PluginException("Unable to save wrapper.conf.  Error parsing existing file.  Cause: " + e.getMessage());
            }
            try {
                newWrapperconf = new FileOutputStream(String.valueOf(Metric.decode((String)config.getValue("installpath"))) + "/conf/wrapper.conf");
            }
            catch (FileNotFoundException e) {
                throw new PluginException("Unable to save wrapper.conf.  Error writing to existing file.  Cause: " + e.getMessage());
            }
            try {
                String line = wrapperconfFileReader.readLine();
                boolean processedJvmOpts = false;
                boolean processingJvmOpts = false;
                boolean processedJavaHome = false;
                ArrayList<String> exsistingJvmOpts = new ArrayList<String>();
                while (line != null) {
                    if (line.trim().startsWith("wrapper.java.additional")) {
                        int pos;
                        if (!processingJvmOpts) {
                            processingJvmOpts = true;
                        }
                        if ((pos = line.indexOf("=")) != -1) {
                            exsistingJvmOpts.add(this.windowsOptsUtil.stripQuotes(line.substring(pos + 1)));
                        }
                    } else if (processingJvmOpts) {
                        this.writeJvmOpts(environment.getJvmOptions(), newWrapperconf, exsistingJvmOpts);
                        processingJvmOpts = false;
                        processedJvmOpts = true;
                    } else if (line.trim().equals("")) {
                        newWrapperconf.write(line.getBytes());
                        newWrapperconf.write("\n".getBytes());
                    } else if (line.trim().startsWith("set.JAVA_HOME") || line.trim().startsWith("#set.JAVA_HOME")) {
                        if (!processedJavaHome) {
                            this.writeJavaHome(environment.getJavaHome(), newWrapperconf);
                            processedJavaHome = true;
                        }
                    } else {
                        newWrapperconf.write(line.getBytes());
                        newWrapperconf.write("\n".getBytes());
                    }
                    line = wrapperconfFileReader.readLine();
                }
                if (!processedJvmOpts) {
                    this.writeJvmOpts(environment.getJvmOptions(), newWrapperconf, null);
                }
                if (!processedJavaHome) {
                    this.writeJavaHome(environment.getJavaHome(), newWrapperconf);
                }
                newWrapperconf.flush();
                newWrapperconf.getFD().sync();
            }
            catch (IOException e) {
                throw new PluginException("Error writing JVM options to wrapper.conf.  Cause: " + e.getMessage());
            }
        }
        finally {
            try {
                if (wrapperconfFileReader != null) {
                    wrapperconfFileReader.close();
                }
            }
            catch (IOException e) {
                this.logger.warn((Object)("Error closing input stream to backup wrapper.conf file.  Cause: " + e.getMessage()));
            }
            try {
                if (newWrapperconf != null) {
                    newWrapperconf.close();
                }
            }
            catch (IOException e) {
                this.logger.warn((Object)("Error closing output stream to wrapper.conf file.  Cause: " + e.getMessage()));
            }
        }
    }

    @Override
    public final void save(ConfigResponse config, Environment environment) throws PluginException {
        throw new UnsupportedOperationException("Use of the backup file is required when writing wrapper.conf.  Please invoke WindowsFileEnvironmentRepository.save(String, ConfigResponse, Environment) instead.");
    }

    private void writeJavaHome(String javaHome, OutputStream newWrapperconf) throws IOException {
        if (javaHome != null && !"".equals(javaHome.trim())) {
            newWrapperconf.write(("set.JAVA_HOME=" + javaHome.trim()).getBytes());
        } else {
            newWrapperconf.write("#set.JAVA_HOME=".getBytes());
        }
        newWrapperconf.write("\n".getBytes());
    }

    private void writeJvmOpts(JvmOptions jvmOptions, OutputStream newWrapperconf, List<String> exsistingJvmOpts) throws IOException {
        List<String> jvmOpts = this.jvmOptionsConverter.convert(jvmOptions);
        jvmOpts = this.windowsOptsUtil.mergeOpts(exsistingJvmOpts, jvmOpts);
        int counter = 0;
        for (String jvmOpt : jvmOpts) {
            StringBuilder line = new StringBuilder();
            line.append("wrapper.java.additional.");
            line.append(++counter);
            line.append("=");
            line.append(this.windowsOptsUtil.addQuotesIfNeeded(jvmOpt));
            line.append("\n");
            newWrapperconf.write(line.toString().getBytes());
        }
        newWrapperconf.write("\n".getBytes());
    }
}

