/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.hq.plugin.tcserver.plugin.serverconfig.environment;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class WindowsSpecificNonJvmOptsUtil {
    private final List<String> protectedOpts;

    public WindowsSpecificNonJvmOptsUtil() {
        ArrayList<String> opts = new ArrayList<String>();
        opts.add("-Djava.endorsed.dirs=");
        opts.add("-Dcatalina.base=");
        opts.add("-Dcatalina.home=");
        opts.add("-Djava.io.tmpdir=");
        opts.add("-Djava.util.logging.manager=");
        opts.add("-Djava.util.logging.config.file=");
        opts.add("-Dwrapper.dump.port=");
        this.protectedOpts = Collections.unmodifiableList(opts);
    }

    public List<String> mergeOpts(List<String> existingOpts, List<String> requestedOpts) {
        if (existingOpts == null) {
            existingOpts = new ArrayList<String>();
        }
        ArrayList<String> newOpts = new ArrayList<String>();
        newOpts.addAll(requestedOpts);
        for (String exsistingOpt : existingOpts) {
            String exsistingOptName = this.parseOptName(exsistingOpt);
            if (!this.optPresent(exsistingOptName, this.protectedOpts) || this.optPresent(exsistingOptName, newOpts)) continue;
            newOpts.add(exsistingOpt);
        }
        return newOpts;
    }

    public List<String> removeProtectedOpts(List<String> requestedOpts) {
        ArrayList<String> newOpts = new ArrayList<String>();
        for (String requestedOpt : requestedOpts) {
            String requestedOptName = this.parseOptName(requestedOpt);
            if (this.optPresent(requestedOptName, this.protectedOpts)) continue;
            newOpts.add(requestedOpt);
        }
        return newOpts;
    }

    public String stripQuotes(String str) {
        if (str == null) {
            return null;
        }
        if ((str = str.trim()).length() > 1) {
            if (str.startsWith("\"") && str.endsWith("\"")) {
                return str.substring(1, str.length() - 1).trim();
            }
            if (str.startsWith("'") && str.endsWith("'")) {
                return str.substring(1, str.length() - 1).trim();
            }
        }
        return str;
    }

    public String addQuotesIfNeeded(String str) {
        if (str == null) {
            return null;
        }
        if ((str = str.trim()).startsWith("-D") && str.contains(" ")) {
            StringBuilder strBuilder = new StringBuilder();
            String[] splitProperty = str.split("=", 2);
            strBuilder.append(splitProperty[0]);
            if (splitProperty.length == 2) {
                strBuilder.append("=");
                if (splitProperty[1].contains("\"")) {
                    strBuilder.append(splitProperty[1]);
                } else {
                    strBuilder.append("\"").append(splitProperty[1]).append("\"");
                }
            }
            return strBuilder.toString();
        }
        return str;
    }

    private String parseOptName(String str) {
        int pos = str.indexOf("=");
        if (pos != -1) {
            return str.substring(0, pos + 1);
        }
        return str;
    }

    private boolean optPresent(String opt, List<String> opts) {
        for (String o : opts) {
            if (!o.startsWith(opt)) continue;
            return true;
        }
        return false;
    }
}

