/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.postgresql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.plugin.postgresql.PostgreSQL;
import org.hyperic.hq.product.Collector;
import org.hyperic.util.jdbc.DBUtil;

public class DataBaseCollector
extends Collector {
    private static Log log = LogFactory.getLog(DataBaseCollector.class);
    private List<String> db_cache = new ArrayList<String>();
    private String[] query = new String[]{"SELECT * FROM pg_stat_database where datname in (SELECT datname FROM pg_database WHERE datistemplate IS FALSE AND datallowconn IS TRUE)", "SELECT COUNT(datid) AS connections,(SELECT setting AS mc FROM pg_settings WHERE name = 'max_connections') AS max_connections,d.datname FROM pg_database d LEFT JOIN pg_stat_activity s ON (s.datid = d.oid) GROUP BY 2,3"};
    private String[] queryDB = new String[]{"SELECT (select current_database()) as datname,COALESCE(SUM(idx_scan),0) AS idx_scan,COALESCE(SUM(idx_tup_read),0) AS idx_tup_read,COALESCE(SUM(idx_tup_fetch),0) AS idx_tup_fetch from pg_stat_user_indexes", "SELECT (select current_database()) as datname,COALESCE(SUM(idx_blks_read),0) AS idx_blks_read,COALESCE(SUM(idx_blks_hit),0) AS idx_blks_hit from pg_statio_user_indexes", "SELECT (select current_database()) as datname,COALESCE(SUM(seq_scan),0) AS seq_scan,COALESCE(SUM(seq_tup_read),0) AS seq_tup_read FROM pg_stat_user_tables", "SELECT count(mode) granted_locks, datname FROM pg_locks l JOIN pg_database d ON (d.oid=l.database) WHERE l.granted=true GROUP BY 2", "SELECT count(mode) awaited_locks, datname FROM pg_locks l JOIN pg_database d ON (d.oid=l.database) WHERE l.granted=false GROUP BY 2", "SELECT datname, count(current_query) AS idle_backends FROM pg_stat_activity WHERE current_query = '<IDLE>' GROUP BY 1;"};
    private String[] posibleNULLMetrics = new String[]{"granted_locks", "awaited_locks"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collect() {
        this.db_cache.clear();
        Properties p = this.getProperties();
        String user = p.getProperty("postgresql.user");
        String pass = p.getProperty("postgresql.pass");
        Connection conn = null;
        try {
            String url = PostgreSQL.prepareUrl(p, null);
            log.debug((Object)("[collect] url:'" + url + "'"));
            conn = DriverManager.getConnection(url, user, pass);
            for (int j = 0; j < this.query.length; ++j) {
                String q = this.query[j];
                this.extartMetrics(q, conn, j == 0);
            }
            DBUtil.closeJDBCObjects((Object)log, (Connection)conn, null, null);
            for (int i = 0; i < this.db_cache.size(); ++i) {
                String db = this.db_cache.get(i);
                this.setValue(db + "." + "Availability", 1.0);
                url = PostgreSQL.prepareUrl(p, db);
                log.debug((Object)("[collect] url:'" + url + "'"));
                conn = DriverManager.getConnection(url, user, pass);
                for (int j = 0; j < this.queryDB.length; ++j) {
                    String q = this.queryDB[j];
                    this.extartMetrics(q, conn, false);
                }
            }
        }
        catch (Exception e) {
            try {
                String msg = "Error getting metrics: " + e.getMessage();
                this.setErrorMessage(msg, e);
                log.debug((Object)("[collect] " + msg), (Throwable)e);
            }
            catch (Throwable throwable) {
                DBUtil.closeJDBCObjects((Object)log, conn, null, null);
                throw throwable;
            }
            DBUtil.closeJDBCObjects((Object)log, (Connection)conn, null, null);
        }
        DBUtil.closeJDBCObjects((Object)log, (Connection)conn, null, null);
        for (int i = 0; i < this.db_cache.size(); ++i) {
            String db = this.db_cache.get(i);
            double c = Double.parseDouble((String)this.getResult().getValues().get(db + ".connections"));
            double m = Double.parseDouble((String)this.getResult().getValues().get(db + ".max_connections"));
            this.setValue(db + ".connections_usage", c / m);
            double blksRead = Double.parseDouble((String)this.getResult().getValues().get(db + ".blks_read"));
            double blksHit = Double.parseDouble((String)this.getResult().getValues().get(db + ".blks_hit"));
            double blksHitP = blksRead + blksHit > 0.0 ? blksHit / (blksRead + blksHit) : 0.0;
            double tupAltered = Double.parseDouble((String)this.getResult().getValues().get(db + ".tup_inserted")) + Double.parseDouble((String)this.getResult().getValues().get(db + ".tup_updated")) + Double.parseDouble((String)this.getResult().getValues().get(db + ".tup_deleted"));
            this.setValue(db + ".blks_hit_p", blksHitP);
            this.setValue(db + ".tup_altered", tupAltered);
            for (int j = 0; j < this.posibleNULLMetrics.length; ++j) {
                String metric = this.posibleNULLMetrics[j];
                if (this.getResult().getValues().get(db + "." + metric) != null) continue;
                this.setValue(db + "." + metric, 0.0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extartMetrics(String query, Connection conn, boolean getDBNames) throws SQLException {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            log.debug((Object)("[extartMetrics] query:'" + query + "'"));
            stmt = conn.createStatement();
            rs = stmt.executeQuery(query);
            ResultSetMetaData md = rs.getMetaData();
            while (rs.next()) {
                String dbName = rs.getString("datname");
                if (getDBNames) {
                    this.db_cache.add(dbName);
                }
                for (int c = 1; c <= md.getColumnCount(); ++c) {
                    this.setValue(dbName + "." + md.getColumnLabel(c), rs.getString(c));
                }
            }
        }
        catch (Throwable throwable) {
            DBUtil.closeJDBCObjects((Object)log, null, stmt, rs);
            throw throwable;
        }
        DBUtil.closeJDBCObjects((Object)log, null, (Statement)stmt, (ResultSet)rs);
    }
}

