/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jdbc.base;

import com.microsoft.jdbc.base.BaseParseInfoTree;
import com.microsoft.jdbc.base.BaseParseInfoTreeNode;

public class BaseParseInfoTreeCursor {
    private static String footprint = "$Revision:   1.0.1.0  $";
    protected BaseParseInfoTreeNode currentNode;
    protected BaseParseInfoTree parseInfoTree;

    BaseParseInfoTreeCursor(BaseParseInfoTree baseParseInfoTree) {
        this.parseInfoTree = baseParseInfoTree;
        this.currentNode = baseParseInfoTree.getRootNode();
    }

    BaseParseInfoTreeCursor(BaseParseInfoTreeCursor baseParseInfoTreeCursor) {
        this.parseInfoTree = baseParseInfoTreeCursor.parseInfoTree;
        this.currentNode = baseParseInfoTreeCursor.currentNode;
    }

    public void copy(BaseParseInfoTreeCursor baseParseInfoTreeCursor) {
        this.currentNode = baseParseInfoTreeCursor.currentNode;
        this.parseInfoTree = baseParseInfoTreeCursor.parseInfoTree;
    }

    public boolean equals(BaseParseInfoTreeCursor baseParseInfoTreeCursor) {
        return this.currentNode == baseParseInfoTreeCursor.currentNode && this.parseInfoTree == baseParseInfoTreeCursor.parseInfoTree;
    }

    public final BaseParseInfoTreeNode getChildNode() {
        return this.currentNode.child;
    }

    public final int getChildNodeOperator() {
        if (this.currentNode.child != null) {
            return this.getChildNode().op;
        }
        return BaseParseInfoTreeNode.NO_OP;
    }

    public final int getNodeCount() {
        int n = 0;
        BaseParseInfoTreeNode baseParseInfoTreeNode = this.currentNode;
        block0: while (true) {
            ++n;
            if (baseParseInfoTreeNode.child != null) {
                baseParseInfoTreeNode = baseParseInfoTreeNode.child;
                continue;
            }
            if (baseParseInfoTreeNode == this.currentNode) break;
            if (baseParseInfoTreeNode.sibling != null) {
                baseParseInfoTreeNode = baseParseInfoTreeNode.sibling;
                continue;
            }
            do {
                if ((baseParseInfoTreeNode = baseParseInfoTreeNode.parent) == this.currentNode) continue block0;
            } while (baseParseInfoTreeNode.sibling == null);
            baseParseInfoTreeNode = baseParseInfoTreeNode.sibling;
        }
        return n;
    }

    public final String getNodeLiteral() {
        return this.currentNode.literal;
    }

    public final int getNodeOperator() {
        return this.currentNode.op;
    }

    public final BaseParseInfoTreeNode getParentNode() {
        return this.currentNode.parent;
    }

    public final int getParentNodeOperator() {
        if (this.currentNode.parent != null) {
            return this.getParentNode().op;
        }
        return BaseParseInfoTreeNode.NO_OP;
    }

    public final BaseParseInfoTreeNode getSiblingNode() {
        return this.currentNode.sibling;
    }

    public final int getSiblingNodeOperator() {
        if (this.currentNode.sibling != null) {
            return this.getSiblingNode().op;
        }
        return BaseParseInfoTreeNode.NO_OP;
    }

    public final boolean moveToChild() {
        if (this.currentNode.child != null) {
            this.currentNode = this.currentNode.child;
            return true;
        }
        return false;
    }

    public final boolean moveToParent() {
        if (this.currentNode.parent != null) {
            this.currentNode = this.currentNode.parent;
            return true;
        }
        return false;
    }

    public final boolean moveToSibling() {
        if (this.currentNode.sibling != null) {
            this.currentNode = this.currentNode.sibling;
            return true;
        }
        return false;
    }
}

