/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;
import org.hyperic.util.PropertyUtil;
import org.hyperic.util.PropertyUtilException;
import org.hyperic.util.file.FileUtil;
import org.hyperic.util.security.SecurityUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyEncryptionUtil {
    private static final String KEY_ENCRYPTION_KEY = "Security Kung-Fu";
    private static final String ENCRYPTION_KEY_PROP = "k";
    private static final String LOCK_FILE_NAME = System.getProperty("java.io.tmpdir") + "/agent.encrypt.lock";

    public static synchronized String getPropertyEncryptionKey(String fileName) throws PropertyUtilException {
        String encryptionKey;
        if (fileName == null || fileName.trim().length() < 1) {
            throw new PropertyUtilException("Illegal Argument: fileName [" + fileName + "]");
        }
        File encryptionKeyFile = new File(fileName);
        if (!encryptionKeyFile.exists()) {
            throw new PropertyUtilException("The encryption key file [" + fileName + "] doesn't exist");
        }
        try {
            Properties props = new Properties();
            props.load(new FileInputStream(encryptionKeyFile));
            String encryptedKey = props.getProperty(ENCRYPTION_KEY_PROP);
            if (encryptedKey == null) {
                throw new PropertyUtilException("Invalid properties encryption key");
            }
            encryptionKey = SecurityUtil.decrypt("PBEWithMD5AndDES", KEY_ENCRYPTION_KEY, encryptedKey);
        }
        catch (Exception exc) {
            throw new PropertyUtilException(exc);
        }
        return encryptionKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void ensurePropertiesEncryption(String propsFileName, String encryptionKeyFileName, Set<String> secureProps) throws PropertyUtilException {
        int tries = 10;
        while (!PropertyEncryptionUtil.lock() && tries > 0) {
            --tries;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ignore) {}
        }
        if (tries <= 0) {
            throw new PropertyUtilException(LOCK_FILE_NAME + " is locked. can't continue.");
        }
        try {
            String encryptionKey;
            if (propsFileName == null || propsFileName.trim().length() < 1) {
                throw new PropertyUtilException("Illegal Argument: propsFileName [" + propsFileName + "]");
            }
            if (encryptionKeyFileName == null || encryptionKeyFileName.trim().length() < 1) {
                throw new PropertyUtilException("Illegal Argument: encryptionKeyFileName [" + encryptionKeyFileName + "]");
            }
            if (secureProps == null || secureProps.size() < 1) {
                return;
            }
            Properties props = PropertyUtil.loadProperties(propsFileName);
            boolean alreadyEncrypted = PropertyEncryptionUtil.isAlreadyEncrypted(props);
            File encryptionKeyFile = new File(encryptionKeyFileName);
            if (encryptionKeyFile.exists()) {
                encryptionKey = PropertyEncryptionUtil.getPropertyEncryptionKey(encryptionKeyFileName);
            } else {
                if (alreadyEncrypted) {
                    throw new PropertyUtilException("The properties are already encrypted, but the encryption key is missing");
                }
                encryptionKey = PropertyEncryptionUtil.createAndStorePropertyEncryptionKey(encryptionKeyFileName);
            }
            HashMap<String, String> unEncProps = new HashMap<String, String>();
            Enumeration<?> propKeys = props.propertyNames();
            while (propKeys.hasMoreElements()) {
                String key = (String)propKeys.nextElement();
                String value = props.getProperty(key);
                if (value == null || !secureProps.contains(key) || SecurityUtil.isMarkedEncrypted(value)) continue;
                unEncProps.put(key, value);
            }
            if (unEncProps.size() > 0) {
                PropertyUtil.storeProperties(propsFileName, encryptionKey, unEncProps);
            }
        }
        finally {
            PropertyEncryptionUtil.unlock(false);
        }
    }

    static boolean lock() {
        File lockFile = new File(LOCK_FILE_NAME);
        try {
            return lockFile.createNewFile();
        }
        catch (IOException ignore) {
            return false;
        }
    }

    public static boolean unlock(boolean shouldLog) {
        File lockFile = new File(LOCK_FILE_NAME);
        boolean res = lockFile.delete();
        if (res && shouldLog) {
            System.out.println(LOCK_FILE_NAME + " was deleted.");
        }
        return res;
    }

    static synchronized String createAndStorePropertyEncryptionKey(String fileName) throws PropertyUtilException {
        String encryptionKey;
        if (fileName == null || fileName.trim().length() < 1) {
            throw new PropertyUtilException("Illegal Argument: fileName [" + fileName + "]");
        }
        File encryptionKeyFile = new File(fileName);
        if (encryptionKeyFile.exists()) {
            throw new PropertyUtilException("Attempt to override an encryption key file [" + fileName + "]");
        }
        try {
            encryptionKey = SecurityUtil.generateRandomToken();
            String encryptedKey = SecurityUtil.encrypt("PBEWithMD5AndDES", KEY_ENCRYPTION_KEY, encryptionKey);
            Properties props = new Properties();
            props.put(ENCRYPTION_KEY_PROP, encryptedKey);
            props.store(new FileOutputStream(fileName), null);
            File encKeyFile = new File(fileName);
            FileUtil.setReadWriteOnlyByOwner(encKeyFile);
        }
        catch (Exception exc) {
            throw new PropertyUtilException(exc);
        }
        return encryptionKey;
    }

    private static boolean isAlreadyEncrypted(Properties props) {
        for (Object value : props.values()) {
            if (!SecurityUtil.isMarkedEncrypted((String)value)) continue;
            return true;
        }
        return false;
    }
}

