/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.file;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.hyperic.util.file.FileUtil;
import org.hyperic.util.file.WriterHandler;

class CreateOrOverwriteWriter
extends WriterHandler {
    private File destFile;
    private File backupFile;
    private InputStream inStream;
    private long length;
    private boolean copied;
    private boolean created;

    CreateOrOverwriteWriter(File destFile, InputStream inStream, long length) {
        this.destFile = destFile;
        this.backupFile = null;
        this.inStream = inStream;
        this.length = length;
        this.copied = false;
        this.created = false;
    }

    CreateOrOverwriteWriter(File destFile, byte[] data) {
        this(destFile, new ByteArrayInputStream(data), data.length);
    }

    public void rollback() throws IOException {
        super.rollback();
        if (this.backupFile != null) {
            if (!this.backupFile.renameTo(this.destFile)) {
                try {
                    FileUtil.copyStream(new FileInputStream(this.backupFile), new FileOutputStream(this.destFile));
                }
                catch (IOException exc) {
                    this.backupFile.delete();
                    throw exc;
                }
            }
        } else if (this.created) {
            this.destFile.delete();
        }
    }

    private void setupBackup() throws IOException {
        File parentDir = this.destFile.getAbsoluteFile().getParentFile();
        if (parentDir == null) {
            throw new IOException("Unable to get the owner directory for " + this.destFile);
        }
        if (this.destFile.exists()) {
            if (!this.destFile.isFile()) {
                throw new IOException(this.destFile + " is not a regular file");
            }
            try {
                this.backupFile = File.createTempFile("fwrite", "tmp", parentDir);
            }
            catch (IOException exc) {
                this.backupFile = File.createTempFile("fwrite", "tmp");
            }
            if (!this.destFile.renameTo(this.backupFile)) {
                try {
                    FileUtil.copyStream(new FileInputStream(this.destFile), new FileOutputStream(this.backupFile));
                    this.copied = true;
                }
                catch (IOException exc) {
                    throw new IOException("Unable to rename " + this.destFile + " to " + this.backupFile + " for backup purposes");
                }
            }
        }
    }

    public void cleanup() {
        super.cleanup();
        if (this.backupFile != null) {
            this.backupFile.delete();
            this.backupFile = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write() throws IOException {
        super.write();
        this.setupBackup();
        if (!this.copied) {
            if (!this.destFile.createNewFile()) {
                throw new IOException("Unable to create " + this.destFile);
            }
            this.created = true;
        }
        FileOutputStream fOs = new FileOutputStream(this.destFile);
        try {
            CreateOrOverwriteWriter.copyStream(this.inStream, fOs, this.length);
        }
        finally {
            try {
                fOs.close();
            }
            catch (IOException iOException) {}
        }
    }
}

