/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.util.jdbc.SequenceRetrievalException;
import org.hyperic.util.jdbc.SequencesNotSupportedException;
import org.hyperic.util.pager.PageControl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DBUtil {
    protected static final Log log = LogFactory.getLog(DBUtil.class);
    public static final int ORACLE_ERROR_DIVIDE_BY_ZERO = 1476;
    public static final int ORACLE_ERROR_NOT_AVAILABLE = 1034;
    public static final int POSTGRES_ERROR_DIVIDE_BY_ZERO = 22012;
    public static final int POSTGRES_CONNECTION_EXCEPTION = 8000;
    public static final int POSTGRES_CONNECTION_FAILURE = 8006;
    public static final int POSTGRES_UNABLE_TO_CONNECT = 8001;
    public static final int MYSQL_LOCAL_CONN_ERROR = 2002;
    public static final int MYSQL_REMOTE_CONN_ERROR = 2003;
    public static final int DATABASE_UNKNOWN = 0;
    public static final int DATABASE_POSTGRESQL_7 = 1;
    public static final int DATABASE_POSTGRESQL_8 = 2;
    public static final int DATABASE_ORACLE_8 = 3;
    public static final int DATABASE_ORACLE_9 = 4;
    public static final int DATABASE_ORACLE_10 = 8;
    public static final int DATABASE_MYSQL5 = 9;
    public static final int DATABASE_ORACLE_11 = 10;
    public static final int DATABASE_POSTGRESQL_9 = 11;
    private static String BUILTIN_DB_JDBC_URL = "jdbc:postgresql://127.0.0.1:9432";
    private static String BUILTIN_DB_NAME = "hqdb";
    public static final int IN_CHUNK_SIZE = 200;
    private static Map _dbTypes = new HashMap();
    private DataSource dataSource;

    @Autowired
    public DBUtil(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public static void closeConnection(Object ctx, Connection c) {
        if (c == null) {
            return;
        }
        try {
            c.close();
        }
        catch (Exception e) {
            log.warn((Object)(ctx.toString() + ": Error closing connection."), (Throwable)e);
        }
    }

    public static void closeStatement(Object ctx, Statement s) {
        if (s == null) {
            return;
        }
        try {
            s.close();
        }
        catch (Exception e) {
            log.warn((Object)(ctx.toString() + ": Error closing statement."), (Throwable)e);
        }
    }

    public static void closeResultSet(Object ctx, ResultSet rs) {
        if (rs == null) {
            return;
        }
        try {
            rs.close();
        }
        catch (Exception e) {
            log.warn((Object)(ctx.toString() + ": Error closing result set."), (Throwable)e);
        }
    }

    public static void closeJDBCObjects(Object ctx, Connection c, Statement s, ResultSet rs) {
        DBUtil.closeResultSet(ctx, rs);
        DBUtil.closeStatement(ctx, s);
        DBUtil.closeConnection(ctx, c);
    }

    public static int getNextSequenceValue(String ctx, Connection conn, String table, String key) throws SQLException {
        block8: {
            int n;
            String query = null;
            int dbType = DBUtil.getDBType(conn);
            switch (dbType) {
                case 1: 
                case 2: 
                case 11: {
                    query = "SELECT nextval('" + table + "_" + key + "_seq'::text)";
                    break;
                }
                case 3: 
                case 4: 
                case 8: 
                case 10: {
                    query = "SELECT " + table + "_" + key + "_seq.nextval " + "FROM DUAL";
                    break;
                }
                case 9: {
                    query = "SELECT MAX(" + key + ") + 1 FROM " + table;
                    break;
                }
                default: {
                    throw new SequencesNotSupportedException();
                }
            }
            PreparedStatement selectPS = null;
            ResultSet rs = null;
            try {
                selectPS = conn.prepareStatement(query);
                rs = selectPS.executeQuery();
                if (!rs.next()) break block8;
                n = rs.getInt(1);
            }
            catch (Throwable throwable) {
                DBUtil.closeResultSet(ctx, rs);
                DBUtil.closeStatement(ctx, selectPS);
                throw throwable;
            }
            DBUtil.closeResultSet(ctx, rs);
            DBUtil.closeStatement(ctx, selectPS);
            return n;
        }
        throw new SequenceRetrievalException();
    }

    public static int getDBType(Connection conn) throws SQLException {
        Class<?> connClass = conn.getClass();
        Integer dbTypeInteger = (Integer)_dbTypes.get(connClass);
        int dbType = 0;
        if (dbTypeInteger == null) {
            DatabaseMetaData dbMetaData = conn.getMetaData();
            String dbName = dbMetaData.getDatabaseProductName().toLowerCase();
            String dbVersion = dbMetaData.getDatabaseProductVersion().toLowerCase();
            log.debug((Object)("getDBType: dbName='" + dbName + "', version='" + dbVersion + "'"));
            if (dbName.indexOf("postgresql") != -1) {
                if (dbVersion.startsWith("7.")) {
                    dbType = 1;
                } else if (dbVersion.startsWith("8.")) {
                    dbType = 2;
                } else if (dbVersion.startsWith("9.")) {
                    dbType = 11;
                }
            } else if (dbName.indexOf("oracle") != -1) {
                if (dbVersion.startsWith("oracle8")) {
                    dbType = 3;
                } else if (dbVersion.startsWith("oracle9")) {
                    dbType = 4;
                } else if (dbVersion.startsWith("oracle database 10g")) {
                    dbType = 8;
                } else if (dbVersion.startsWith("oracle database 11g")) {
                    dbType = 10;
                }
            } else if (dbName.indexOf("mysql") != -1) {
                dbType = 9;
            }
            _dbTypes.put(connClass, new Integer(dbType));
        } else {
            dbType = dbTypeInteger;
        }
        return dbType;
    }

    public static boolean isPostgreSQL(Connection c) throws SQLException {
        int type = DBUtil.getDBType(c);
        return DBUtil.isPostgreSQL(type);
    }

    public static boolean isPostgreSQL(int type) {
        return type == 1 || type == 2 || type == 11;
    }

    public static boolean isOracle(Connection c) throws SQLException {
        int type = DBUtil.getDBType(c);
        return DBUtil.isOracle(type);
    }

    public static boolean isOracle(int type) {
        return type == 3 || type == 4 || type == 8 || type == 10;
    }

    public static boolean isMySQL(Connection c) throws SQLException {
        int type = DBUtil.getDBType(c);
        return DBUtil.isMySQL(type);
    }

    public static boolean isMySQL(int type) {
        return type == 9;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBuiltinDB() {
        boolean isBuiltin = false;
        try {
            Connection conn = this.getConnection();
            DatabaseMetaData dbMetaData = conn.getMetaData();
            String url = dbMetaData.getURL();
            DBUtil.closeConnection(log, conn);
            if (url != null) {
                isBuiltin = (url = url.toLowerCase()).startsWith(BUILTIN_DB_JDBC_URL) && url.indexOf(BUILTIN_DB_NAME) > BUILTIN_DB_JDBC_URL.length();
            }
        }
        catch (SQLException e) {
            log.warn((Object)"Error retrieving database meta data.", (Throwable)e);
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug((Object)("isBuiltinDB=" + isBuiltin));
            }
        }
        return isBuiltin;
    }

    public Connection getConnection() throws SQLException {
        return this.dataSource.getConnection();
    }

    public static String getBooleanType(Connection conn) throws SQLException {
        int type = DBUtil.getDBType(conn);
        switch (type) {
            case 3: 
            case 4: 
            case 8: 
            case 10: {
                return "NUMBER(1)";
            }
            case 9: {
                return "BIT";
            }
        }
        return "BOOLEAN";
    }

    public static String getBooleanValue(boolean bool, Connection conn) throws SQLException {
        int type = DBUtil.getDBType(conn);
        switch (type) {
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: {
                return bool ? "1" : "0";
            }
        }
        return bool ? "'1'" : "'0'";
    }

    public static void setBooleanValue(boolean bool, Connection conn, PreparedStatement ps, int idx) throws SQLException {
        int type = DBUtil.getDBType(conn);
        switch (type) {
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: {
                ps.setInt(idx, bool ? 1 : 0);
                return;
            }
        }
        ps.setBoolean(idx, bool);
    }

    public static int seek(ResultSet rs, PageControl pc) throws SQLException {
        int i;
        int stop = pc.getPagenum() * pc.getPagesize();
        for (i = 0; i < stop && rs.next(); ++i) {
        }
        return i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkColumnExists(String ctx, Connection c, String table, String column) throws SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        String checkColumnSql = "SELECT * FROM " + table + " WHERE 1=0";
        try {
            ps = c.prepareStatement(checkColumnSql);
            rs = ps.executeQuery();
            ResultSetMetaData rsmd = rs.getMetaData();
            int numCols = rsmd.getColumnCount();
            for (int i = 0; i < numCols; ++i) {
                if (!rsmd.getColumnName(i + 1).equalsIgnoreCase(column)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            DBUtil.closeJDBCObjects(ctx, null, ps, rs);
        }
    }

    private static String composeConjunctions(int iterations, String conjunction, String clause) {
        StringBuffer strBuf = new StringBuffer();
        for (int i = 0; i < iterations; ++i) {
            if (i > 0) {
                strBuf.append(conjunction);
            }
            strBuf.append(clause);
        }
        return strBuf.toString();
    }

    public static String composeConjunctions(String column, int iterations) {
        if (iterations > 1) {
            StringBuffer strBuf = new StringBuffer(column).append(" IN (").append(DBUtil.composeConjunctions(iterations, ",", "?")).append(") ");
            return strBuf.toString();
        }
        if (iterations == 1) {
            return " " + column + "=? ";
        }
        return " 1=1 ";
    }

    public static void replacePlaceHolder(StringBuffer buf, String repl) {
        int index = buf.indexOf("?");
        if (index >= 0) {
            buf.replace(index, index + 1, repl);
        }
    }

    public static void replacePlaceHolders(StringBuffer buf, Object[] objs) {
        for (int i = 0; i < objs.length; ++i) {
            DBUtil.replacePlaceHolder(buf, objs[i].toString());
        }
    }
}

