/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.pager;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import org.hyperic.util.math.MathUtil;
import org.hyperic.util.pager.PageControl;
import org.hyperic.util.pager.PageFetcher;
import org.hyperic.util.pager.PageList;

public class ListPageFetcher
extends PageFetcher {
    private List data;
    private int sortOrder;

    public ListPageFetcher(List data) {
        this.data = data;
        this.sortOrder = 0;
    }

    public PageList getPage(PageControl control) {
        int startIdx;
        PageList res = new PageList();
        if (this.data.size() == 0) {
            return new PageList();
        }
        this.ensureSortOrder(control);
        res.setTotalSize(this.data.size());
        int endIdx = control.getPagesize() == -1 ? this.data.size() : MathUtil.clamp(startIdx + control.getPagesize(), startIdx, this.data.size());
        ListIterator i = this.data.listIterator(startIdx);
        for (int curIdx = startIdx = MathUtil.clamp(control.getPageEntityIndex(), 0, this.data.size() - 1); i.hasNext() && curIdx < endIdx; ++curIdx) {
            res.add(i.next());
        }
        return res;
    }

    private void ensureSortOrder(PageControl control) {
        if (control.getSortorder() == this.sortOrder) {
            return;
        }
        this.sortOrder = control.getSortorder();
        if (this.sortOrder == 0) {
            return;
        }
        if (this.sortOrder == 1) {
            Collections.sort(this.data);
        } else if (this.sortOrder == 2) {
            Collections.sort(this.data, new DescSorter());
        } else {
            throw new IllegalStateException("Unknown control sorting type: " + this.sortOrder);
        }
    }

    private class DescSorter
    implements Comparator {
        private DescSorter() {
        }

        public int compare(Object o1, Object o2) {
            return -((Comparable)o1).compareTo((Comparable)o2);
        }

        public boolean equals(Object other) {
            return false;
        }
    }
}

