/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.shell;

import java.io.File;
import java.io.IOException;
import org.hyperic.util.shell.ShellCommandBase;
import org.hyperic.util.shell.ShellCommandExecException;
import org.hyperic.util.shell.ShellCommandUsageException;

public class ShellCommand_source
extends ShellCommandBase {
    public void processCommand(String[] args) throws ShellCommandUsageException, ShellCommandExecException {
        if (args.length != 1) {
            throw new ShellCommandUsageException("Syntax: " + this.getCommandName() + " <rcfile>");
        }
        File rcFile = new File(args[0]);
        if (!rcFile.isFile()) {
            throw new ShellCommandExecException("File '" + rcFile + "' not found");
        }
        try {
            this.getShell().readRCFile(rcFile, true);
        }
        catch (IOException exc) {
            throw new ShellCommandExecException("Error reading file '" + rcFile + ": " + exc.getMessage());
        }
    }

    public String getSyntaxArgs() {
        return "<rcfile>";
    }

    public String getUsageShort() {
        return "Read a file, executing the contents";
    }

    public String getUsageHelp(String[] args) {
        return "    " + this.getUsageShort() + ".  The file must contain " + "commands\n    which are executable by the shell.";
    }
}

