/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.units;

import java.text.ParseException;
import org.hyperic.util.units.BinaryFormatter;
import org.hyperic.util.units.ParseSpecifics;
import org.hyperic.util.units.UnitNumber;

public class BitRateFormatter
extends BinaryFormatter {
    protected String getTagName() {
        return "b";
    }

    protected UnitNumber parseTag(double number, String tag, int tagIdx, ParseSpecifics specifics) throws ParseException {
        int scale;
        if (tag.equalsIgnoreCase("b") || tag.equalsIgnoreCase("b/sec")) {
            scale = 16;
        } else if (tag.equalsIgnoreCase("k") || tag.equalsIgnoreCase("kb") || tag.equalsIgnoreCase("kb/sec")) {
            scale = 1;
        } else if (tag.equalsIgnoreCase("m") || tag.equalsIgnoreCase("mb") || tag.equalsIgnoreCase("mb/sec")) {
            scale = 2;
        } else if (tag.equalsIgnoreCase("g") || tag.equalsIgnoreCase("gb") || tag.equalsIgnoreCase("gb/sec")) {
            scale = 3;
        } else if (tag.equalsIgnoreCase("t") || tag.equalsIgnoreCase("tb") || tag.equalsIgnoreCase("tb/sec")) {
            scale = 4;
        } else if (tag.equalsIgnoreCase("p") || tag.equalsIgnoreCase("pb") || tag.equalsIgnoreCase("pb/sec")) {
            scale = 5;
        } else {
            throw new ParseException("Unknown bitrate type '" + tag + "'", tagIdx);
        }
        return new UnitNumber(number, 3, scale);
    }
}

