/*
 * Decompiled with CFR 0.152.
 */
package com.hyperic.hq.rt.agent.server;

import com.hyperic.hq.rt.RtConstants;
import com.hyperic.hq.rt.agent.client.RtCommandsClient;
import com.hyperic.hq.rt.agent.commands.RtPluginDisable_args;
import com.hyperic.hq.rt.agent.commands.RtPlugin_args;
import com.hyperic.hq.rt.agent.server.RtSchedule;
import com.hyperic.hq.rt.agent.server.RtScheduleThread;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.agent.AgentRemoteException;
import org.hyperic.hq.agent.AgentRemoteValue;
import org.hyperic.hq.agent.server.AgentStorageProvider;
import org.hyperic.util.config.ConfigResponse;
import org.hyperic.util.schedule.UnscheduledItemException;

public class RtCommandsService
implements RtCommandsClient {
    public static final String COLLECTIPS = "Rt.Collect.IPs";
    private static final Log _log = LogFactory.getLog(RtCommandsService.class);
    private final AgentStorageProvider _storage;
    private final RtSchedule _schedStorage;
    private final RtScheduleThread _scheduleObject;

    public RtCommandsService(AgentStorageProvider storage, RtSchedule schedStorage, RtScheduleThread scheduleObject) {
        this._storage = storage;
        this._schedStorage = schedStorage;
        this._scheduleObject = scheduleObject;
    }

    public boolean isEnabled(String id, String pluginType, boolean enduser) throws AgentRemoteException {
        RtPlugin_args args = new RtPlugin_args();
        args.setConfig(id, pluginType, new ConfigResponse(), new Boolean(enduser));
        return this.checkIsEnabled(args);
    }

    AgentRemoteValue isEnabled(RtPlugin_args args) throws AgentRemoteException {
        boolean enabled = this.checkIsEnabled(args);
        String en = new Boolean(enabled).toString();
        AgentRemoteValue rv = new AgentRemoteValue();
        rv.setValue(RtConstants.EUENABLED, en);
        return rv;
    }

    private boolean checkIsEnabled(RtPlugin_args args) {
        String ident = args.getRtIdent();
        return this._schedStorage.findRt(ident);
    }

    public void reScheduleRt(String id, String pluginType, ConfigResponse response, Boolean enduser) throws AgentRemoteException {
        RtPlugin_args args = new RtPlugin_args();
        args.setConfig(id, pluginType, response, enduser);
        this.reScheduleRt(args);
    }

    void reScheduleRt(RtPlugin_args args) throws AgentRemoteException {
        String ident = args.getRtIdent();
        try {
            _log.debug((Object)"Sending unschedule message to schedule thread");
            this._scheduleObject.unscheduleRt(ident);
            this._scheduleObject.scheduleRt(args);
            _log.debug((Object)"Returned from rescheduling in schedule thread");
        }
        catch (UnscheduledItemException unscheduledItemException) {
            // empty catch block
        }
    }

    public void scheduleRt(String id, String pluginType, ConfigResponse response, Boolean enduser, Boolean collectIPs) throws AgentRemoteException {
        RtPlugin_args args = new RtPlugin_args();
        args.setConfig(id, pluginType, response, enduser, collectIPs);
        this.scheduleRt(args);
    }

    void scheduleRt(RtPlugin_args args) throws AgentRemoteException {
        this._schedStorage.storeRt(args);
        this.storeCollectIPs(args);
        _log.debug((Object)"Sending schedule RT to schedule thread");
        this._scheduleObject.scheduleRt(args);
        _log.debug((Object)"Got back from scheduling RT in schedule thread");
    }

    public void unscheduleRt(String id, Boolean enduser) throws AgentRemoteException {
        RtPluginDisable_args args = new RtPluginDisable_args();
        args.setConfig(id, enduser);
        this.unscheduleRt(args);
    }

    void unscheduleRt(RtPluginDisable_args args) throws AgentRemoteException {
        String ident = args.getRtIdent();
        UnscheduledItemException resExc = null;
        try {
            _log.debug((Object)"Sending unschedule message to schedule thread");
            this._scheduleObject.unscheduleRt(ident);
            _log.debug((Object)"Returned from unschedule in schedule thread");
        }
        catch (UnscheduledItemException e) {
            resExc = e;
        }
        if (resExc == null) {
            _log.debug((Object)("Deleted " + ident + " from storage"));
            this._schedStorage.deleteRt(ident);
            _log.debug((Object)"Returned from deleting from storage");
        }
    }

    private void storeCollectIPs(RtPlugin_args args) {
        Boolean collect = args.getCollectIPs();
        if (collect != null) {
            this._storage.setValue(COLLECTIPS, collect.toString());
        }
    }
}

