/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.autoinventory.agent.server;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.agent.AgentAPIInfo;
import org.hyperic.hq.agent.AgentAssertionException;
import org.hyperic.hq.agent.AgentConfig;
import org.hyperic.hq.agent.AgentRemoteException;
import org.hyperic.hq.agent.AgentRemoteValue;
import org.hyperic.hq.agent.server.AgentDaemon;
import org.hyperic.hq.agent.server.AgentNotificationHandler;
import org.hyperic.hq.agent.server.AgentRunningException;
import org.hyperic.hq.agent.server.AgentServerHandler;
import org.hyperic.hq.agent.server.AgentStartException;
import org.hyperic.hq.agent.server.AgentStorageProvider;
import org.hyperic.hq.agent.server.AgentTransportLifecycle;
import org.hyperic.hq.appdef.shared.AIPlatformValue;
import org.hyperic.hq.appdef.shared.AIServerValue;
import org.hyperic.hq.autoinventory.AutoinventoryException;
import org.hyperic.hq.autoinventory.RuntimeScanner;
import org.hyperic.hq.autoinventory.ScanConfiguration;
import org.hyperic.hq.autoinventory.ScanConfigurationCore;
import org.hyperic.hq.autoinventory.ScanListener;
import org.hyperic.hq.autoinventory.ScanManager;
import org.hyperic.hq.autoinventory.ScanState;
import org.hyperic.hq.autoinventory.ScanStateCore;
import org.hyperic.hq.autoinventory.agent.AICommandsAPI;
import org.hyperic.hq.autoinventory.agent.client.AICommandsClient;
import org.hyperic.hq.autoinventory.agent.server.AICommandsService;
import org.hyperic.hq.autoinventory.agent.server.RuntimeAutodiscoverer;
import org.hyperic.hq.bizapp.agent.CommandsAPIInfo;
import org.hyperic.hq.bizapp.client.AutoinventoryCallbackClient;
import org.hyperic.hq.bizapp.client.ProviderFetcher;
import org.hyperic.hq.bizapp.client.StorageProviderFetcher;
import org.hyperic.hq.common.SystemException;
import org.hyperic.hq.product.AutoinventoryPluginManager;
import org.hyperic.util.AutoApproveConfig;
import org.hyperic.util.StringUtil;

public class AutoinventoryCommandsServer
implements AgentServerHandler,
AgentNotificationHandler,
ScanListener {
    public static final long AIREPORT_MAX_SLEEP_WAIT = 3600000L;
    public static final long AIREPORT_MAX_TRY_TIME = 2592000000L;
    private AICommandsAPI _verAPI = new AICommandsAPI();
    private AgentDaemon _agent;
    private AgentStorageProvider _storage;
    private Log _log = LogFactory.getLog(AutoinventoryCommandsServer.class);
    private RuntimeAutodiscoverer _rtAutodiscoverer;
    private AICommandsService _aiCommandsService;
    private AutoApproveConfig _autoApproveConfig;
    protected String _certDN;
    private ScanManager _scanManager;
    private ScanState _lastCompletedDefaultScanState;
    private AutoinventoryCallbackClient _client;

    public AgentAPIInfo getAPIInfo() {
        return this._verAPI;
    }

    public String[] getCommandSet() {
        return AICommandsAPI.commandSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AgentRemoteValue dispatchCommand(String cmd, AgentRemoteValue args, InputStream in, OutputStream out) throws AgentRemoteException {
        this._log.debug((Object)("AICommandsServer: asked to invoke cmd=" + cmd));
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            AgentRemoteValue agentRemoteValue = this.dispatchCommand_internal(cmd, args);
            return agentRemoteValue;
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    public void startup(AgentDaemon agent) throws AgentStartException {
        AgentTransportLifecycle agentTransportLifecycle;
        AutoinventoryPluginManager pluginManager;
        try {
            this._agent = agent;
            this._storage = agent.getStorageProvider();
            this._client = this.setupClient();
            this._certDN = this._storage.getValue("agent.certDN");
        }
        catch (AgentRunningException exc) {
            throw new AgentAssertionException("Agent should be running here");
        }
        this._autoApproveConfig = new AutoApproveConfig(this._agent.getBootConfig().getConfDirName(), AgentConfig.DEFAULT_PROP_ENC_KEY_FILE);
        try {
            pluginManager = (AutoinventoryPluginManager)agent.getPluginManager("autoinventory");
        }
        catch (Exception e) {
            throw new AgentStartException("Unable to get auto inventory plugin manager: " + e.getMessage());
        }
        this._rtAutodiscoverer = new RuntimeAutodiscoverer(this, this._storage, this._agent, this._client);
        this._scanManager = new ScanManager((ScanListener)this, pluginManager, (RuntimeScanner)this._rtAutodiscoverer, this._autoApproveConfig);
        this._aiCommandsService = new AICommandsService(pluginManager, this._rtAutodiscoverer, this._scanManager);
        try {
            agentTransportLifecycle = agent.getAgentTransportLifecycle();
        }
        catch (Exception e) {
            throw new AgentStartException("Unable to get agent transport lifecycle: " + e.getMessage());
        }
        this._log.info((Object)"Registering AI Commands Service with Agent Transport");
        try {
            agentTransportLifecycle.registerService(AICommandsClient.class, (Object)this._aiCommandsService);
        }
        catch (Exception e) {
            throw new AgentStartException("Failed to register AI Commands Service.", e);
        }
        this._scanManager.startup();
        if (CommandsAPIInfo.getProvider((AgentStorageProvider)this._storage) == null) {
            agent.registerNotifyHandler((AgentNotificationHandler)this, CommandsAPIInfo.NOTIFY_SERVER_SET);
        } else {
            this._rtAutodiscoverer.triggerDefaultScan();
        }
        this._log.info((Object)"Autoinventory Commands Server started up");
    }

    public void handleNotification(String msgClass, String msg) {
        if (msgClass.equals(CommandsAPIInfo.NOTIFY_SERVER_SET)) {
            this._scanManager.interruptHangingScan();
            this._rtAutodiscoverer.triggerDefaultScan();
        }
    }

    public final void postInitActions() throws AgentStartException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this._log.info((Object)"Autoinventory Commands Server shutting down");
        ScanManager scanManager = this._scanManager;
        synchronized (scanManager) {
            this._scanManager.shutdown(3000L);
        }
        this._log.info((Object)"Autoinventory Commands Server shut down");
    }

    public void scanComplete(ScanState scanState) throws AutoinventoryException, SystemException {
        if (scanState.getIsDefaultScan()) {
            if (this._lastCompletedDefaultScanState != null) {
                try {
                    if (this._lastCompletedDefaultScanState.isSameState(scanState)) {
                        this._log.debug((Object)"Default scan didn't find any changes, not sending report to the server");
                        return;
                    }
                }
                catch (AutoinventoryException e) {
                    this._log.error((Object)("Error comparing default scan states: " + (Object)((Object)e)), (Throwable)e);
                }
            }
            this._lastCompletedDefaultScanState = scanState;
        }
        this._aiCommandsService.setMostRecentState(scanState);
        AIPlatformValue aiPlatformValue = scanState.getPlatform();
        if (aiPlatformValue == null) {
            try {
                ByteArrayOutputStream errInfo = new ByteArrayOutputStream();
                PrintStream errInfoPS = new PrintStream(errInfo);
                scanState.printFullStatus(errInfoPS);
                this._log.warn((Object)("AICommandsServer: scan completed, but we could not even detect the platform, so nothing will be reported to the server.  Here is some information about the error that occurred: \n" + errInfo.toString() + "\n"));
            }
            catch (Exception e) {
                this._log.warn((Object)("AICommandsServer: scan completed, but we could not even detect the platform, so nothing will be reported to the server.  More information would be provided, but this error occurred just trying to generate more information about the error: " + e), (Throwable)e);
            }
        }
        this.applyAutoApproval(aiPlatformValue);
        scanState.setCertDN(this._certDN);
        long sleepWaitMillis = 15000L;
        long firstTryTime = System.currentTimeMillis();
        while (true) {
            try {
                if (this._log.isDebugEnabled()) {
                    this._log.debug((Object)("Sending autoinventory report to server: " + scanState));
                }
                this._client.aiSendReport(scanState);
                this._log.info((Object)"Autoinventory report successfully sent to server.");
            }
            catch (Exception e) {
                String eMsg;
                long diffTime = System.currentTimeMillis() - firstTryTime;
                if (diffTime > 2592000000L) {
                    eMsg = "Unable to send autoinventory platform data to server for maximum time of " + StringUtil.formatDuration((long)2592000000L) + ", giving up.  Error was: " + e.getMessage();
                    if (this._log.isDebugEnabled()) {
                        this._log.debug((Object)eMsg, (Throwable)e);
                    } else {
                        this._log.error((Object)eMsg);
                    }
                    return;
                }
                eMsg = "Unable to send autoinventory platform data to server, sleeping for " + String.valueOf(sleepWaitMillis / 1000L) + " secs before " + "retrying.  Error: " + e.getMessage();
                if (this._log.isDebugEnabled()) {
                    this._log.debug((Object)eMsg, (Throwable)e);
                } else {
                    this._log.error((Object)eMsg);
                }
                try {
                    Thread.sleep(sleepWaitMillis);
                    if ((sleepWaitMillis += sleepWaitMillis / 2L) <= 3600000L) continue;
                    sleepWaitMillis = 3600000L;
                }
                catch (InterruptedException ie) {}
                continue;
            }
            break;
        }
    }

    protected void scheduleDefaultScan() {
        this._log.debug((Object)"Scheduling DefaultScan...");
        ScanConfiguration scanConfig = new ScanConfiguration();
        scanConfig.setIsDefaultScan(true);
        this._aiCommandsService.startScan(scanConfig);
    }

    private AgentRemoteValue dispatchCommand_internal(String cmd, AgentRemoteValue args) throws AgentRemoteException {
        this._scanManager.interruptHangingScan();
        if (cmd.equals("autoinv:startScan")) {
            ScanConfigurationCore scanConfig;
            try {
                scanConfig = ScanConfigurationCore.fromAgentRemoteValue((String)"scanConfig", (AgentRemoteValue)args);
            }
            catch (Exception e) {
                this._log.error((Object)"Error starting scan.", (Throwable)e);
                throw new AgentRemoteException("Error starting scan: " + e.toString());
            }
            this._aiCommandsService.startScan(scanConfig, false);
            return null;
        }
        if (cmd.equals("autoinv:stopScan")) {
            this._aiCommandsService.stopScan(false);
            return null;
        }
        if (cmd.equals("autoinv:getScanStatus")) {
            AgentRemoteValue rval = new AgentRemoteValue();
            ScanStateCore state = this._aiCommandsService.getScanStatus(false);
            try {
                state.toAgentRemoteValue("scanState", rval);
            }
            catch (Exception e) {
                this._log.error((Object)"Error getting scan state.", (Throwable)e);
                throw new AgentRemoteException("Error getting scan status: " + e.toString());
            }
            return rval;
        }
        if (cmd.equals("autoinv:pushRuntimeDiscoveryConfig")) {
            this._aiCommandsService.pushRuntimeDiscoveryConfig(args, false);
            return null;
        }
        throw new AgentRemoteException("Unknown command: " + cmd);
    }

    private AutoinventoryCallbackClient setupClient() {
        StorageProviderFetcher fetcher = new StorageProviderFetcher(this._storage);
        return new AutoinventoryCallbackClient((ProviderFetcher)fetcher);
    }

    private void applyAutoApproval(AIPlatformValue aiPlatformValue) {
        if (!this._autoApproveConfig.exists()) {
            this._log.info((Object)"no resource is auto approved");
            return;
        }
        boolean approvePlatform = this._autoApproveConfig.isAutoApproved("platform");
        aiPlatformValue.setAutoApprove(approvePlatform);
        AIServerValue[] aiServerValues = aiPlatformValue.getAIServerValues();
        if (aiServerValues != null) {
            for (AIServerValue aiServerValue : aiServerValues) {
                boolean approveServer = this._autoApproveConfig.isAutoApproved(aiServerValue.getName());
                this._log.info((Object)("--- Auto-Approve for Server: [" + aiServerValue.getName() + "] is: " + approveServer));
                aiServerValue.setAutoApprove(approveServer);
            }
        }
    }
}

