/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.appdef.shared;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.hyperic.hq.appdef.shared.AIAppdefResourceValue;
import org.hyperic.hq.appdef.shared.AIIpValue;
import org.hyperic.hq.appdef.shared.AIServerValue;
import org.hyperic.hq.product.PlatformDetector;

public class AIPlatformValue
extends AIAppdefResourceValue
implements Serializable {
    private String agentToken;
    private boolean agentTokenHasBeenSet = false;
    private int queueStatus;
    private boolean queueStatusHasBeenSet = false;
    private byte[] customProperties;
    private boolean customPropertiesHasBeenSet = false;
    private byte[] productConfig;
    private boolean productConfigHasBeenSet = false;
    private byte[] controlConfig;
    private boolean controlConfigHasBeenSet = false;
    private byte[] measurementConfig;
    private boolean measurementConfigHasBeenSet = false;
    private long diff;
    private boolean diffHasBeenSet = false;
    private boolean ignored;
    private boolean ignoredHasBeenSet = false;
    private String platformTypeName;
    private boolean platformTypeNameHasBeenSet = false;
    private Long lastApproved;
    private boolean lastApprovedHasBeenSet = false;
    private String certdn;
    private boolean certdnHasBeenSet = false;
    private String fqdn;
    private boolean fqdnHasBeenSet = false;
    private String name;
    private boolean nameHasBeenSet = false;
    private String location;
    private boolean locationHasBeenSet = false;
    private String description;
    private boolean descriptionHasBeenSet = false;
    private Integer cpuCount;
    private boolean cpuCountHasBeenSet = false;
    private Integer id;
    private boolean idHasBeenSet = false;
    private Long mTime;
    private boolean mTimeHasBeenSet = false;
    private Long cTime;
    private boolean cTimeHasBeenSet = false;
    private Collection AIIpValues = new HashSet();
    private Collection AIServerValues = new HashSet();
    protected Collection addedAIIpValues = new HashSet();
    protected Collection removedAIIpValues = new HashSet();
    protected Collection updatedAIIpValues = new HashSet();
    protected Collection addedAIServerValues = new HashSet();
    protected Collection removedAIServerValues = new HashSet();
    protected Collection updatedAIServerValues = new HashSet();

    public AIPlatformValue() {
    }

    public AIPlatformValue(String agentToken, int queueStatus, byte[] customProperties, byte[] productConfig, byte[] controlConfig, byte[] measurementConfig, long diff, boolean ignored, String platformTypeName, Long lastApproved, String certdn, String fqdn, String name, String location, String description, Integer cpuCount, Integer id, Long mTime, Long cTime) {
        this.agentToken = agentToken;
        this.agentTokenHasBeenSet = true;
        this.queueStatus = queueStatus;
        this.queueStatusHasBeenSet = true;
        this.customProperties = customProperties;
        this.customPropertiesHasBeenSet = true;
        this.productConfig = productConfig;
        this.productConfigHasBeenSet = true;
        this.controlConfig = controlConfig;
        this.controlConfigHasBeenSet = true;
        this.measurementConfig = measurementConfig;
        this.measurementConfigHasBeenSet = true;
        this.diff = diff;
        this.diffHasBeenSet = true;
        this.ignored = ignored;
        this.ignoredHasBeenSet = true;
        this.platformTypeName = platformTypeName;
        this.platformTypeNameHasBeenSet = true;
        this.lastApproved = lastApproved;
        this.lastApprovedHasBeenSet = true;
        this.certdn = certdn;
        this.certdnHasBeenSet = true;
        this.fqdn = fqdn;
        this.fqdnHasBeenSet = true;
        this.name = name;
        this.nameHasBeenSet = true;
        this.location = location;
        this.locationHasBeenSet = true;
        this.description = description;
        this.descriptionHasBeenSet = true;
        this.cpuCount = cpuCount;
        this.cpuCountHasBeenSet = true;
        this.id = id;
        this.idHasBeenSet = true;
        this.mTime = mTime;
        this.mTimeHasBeenSet = true;
        this.cTime = cTime;
        this.cTimeHasBeenSet = true;
    }

    public AIPlatformValue(AIPlatformValue otherValue) {
        this.agentToken = otherValue.agentToken;
        this.agentTokenHasBeenSet = true;
        this.queueStatus = otherValue.queueStatus;
        this.queueStatusHasBeenSet = true;
        this.customProperties = otherValue.customProperties;
        this.customPropertiesHasBeenSet = true;
        this.productConfig = otherValue.productConfig;
        this.productConfigHasBeenSet = true;
        this.controlConfig = otherValue.controlConfig;
        this.controlConfigHasBeenSet = true;
        this.measurementConfig = otherValue.measurementConfig;
        this.measurementConfigHasBeenSet = true;
        this.diff = otherValue.diff;
        this.diffHasBeenSet = true;
        this.ignored = otherValue.ignored;
        this.ignoredHasBeenSet = true;
        this.platformTypeName = otherValue.platformTypeName;
        this.platformTypeNameHasBeenSet = true;
        this.lastApproved = otherValue.lastApproved;
        this.lastApprovedHasBeenSet = true;
        this.certdn = otherValue.certdn;
        this.certdnHasBeenSet = true;
        this.fqdn = otherValue.fqdn;
        this.fqdnHasBeenSet = true;
        this.name = otherValue.name;
        this.nameHasBeenSet = true;
        this.location = otherValue.location;
        this.locationHasBeenSet = true;
        this.description = otherValue.description;
        this.descriptionHasBeenSet = true;
        this.cpuCount = otherValue.cpuCount;
        this.cpuCountHasBeenSet = true;
        this.id = otherValue.id;
        this.idHasBeenSet = true;
        this.mTime = otherValue.mTime;
        this.mTimeHasBeenSet = true;
        this.cTime = otherValue.cTime;
        this.cTimeHasBeenSet = true;
        this.AIIpValues = otherValue.AIIpValues;
        this.AIServerValues = otherValue.AIServerValues;
        super.setAutoApprove(otherValue.isAutoApprove());
    }

    public String getAgentToken() {
        return this.agentToken;
    }

    public void setAgentToken(String agentToken) {
        this.agentToken = agentToken;
        this.agentTokenHasBeenSet = true;
    }

    public boolean agentTokenHasBeenSet() {
        return this.agentTokenHasBeenSet;
    }

    public int getQueueStatus() {
        return this.queueStatus;
    }

    public void setQueueStatus(int queueStatus) {
        this.queueStatus = queueStatus;
        this.queueStatusHasBeenSet = true;
    }

    public boolean queueStatusHasBeenSet() {
        return this.queueStatusHasBeenSet;
    }

    public byte[] getCustomProperties() {
        return this.customProperties;
    }

    public void setCustomProperties(byte[] customProperties) {
        this.customProperties = customProperties;
        this.customPropertiesHasBeenSet = true;
    }

    public boolean customPropertiesHasBeenSet() {
        return this.customPropertiesHasBeenSet;
    }

    public byte[] getProductConfig() {
        return this.productConfig;
    }

    public void setProductConfig(byte[] productConfig) {
        this.productConfig = productConfig;
        this.productConfigHasBeenSet = true;
    }

    public boolean productConfigHasBeenSet() {
        return this.productConfigHasBeenSet;
    }

    public byte[] getControlConfig() {
        return this.controlConfig;
    }

    public void setControlConfig(byte[] controlConfig) {
        this.controlConfig = controlConfig;
        this.controlConfigHasBeenSet = true;
    }

    public boolean controlConfigHasBeenSet() {
        return this.controlConfigHasBeenSet;
    }

    public byte[] getMeasurementConfig() {
        return this.measurementConfig;
    }

    public void setMeasurementConfig(byte[] measurementConfig) {
        this.measurementConfig = measurementConfig;
        this.measurementConfigHasBeenSet = true;
    }

    public boolean measurementConfigHasBeenSet() {
        return this.measurementConfigHasBeenSet;
    }

    public long getDiff() {
        return this.diff;
    }

    public void setDiff(long diff) {
        this.diff = diff;
        this.diffHasBeenSet = true;
    }

    public boolean diffHasBeenSet() {
        return this.diffHasBeenSet;
    }

    public boolean getIgnored() {
        return this.ignored;
    }

    public void setIgnored(boolean ignored) {
        this.ignored = ignored;
        this.ignoredHasBeenSet = true;
    }

    public boolean ignoredHasBeenSet() {
        return this.ignoredHasBeenSet;
    }

    public String getPlatformTypeName() {
        return this.platformTypeName;
    }

    public void setPlatformTypeName(String platformTypeName) {
        this.platformTypeName = platformTypeName;
        this.platformTypeNameHasBeenSet = true;
    }

    public boolean platformTypeNameHasBeenSet() {
        return this.platformTypeNameHasBeenSet;
    }

    public Long getLastApproved() {
        return this.lastApproved;
    }

    public void setLastApproved(Long lastApproved) {
        this.lastApproved = lastApproved;
        this.lastApprovedHasBeenSet = true;
    }

    public boolean lastApprovedHasBeenSet() {
        return this.lastApprovedHasBeenSet;
    }

    public String getCertdn() {
        return this.certdn;
    }

    public void setCertdn(String certdn) {
        this.certdn = certdn;
        this.certdnHasBeenSet = true;
    }

    public boolean certdnHasBeenSet() {
        return this.certdnHasBeenSet;
    }

    public String getFqdn() {
        return this.fqdn;
    }

    public void setFqdn(String fqdn) {
        this.fqdn = fqdn;
        this.fqdnHasBeenSet = true;
    }

    public boolean fqdnHasBeenSet() {
        return this.fqdnHasBeenSet;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.nameHasBeenSet = true;
    }

    public boolean nameHasBeenSet() {
        return this.nameHasBeenSet;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
        this.locationHasBeenSet = true;
    }

    public boolean locationHasBeenSet() {
        return this.locationHasBeenSet;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
        this.descriptionHasBeenSet = true;
    }

    public boolean descriptionHasBeenSet() {
        return this.descriptionHasBeenSet;
    }

    public Integer getCpuCount() {
        return this.cpuCount;
    }

    public void setCpuCount(Integer cpuCount) {
        this.cpuCount = cpuCount;
        this.cpuCountHasBeenSet = true;
    }

    public boolean cpuCountHasBeenSet() {
        return this.cpuCountHasBeenSet;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
        this.idHasBeenSet = true;
    }

    public boolean idHasBeenSet() {
        return this.idHasBeenSet;
    }

    public Long getMTime() {
        return this.mTime;
    }

    public void setMTime(Long mTime) {
        this.mTime = mTime;
        this.mTimeHasBeenSet = true;
    }

    public boolean mTimeHasBeenSet() {
        return this.mTimeHasBeenSet;
    }

    public Long getCTime() {
        return this.cTime;
    }

    public void setCTime(Long cTime) {
        this.cTime = cTime;
        this.cTimeHasBeenSet = true;
    }

    public boolean cTimeHasBeenSet() {
        return this.cTimeHasBeenSet;
    }

    public Collection getAddedAIIpValues() {
        return this.addedAIIpValues;
    }

    public Collection getRemovedAIIpValues() {
        return this.removedAIIpValues;
    }

    public Collection getUpdatedAIIpValues() {
        return this.updatedAIIpValues;
    }

    public AIIpValue[] getAIIpValues() {
        return this.AIIpValues.toArray(new AIIpValue[this.AIIpValues.size()]);
    }

    public void addAIIpValue(AIIpValue added) {
        int ipStatus;
        if (!this.AIIpValues.contains(added)) {
            this.AIIpValues.add(added);
        }
        if ((ipStatus = added.getQueueStatus()) == 1) {
            this.addedAIIpValues.add(added);
        } else if (ipStatus == 2) {
            this.updatedAIIpValues.add(added);
        } else if (ipStatus == 3) {
            this.removedAIIpValues.add(added);
        }
    }

    public void removeAIIpValue(AIIpValue removed) {
        this.AIIpValues.remove(removed);
        this.removedAIIpValues.add(removed);
        if (this.addedAIIpValues.contains(removed)) {
            this.addedAIIpValues.remove(removed);
        }
        if (this.updatedAIIpValues.contains(removed)) {
            this.updatedAIIpValues.remove(removed);
        }
    }

    public void removeAllAIIpValues() {
        this.AIIpValues.clear();
    }

    public void updateAIIpValue(AIIpValue updated) {
        if (!this.updatedAIIpValues.contains(updated)) {
            this.updatedAIIpValues.add(updated);
        }
    }

    public void cleanAIIpValue() {
        this.addedAIIpValues = new HashSet();
        this.removedAIIpValues = new HashSet();
        this.updatedAIIpValues = new HashSet();
    }

    public void copyAIIpValuesFrom(AIPlatformValue from) {
        this.AIIpValues = from.AIIpValues;
    }

    public Collection getAddedAIServerValues() {
        return this.addedAIServerValues;
    }

    public Collection getRemovedAIServerValues() {
        return this.removedAIServerValues;
    }

    public Collection getUpdatedAIServerValues() {
        return this.updatedAIServerValues;
    }

    public AIServerValue[] getAIServerValues() {
        return this.AIServerValues.toArray(new AIServerValue[this.AIServerValues.size()]);
    }

    public void addAIServerValue(AIServerValue added) {
        this.AIServerValues.add(added);
        if (!this.addedAIServerValues.contains(added)) {
            this.addedAIServerValues.add(added);
        }
    }

    public void removeAIServerValue(AIServerValue removed) {
        this.AIServerValues.remove(removed);
        this.removedAIServerValues.add(removed);
        if (this.addedAIServerValues.contains(removed)) {
            this.addedAIServerValues.remove(removed);
        }
        if (this.updatedAIServerValues.contains(removed)) {
            this.updatedAIServerValues.remove(removed);
        }
    }

    public void removeAllAIServerValues() {
        this.AIServerValues.clear();
    }

    public void updateAIServerValue(AIServerValue updated) {
        if (!this.updatedAIServerValues.contains(updated)) {
            this.updatedAIServerValues.add(updated);
        }
    }

    public void cleanAIServerValue() {
        this.addedAIServerValues = new HashSet();
        this.removedAIServerValues = new HashSet();
        this.updatedAIServerValues = new HashSet();
    }

    public void copyAIServerValuesFrom(AIPlatformValue from) {
        this.AIServerValues = from.AIServerValues;
    }

    public String toString() {
        StringBuffer str = new StringBuffer("{");
        str.append("agentToken=" + this.getAgentToken() + " " + "queueStatus=" + this.getQueueStatus() + " " + "customProperties=" + this.getCustomProperties() + " " + "productConfig=" + this.getProductConfig() + " " + "controlConfig=" + this.getControlConfig() + " " + "measurementConfig=" + this.getMeasurementConfig() + " " + "diff=" + this.getDiff() + " " + "ignored=" + this.getIgnored() + " " + "platformTypeName=" + this.getPlatformTypeName() + " " + "lastApproved=" + this.getLastApproved() + " " + "certdn=" + this.getCertdn() + " " + "fqdn=" + this.getFqdn() + " " + "name=" + this.getName() + " " + "location=" + this.getLocation() + " " + "description=" + this.getDescription() + " " + "cpuCount=" + this.getCpuCount() + " " + "id=" + this.getId() + " " + "mTime=" + this.getMTime() + " " + "cTime=" + this.getCTime());
        str.append('}');
        return str.toString();
    }

    protected boolean hasIdentity() {
        boolean ret = true;
        ret = ret && this.idHasBeenSet;
        return ret;
    }

    public boolean equals(Object other) {
        if (!this.hasIdentity()) {
            return false;
        }
        if (other instanceof AIPlatformValue) {
            AIPlatformValue that = (AIPlatformValue)other;
            if (!that.hasIdentity()) {
                return false;
            }
            boolean lEquals = true;
            lEquals = this.id == null ? lEquals && that.id == null : lEquals && this.id.equals(that.id);
            lEquals = lEquals && this.isIdentical(that);
            return lEquals;
        }
        return false;
    }

    public boolean isIdentical(Object other) {
        if (other instanceof AIPlatformValue) {
            List<AIAppdefResourceValue> cmr2;
            List<AIAppdefResourceValue> cmr1;
            AIPlatformValue that = (AIPlatformValue)other;
            boolean lEquals = true;
            lEquals = this.agentToken == null ? lEquals && that.agentToken == null : lEquals && this.agentToken.equals(that.agentToken);
            lEquals = lEquals && this.queueStatus == that.queueStatus;
            lEquals = lEquals && this.customProperties == that.customProperties;
            lEquals = lEquals && this.productConfig == that.productConfig;
            lEquals = lEquals && this.controlConfig == that.controlConfig;
            lEquals = lEquals && this.measurementConfig == that.measurementConfig;
            lEquals = lEquals && this.diff == that.diff;
            boolean bl = lEquals = lEquals && this.ignored == that.ignored;
            if (this.platformTypeName == null) {
                lEquals = lEquals && that.platformTypeName == null;
            } else {
                boolean bl2 = lEquals = lEquals && this.platformTypeName.equals(that.platformTypeName);
            }
            if (this.lastApproved == null) {
                lEquals = lEquals && that.lastApproved == null;
            } else {
                boolean bl3 = lEquals = lEquals && this.lastApproved.equals(that.lastApproved);
            }
            if (this.certdn == null) {
                lEquals = lEquals && that.certdn == null;
            } else {
                boolean bl4 = lEquals = lEquals && this.certdn.equals(that.certdn);
            }
            if (this.fqdn == null) {
                lEquals = lEquals && that.fqdn == null;
            } else {
                boolean bl5 = lEquals = lEquals && this.fqdn.equals(that.fqdn);
            }
            if (this.name == null) {
                lEquals = lEquals && that.name == null;
            } else {
                boolean bl6 = lEquals = lEquals && this.name.equals(that.name);
            }
            if (this.location == null) {
                lEquals = lEquals && that.location == null;
            } else {
                boolean bl7 = lEquals = lEquals && this.location.equals(that.location);
            }
            if (this.description == null) {
                lEquals = lEquals && that.description == null;
            } else {
                boolean bl8 = lEquals = lEquals && this.description.equals(that.description);
            }
            if (this.cpuCount == null) {
                lEquals = lEquals && that.cpuCount == null;
            } else {
                boolean bl9 = lEquals = lEquals && this.cpuCount.equals(that.cpuCount);
            }
            if (this.mTime == null) {
                lEquals = lEquals && that.mTime == null;
            } else {
                boolean bl10 = lEquals = lEquals && this.mTime.equals(that.mTime);
            }
            if (this.cTime == null) {
                lEquals = lEquals && that.cTime == null;
            } else {
                boolean bl11 = lEquals = lEquals && this.cTime.equals(that.cTime);
            }
            if (this.getAIIpValues() == null) {
                lEquals = lEquals && that.getAIIpValues() == null;
            } else {
                cmr1 = Arrays.asList(this.getAIIpValues());
                cmr2 = Arrays.asList(that.getAIIpValues());
                boolean bl12 = lEquals = lEquals && cmr1.containsAll(cmr2);
            }
            if (this.getAIServerValues() == null) {
                lEquals = lEquals && that.getAIServerValues() == null;
            } else {
                cmr1 = Arrays.asList(this.getAIServerValues());
                cmr2 = Arrays.asList(that.getAIServerValues());
                lEquals = lEquals && cmr1.containsAll(cmr2);
            }
            return lEquals;
        }
        return false;
    }

    public int hashCode() {
        long l;
        int i;
        int result = 17;
        result = 37 * result + (this.agentToken != null ? this.agentToken.hashCode() : 0);
        result = 37 * result + this.queueStatus;
        for (i = 0; this.customProperties != null && i < this.customProperties.length; ++i) {
            l = this.customProperties[i];
            result = 37 * result + (int)(l ^ l >>> 32);
        }
        for (i = 0; this.productConfig != null && i < this.productConfig.length; ++i) {
            l = this.productConfig[i];
            result = 37 * result + (int)(l ^ l >>> 32);
        }
        for (i = 0; this.controlConfig != null && i < this.controlConfig.length; ++i) {
            l = this.controlConfig[i];
            result = 37 * result + (int)(l ^ l >>> 32);
        }
        for (i = 0; this.measurementConfig != null && i < this.measurementConfig.length; ++i) {
            l = this.measurementConfig[i];
            result = 37 * result + (int)(l ^ l >>> 32);
        }
        result = 37 * result + (int)(this.diff ^ this.diff >>> 32);
        result = 37 * result + (this.ignored ? 0 : 1);
        result = 37 * result + (this.platformTypeName != null ? this.platformTypeName.hashCode() : 0);
        result = 37 * result + (this.lastApproved != null ? this.lastApproved.hashCode() : 0);
        result = 37 * result + (this.certdn != null ? this.certdn.hashCode() : 0);
        result = 37 * result + (this.fqdn != null ? this.fqdn.hashCode() : 0);
        result = 37 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 37 * result + (this.location != null ? this.location.hashCode() : 0);
        result = 37 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 37 * result + (this.cpuCount != null ? this.cpuCount.hashCode() : 0);
        result = 37 * result + (this.id != null ? this.id.hashCode() : 0);
        result = 37 * result + (this.mTime != null ? this.mTime.hashCode() : 0);
        result = 37 * result + (this.cTime != null ? this.cTime.hashCode() : 0);
        result = 37 * result + (this.getAIIpValues() != null ? this.getAIIpValues().hashCode() : 0);
        result = 37 * result + (this.getAIServerValues() != null ? this.getAIServerValues().hashCode() : 0);
        return result;
    }

    public boolean isPlatformDevice() {
        if (!(this instanceof AIPlatformValue)) {
            return false;
        }
        AIPlatformValue platform = this;
        return !PlatformDetector.isSupportedPlatform(platform.getPlatformTypeName());
    }
}

