/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.bizapp.shared.lather;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.appdef.shared.AppdefEntityID;
import org.hyperic.hq.bizapp.shared.lather.SecureAgentLatherValue;
import org.hyperic.hq.measurement.data.DSNList;
import org.hyperic.hq.measurement.data.MeasurementReport;
import org.hyperic.hq.measurement.data.MeasurementReportConstructor;
import org.hyperic.hq.measurement.data.ValueList;
import org.hyperic.hq.measurement.server.session.SRN;
import org.hyperic.hq.product.MetricValue;
import org.hyperic.lather.LatherKeyNotFoundException;
import org.hyperic.lather.LatherRemoteException;

public class MeasurementSendReport_args
extends SecureAgentLatherValue {
    private static final String logCtx = MeasurementSendReport_args.class.getName();
    private final Log _log = LogFactory.getLog((String)logCtx);
    private static final String PROP_CIDLIST = "cids";
    private static final String PROP_DSNIDLIST = "dsnidss";
    private static final String PROP_TSTAMPLIST = "tstamps";
    private static final String PROP_VALUELIST = "values";
    private static final String PROP_SRN_ENT_TYPE = "srnEntType";
    private static final String PROP_SRN_ENT_ID = "srnEntId";
    private static final String PROP_SRN_REVNO = "srnRevNo";
    private static final String PROP_AGENT_TOKEN = "agentToken";

    public void setReport(MeasurementReport report) {
        this.addStringToList(PROP_AGENT_TOKEN, report.getAgentToken());
        DSNList[] clientIDs = report.getClientIdList();
        for (int cidIdx = 0; cidIdx < clientIDs.length; ++cidIdx) {
            ValueList[] dsns = clientIDs[cidIdx].getDsns();
            for (int dsnIdx = 0; dsnIdx < dsns.length; ++dsnIdx) {
                MetricValue[] vals = dsns[dsnIdx].getValues();
                for (int valIdx = 0; valIdx < vals.length; ++valIdx) {
                    this.addIntToList(PROP_CIDLIST, clientIDs[cidIdx].getClientId());
                    this.addIntToList(PROP_DSNIDLIST, dsns[dsnIdx].getDsnId());
                    this.addDoubleToList(PROP_TSTAMPLIST, vals[valIdx].getTimestamp());
                    this.addDoubleToList(PROP_VALUELIST, vals[valIdx].getValue());
                }
            }
        }
        SRN[] srnList = report.getSRNList();
        for (int i = 0; i < srnList.length; ++i) {
            AppdefEntityID ent = srnList[i].getEntity();
            this.addIntToList(PROP_SRN_ENT_TYPE, ent.getType());
            this.addIntToList(PROP_SRN_ENT_ID, ent.getID());
            this.addIntToList(PROP_SRN_REVNO, srnList[i].getRevisionNumber());
        }
    }

    public MeasurementReport getReport() throws LatherRemoteException {
        MeasurementReportConstructor con = new MeasurementReportConstructor();
        int[] cidList = this.getIntList(PROP_CIDLIST);
        int[] dsnIdList = this.getIntList(PROP_DSNIDLIST);
        double[] tStampList = this.getDoubleList(PROP_TSTAMPLIST);
        double[] valueList = this.getDoubleList(PROP_VALUELIST);
        int[] srnEntTypeList = this.getIntList(PROP_SRN_ENT_TYPE);
        int[] srnEntIdList = this.getIntList(PROP_SRN_ENT_ID);
        int[] srnRevNoList = this.getIntList(PROP_SRN_REVNO);
        if (dsnIdList.length != tStampList.length || dsnIdList.length != valueList.length || dsnIdList.length != cidList.length || srnEntTypeList.length != srnEntIdList.length || srnEntTypeList.length != srnRevNoList.length) {
            throw new LatherRemoteException("Measurement report mismatch");
        }
        for (int i = 0; i < dsnIdList.length; ++i) {
            con.addDataPoint(cidList[i], dsnIdList[i], new MetricValue(valueList[i], (long)tStampList[i]));
        }
        MeasurementReport res = new MeasurementReport();
        try {
            res.setAgentToken(this.getStringValue(PROP_AGENT_TOKEN));
        }
        catch (LatherKeyNotFoundException e) {
            this._log.error((Object)"Unable to find agent token", (Throwable)e);
        }
        res.setClientIdList(con.constructDSNList());
        SRN[] srnList = new SRN[srnEntTypeList.length];
        for (int i = 0; i < srnEntTypeList.length; ++i) {
            SRN srn;
            AppdefEntityID ent = new AppdefEntityID(srnEntTypeList[i], srnEntIdList[i]);
            srnList[i] = srn = new SRN(ent, srnRevNoList[i]);
        }
        res.setSRNList(srnList);
        return res;
    }
}

