/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.product;

import org.hyperic.hq.product.LogTrackPlugin;
import org.hyperic.hq.product.TypeInfo;
import org.hyperic.util.StringUtil;
import org.hyperic.util.config.ConfigOption;
import org.hyperic.util.config.ConfigResponse;
import org.hyperic.util.config.ConfigSchema;
import org.hyperic.util.config.StringConfigOption;

public abstract class LogFileTrackPlugin
extends LogTrackPlugin {
    static final String PROP_FILES = "log_track.files";
    private static final String[] FILES_PROPS = LogFileTrackPlugin.createTypeLabels("log_track.files");
    public static final String PROP_FILES_PLATFORM = FILES_PROPS[1];
    public static final String PROP_FILES_SERVER = FILES_PROPS[2];
    public static final String PROP_FILES_SERVICE = FILES_PROPS[3];

    protected String getDefaultLogFile(TypeInfo info, ConfigResponse config) {
        String file = this.getTypeProperty("DEFAULT_LOG_FILE");
        if (file == null) {
            return "";
        }
        file = info.isWin32Platform() ? StringUtil.replace((String)file, (String)"/", (String)"\\") : StringUtil.replace((String)file, (String)"\\", (String)"/");
        return file;
    }

    protected ConfigOption getFilesOption(TypeInfo info, ConfigResponse config) {
        StringConfigOption option = new StringConfigOption(FILES_PROPS[info.getType()], "Log Files", this.getDefaultLogFile(info, config));
        option.setOptional(true);
        return option;
    }

    public ConfigSchema getConfigSchema(TypeInfo info, ConfigResponse config) {
        ConfigSchema schema = super.getConfigSchema(info, config);
        ConfigOption option = this.getFilesOption(info, config);
        if (option != null) {
            schema.addOption(option);
        }
        return schema;
    }

    public String[] getFiles(ConfigResponse config) {
        int type = this.getTypeInfo().getType();
        String files = config.getValue(FILES_PROPS[type]);
        String installpath = config.getValue("installpath");
        return this.getAbsoluteFiles(files, installpath);
    }
}

