/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.product;

import java.util.ArrayList;
import org.hyperic.hq.product.PlatformDetector;
import org.hyperic.hq.product.PlatformTypeInfo;
import org.hyperic.hq.product.ServerTypeInfo;
import org.hyperic.hq.product.ServiceTypeInfo;
import org.hyperic.hq.product.TypeInfo;

public class TypeBuilder {
    public static final String NO_VERSION = "x";
    public static final String[] ALL_PLATFORM_NAMES = PlatformDetector.PLATFORM_NAMES;
    public static final String[] WIN32_PLATFORM_NAMES = PlatformDetector.WIN32_PLATFORM_NAMES;
    public static final String[] UNIX_PLATFORM_NAMES = PlatformDetector.UNIX_PLATFORM_NAMES;
    private String serverName;
    private String serverDesc;
    private ArrayList types = new ArrayList();
    private String[] platforms = ALL_PLATFORM_NAMES;

    public TypeBuilder() {
    }

    public TypeBuilder(String serverName, String serverDesc) {
        this(serverName, serverDesc, PlatformDetector.PLATFORM_NAMES);
    }

    public TypeBuilder(String serverName, String serverDesc, String[] platforms) {
        this.serverName = serverName;
        this.serverDesc = serverDesc;
        this.platforms = platforms;
    }

    public PlatformTypeInfo addPlatform(String name) {
        PlatformTypeInfo platform = new PlatformTypeInfo(name);
        this.types.add(platform);
        return platform;
    }

    public ServerTypeInfo addServer(String version) {
        return this.addServer(this.serverName, version);
    }

    public ServerTypeInfo addServer(String name, String version) {
        return this.addServer(name, version, this.platforms);
    }

    public ServerTypeInfo addServer(String name, String version, String[] platforms) {
        ServerTypeInfo server = new ServerTypeInfo(TypeBuilder.composeServerTypeName(name, version), name + " " + this.serverDesc, version);
        server.setValidPlatformTypes(platforms);
        this.add(server);
        return server;
    }

    public ServerTypeInfo addServer(ServerTypeInfo server, String[] platforms) {
        ServerTypeInfo pServer = (ServerTypeInfo)server.clone();
        pServer.setValidPlatformTypes(platforms);
        this.add(pServer);
        return pServer;
    }

    public void addServices(ServerTypeInfo server, String[] services) {
        for (int i = 0; i < services.length; ++i) {
            this.addService(server, services[i]);
        }
    }

    public void addServices(ServerTypeInfo server, String[] deployedServices, String[] internalServices) {
        this.addServices(server, deployedServices);
        for (int i = 0; i < internalServices.length; ++i) {
            ServiceTypeInfo service = this.addService(server, internalServices[i]);
            service.setInternal(true);
        }
    }

    public void addServices(ServerTypeInfo fromServer, ServerTypeInfo toServer) {
        ArrayList<ServiceTypeInfo> services = new ArrayList<ServiceTypeInfo>();
        for (int i = 0; i < this.types.size(); ++i) {
            ServiceTypeInfo service;
            ServerTypeInfo server;
            TypeInfo info = (TypeInfo)this.types.get(i);
            if (info.getType() != 3 || (server = (service = (ServiceTypeInfo)info).getServerTypeInfo()) != fromServer) continue;
            service = (ServiceTypeInfo)service.clone();
            service.setServerTypeInfo(toServer);
            services.add(service);
        }
        this.types.addAll(services);
    }

    public ServiceTypeInfo addService(ServerTypeInfo server, String name) {
        ServiceTypeInfo service = new ServiceTypeInfo(TypeBuilder.composeServiceTypeName(server.getName(), name), server.getDescription() + " " + name, server);
        this.add(service);
        return service;
    }

    public static String composeServiceTypeName(String serverName, String serviceName) {
        return serverName + " " + serviceName;
    }

    public static String composeServerTypeName(String name, String version) {
        if (version.equals(NO_VERSION)) {
            return name;
        }
        return name + " " + version;
    }

    public static String composePlatformTypeName(String name, String platformName) {
        return name + " " + platformName;
    }

    public ServerTypeInfo addServerAndServices(ServerTypeInfo server, String[] platforms) {
        ServerTypeInfo pServer = this.addServer(server, platforms);
        this.addServices(server, pServer);
        return pServer;
    }

    public TypeInfo[] getTypes() {
        return this.types.toArray(new TypeInfo[0]);
    }

    public boolean add(TypeInfo type) {
        return this.types.add(type);
    }
}

