/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.product.jmx;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.product.LiveDataPlugin;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.jmx.MxUtil;
import org.hyperic.util.StringUtil;
import org.hyperic.util.config.ConfigOption;
import org.hyperic.util.config.ConfigResponse;
import org.hyperic.util.config.ConfigSchema;
import org.hyperic.util.config.StringConfigOption;

public class MxLiveDataPlugin
extends LiveDataPlugin {
    private static Log _log = LogFactory.getLog(MxLiveDataPlugin.class);
    private static final String PROP_OBJNAME = "ObjectName";
    private static final String PROP_METHOD = "Method";
    private static final String PROP_ATTRIBUTE = "Attribute";
    private static final String PROP_ARGS = "Arguments";
    private static final String CMD_GET = "get";
    private static final String CMD_INVOKE = "invoke";
    private static final String CMD_QUERY = "query";
    private static final String[] _COMMANDS = new String[]{"get", "invoke", "query"};

    private Object queryMBeans(String pattern, Properties props) throws PluginException {
        ObjectName query;
        MBeanServerConnection mServer;
        try {
            mServer = MxUtil.getMBeanServer(props);
        }
        catch (Exception e) {
            throw new PluginException("getMBeanServer(" + props.getProperty("jmx.url") + "): " + e, e);
        }
        try {
            query = new ObjectName(pattern);
        }
        catch (Exception e) {
            throw new PluginException("Invalid query '" + pattern + "': " + e);
        }
        HashMap res = new HashMap();
        try {
            for (ObjectName obj : mServer.queryNames(query, null)) {
                HashMap<String, Object> bean = new HashMap<String, Object>();
                LinkedHashMap attrs = new LinkedHashMap();
                bean.put("Attributes", attrs);
                res.put(obj.toString(), bean);
                MBeanInfo info = mServer.getMBeanInfo(obj);
                MBeanAttributeInfo[] attrInfo = info.getAttributes();
                for (int i = 0; i < attrInfo.length; ++i) {
                    Object val;
                    MBeanAttributeInfo mia = attrInfo[i];
                    String name = mia.getName();
                    HashMap<String, Object> attr = new HashMap<String, Object>();
                    try {
                        val = mServer.getAttribute(obj, name);
                    }
                    catch (Exception e) {
                        continue;
                    }
                    if (val == null) {
                        val = "-";
                    }
                    attr.put("Value", val);
                    attr.put("Description", mia.getDescription());
                    attr.put("isWritable", new Boolean(mia.isWritable()));
                    attrs.put(name, attr);
                }
                bean.put("Methods", info.getOperations());
            }
        }
        catch (Exception e) {
            throw new PluginException("Error in query '" + pattern + "': " + e, e);
        }
        return res;
    }

    public Object getData(String command, ConfigResponse config) throws PluginException {
        Properties props = config.toProperties();
        _log.debug((Object)("Using properties: " + props));
        try {
            Object res;
            String oName = props.getProperty(PROP_OBJNAME);
            if (command.equals(CMD_INVOKE)) {
                String method = props.getProperty(PROP_METHOD);
                if (method == null) {
                    throw new PluginException("No method given.");
                }
                String argsStr = props.getProperty(PROP_ARGS, "");
                List args = StringUtil.explode((String)argsStr, (String)",");
                _log.debug((Object)("Using arguments:" + args));
                res = MxUtil.invoke(props, oName, method, args.toArray(new String[0]), new String[0]);
            } else if (command.equals(CMD_GET)) {
                String attribute = props.getProperty(PROP_ATTRIBUTE);
                if (attribute == null) {
                    throw new PluginException("No attribute given");
                }
                res = MxUtil.getValue(props, oName, attribute);
            } else if (command.equals(CMD_QUERY)) {
                res = this.queryMBeans(oName, props);
            } else {
                throw new PluginException("Unknown command " + command);
            }
            if (res instanceof CompositeData) {
                return this.convertCompositeData((CompositeData)res);
            }
            if (res instanceof CompositeData[]) {
                CompositeData[] o = (CompositeData[])res;
                Map[] ret = new Map[o.length];
                for (int i = 0; i < o.length; ++i) {
                    ret[i] = this.convertCompositeData(o[i]);
                }
                return ret;
            }
            return res;
        }
        catch (Exception e) {
            throw new PluginException(e);
        }
    }

    private Map convertCompositeData(CompositeData data) {
        HashMap<String, Object> retval = new HashMap<String, Object>();
        for (String key : data.getCompositeType().keySet()) {
            Object val = data.get(key);
            retval.put(key, val);
        }
        return retval;
    }

    public String[] getCommands() {
        return _COMMANDS;
    }

    public ConfigSchema getConfigSchema(String command) throws PluginException {
        ConfigSchema schema = new ConfigSchema();
        StringConfigOption objectName = new StringConfigOption(PROP_OBJNAME, "Object name");
        schema.addOption((ConfigOption)objectName);
        if (command.equals(CMD_GET)) {
            StringConfigOption attr = new StringConfigOption(PROP_ATTRIBUTE, "Attribute to get");
            schema.addOption((ConfigOption)attr);
        } else if (command.equals(CMD_INVOKE)) {
            StringConfigOption method = new StringConfigOption(PROP_METHOD, "Method to invoke");
            schema.addOption((ConfigOption)method);
            StringConfigOption args = new StringConfigOption(PROP_ARGS, "Comma separated arguments", "");
            args.setOptional(true);
            schema.addOption((ConfigOption)args);
        } else {
            throw new PluginException("Unknown command " + command);
        }
        return schema;
    }
}

