/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.jboss7;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.hyperic.hq.plugin.jboss7.JBossAdminHttp;
import org.hyperic.hq.product.ControlPlugin;
import org.hyperic.hq.product.PluginException;
import org.hyperic.util.config.ConfigResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBoss7ManagedControl
extends ControlPlugin {
    private final Log log = this.getLog();
    private JBossAdminHttp admin;

    public void configure(ConfigResponse config) throws PluginException {
        super.configure(config);
        this.log.debug((Object)("[configure] config=" + config));
        this.admin = new JBossAdminHttp(this.getConfig().toProperties());
    }

    public List<String> getActions() {
        return Arrays.asList("start", "restart", "stop");
    }

    public void stop() throws PluginException {
        this.log.debug((Object)("[stop] config=" + this.getConfig()));
        if (!this.isRunning()) {
            throw new PluginException("Server is not running");
        }
        this.admin.stop();
    }

    public void start() throws PluginException {
        this.log.debug((Object)("[start] config=" + this.getConfig()));
        if (this.isRunning()) {
            throw new PluginException("Server is running");
        }
        this.admin.start();
    }

    public void restart() throws PluginException {
        this.log.debug((Object)("[restart] config=" + this.getConfig()));
        if (this.isRunning()) {
            this.admin.restart();
        } else {
            this.admin.start();
        }
    }

    protected boolean isRunning() {
        try {
            this.admin.testConnection();
        }
        catch (PluginException ex) {
            this.log.debug((Object)ex, (Throwable)ex);
            return false;
        }
        return true;
    }
}

