/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.agent.server;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.agent.stats.AgentStatsCollector;
import org.hyperic.hq.product.Collector;
import org.hyperic.hq.product.CollectorExecutor;
import org.hyperic.hq.product.PluginManager;

public class CollectorThread
implements Runnable {
    private static Log log = LogFactory.getLog((String)CollectorThread.class.getName());
    private static final int DEFAULT_INTERVAL = 60000;
    private static final String COLLECTOR_THREAD_METRIC_COLLECTED_TIME = "COLLECTOR_THREAD_METRIC_COLLECTED_TIME";
    private Thread thread = null;
    private static CollectorThread instance = null;
    private final AtomicBoolean shouldDie = new AtomicBoolean(false);
    private long interval = 60000L;
    private Properties props;
    private AgentStatsCollector statsCollector;

    public static synchronized CollectorThread getInstance(PluginManager manager) {
        if (instance == null) {
            instance = new CollectorThread();
            CollectorThread.instance.props = manager.getProperties();
        }
        return instance;
    }

    public static synchronized void shutdownInstance() {
        if (instance != null) {
            instance.doStop();
            instance = null;
        }
    }

    public synchronized void doStart() {
        if (this.thread != null) {
            return;
        }
        this.statsCollector = AgentStatsCollector.getInstance();
        this.statsCollector.register(COLLECTOR_THREAD_METRIC_COLLECTED_TIME);
        String interval = System.getProperty("exec.interval");
        if (interval != null) {
            this.interval = Integer.parseInt(interval) * 1000;
        }
        this.thread = new Thread((Runnable)this, "CollectorThread");
        this.thread.setDaemon(true);
        this.thread.start();
        log.info((Object)(this.thread.getName() + " started"));
    }

    public synchronized void doStop() {
        if (this.thread == null) {
            return;
        }
        this.die();
        this.thread.interrupt();
        log.info((Object)(this.thread.getName() + " stopped"));
        this.thread = null;
    }

    public void setInterval(long interval) {
        this.interval = interval;
    }

    public long getInterval() {
        return this.interval;
    }

    public void run() {
        CollectorExecutor executor = new CollectorExecutor(this.props);
        log.debug((Object)("Created ThreadPoolExecutor: corePoolSize=" + executor.getCorePoolSize() + ", " + "maxPoolSize=" + executor.getMaximumPoolSize()));
        while (!this.shouldDie.get()) {
            Collection collectorsToExecute = Collector.getCollectorsToExecute();
            for (Collector collector : collectorsToExecute) {
                if (executor.isPoolable() && collector.isPoolable()) {
                    executor.execute(this.getProxy(collector));
                    continue;
                }
                collector.run();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("CompletedTaskCount=" + executor.getCompletedTaskCount() + ", " + "ActiveCount=" + executor.getActiveCount() + ", " + "TaskCount=" + executor.getTaskCount() + ", " + "PoolSize=" + executor.getPoolSize()));
            }
            try {
                Thread.sleep(this.interval);
            }
            catch (InterruptedException interruptedException) {}
        }
        executor.shutdown();
    }

    private Runnable getProxy(final Collector collector) {
        InvocationHandler handler = new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if ((null == args || args.length == 0) && method.getName().equals("run")) {
                    long start = CollectorThread.this.now();
                    Object rtn = method.invoke((Object)collector, args);
                    long duration = CollectorThread.this.now() - start;
                    CollectorThread.this.statsCollector.addStat(duration, CollectorThread.COLLECTOR_THREAD_METRIC_COLLECTED_TIME);
                    return rtn;
                }
                return method.invoke((Object)collector, args);
            }
        };
        return (Runnable)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{Runnable.class}, handler);
    }

    private long now() {
        return System.currentTimeMillis();
    }

    public void die() {
        this.shouldDie.set(true);
    }
}

