/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.bizapp.agent;

public class ProviderInfo {
    private String providerAddress;
    private String agentToken;
    private boolean isNewTransport;
    private boolean unidirectional;
    private int unidirectionalPort;

    public ProviderInfo(String providerAddress, String agentToken) {
        this.providerAddress = providerAddress;
        this.agentToken = agentToken;
        if (providerAddress == null || agentToken == null) {
            throw new IllegalArgumentException("No arguments can be null");
        }
        this.unidirectionalPort = -1;
    }

    public void setNewTransport(boolean unidirectional, int unidirectionalPort) {
        this.isNewTransport = true;
        this.unidirectional = unidirectional;
        this.unidirectionalPort = unidirectionalPort;
    }

    public String getProviderAddress() {
        return this.providerAddress;
    }

    public String getAgentToken() {
        return this.agentToken;
    }

    public boolean isNewTransport() {
        return this.isNewTransport;
    }

    public boolean isUnidirectional() {
        if (this.unidirectional && !this.isNewTransport()) {
            throw new IllegalStateException("not a new transport");
        }
        return this.unidirectional;
    }

    public int getUnidirectionalPort() {
        if (!this.isNewTransport()) {
            throw new IllegalStateException("not a new transport");
        }
        return this.unidirectionalPort;
    }

    public String toString() {
        return this.providerAddress;
    }
}

