/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.bizapp.agent.client;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Properties;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Category;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.RollingFileAppender;
import org.hyperic.hq.agent.AgentConfig;
import org.hyperic.hq.agent.AgentConfigException;
import org.hyperic.hq.agent.AgentConnectionException;
import org.hyperic.hq.agent.AgentKeystoreConfig;
import org.hyperic.hq.agent.AgentLifecycle;
import org.hyperic.hq.agent.AgentRemoteException;
import org.hyperic.hq.agent.AgentUpgradeManager;
import org.hyperic.hq.agent.client.AgentCommandsClient;
import org.hyperic.hq.agent.client.AgentConnection;
import org.hyperic.hq.agent.client.LegacyAgentCommandsClientImpl;
import org.hyperic.hq.agent.server.AgentDaemon;
import org.hyperic.hq.agent.server.LoggingOutputStream;
import org.hyperic.hq.bizapp.agent.ProviderInfo;
import org.hyperic.hq.bizapp.agent.client.AgentClientUtil;
import org.hyperic.hq.bizapp.agent.client.AgentInvokeException;
import org.hyperic.hq.bizapp.agent.client.CommandsClient;
import org.hyperic.hq.bizapp.agent.client.SecureAgentConnection;
import org.hyperic.hq.bizapp.agent.commands.CreateToken_args;
import org.hyperic.hq.bizapp.agent.commands.CreateToken_result;
import org.hyperic.hq.bizapp.client.AgentCallbackClient;
import org.hyperic.hq.bizapp.client.AgentCallbackClientException;
import org.hyperic.hq.bizapp.client.BizappCallbackClient;
import org.hyperic.hq.bizapp.client.ProviderFetcher;
import org.hyperic.hq.bizapp.client.RegisterAgentResult;
import org.hyperic.hq.bizapp.client.StaticProviderFetcher;
import org.hyperic.hq.common.shared.ProductProperties;
import org.hyperic.sigar.FileInfo;
import org.hyperic.sigar.FileWatcher;
import org.hyperic.sigar.FileWatcherThread;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.util.PropertyEncryptionUtil;
import org.hyperic.util.PropertyUtil;
import org.hyperic.util.StringUtil;
import org.hyperic.util.security.KeystoreConfig;
import org.hyperic.util.security.SecurityUtil;
import org.tanukisoftware.wrapper.WrapperManager;
import sun.misc.Signal;
import sun.misc.SignalHandler;

public class AgentClient {
    private static final PrintStream SYSTEM_ERR = System.err;
    private static final PrintStream SYSTEM_OUT = System.out;
    private static final String PRODUCT = "HQ";
    private static final String QPROP_PRE = "agent.setup.";
    public static final String QPROP_IPADDR = "agent.setup.camIP";
    public static final String QPROP_PORT = "agent.setup.camPort";
    public static final String QPROP_SSLPORT = "agent.setup.camSSLPort";
    public static final String QPROP_NEWTRANSPORT = "agent.setup.newTransport";
    public static final String QPROP_UNI = "agent.setup.unidirectional";
    public static final String QPROP_UNI_POLLING_FREQUENCY = "agent.setup.uniPollingFrequency";
    private static final String QPROP_SECURE = "agent.setup.camSecure";
    private static final String QPROP_LOGIN = "agent.setup.camLogin";
    private static final String QPROP_PWORD = "agent.setup.camPword";
    private static final String QPROP_AGENTIP = "agent.setup.agentIP";
    private static final String QPROP_AGENTPORT = "agent.setup.agentPort";
    private static final String QPROP_RESETUPTOK = "agent.setup.resetupTokens";
    private static final String QPROP_TIMEOUT = "agent.setup.serverTimeout";
    private static final String DEFAULT_LOG_LEVEL = "INFO";
    private static final String LOG_PATTERN_LAYOUT = "%d %-5p [%t] [%c{1}] %m%n";
    private static final int BUFFER_SIZE = 1024;
    private static final String MAX_FILE_SIZE = "5000KB";
    private static final String MAX_FILES = "1";
    private static final String PROP_LOGFILE = "agent.logFile";
    private static final String PROP_STARTUP_TIMEOUT = "agent.startupTimeOut";
    private static final String PROP_FQDN = "platform.fqdn";
    private static final String AGENT_CLASS = "org.hyperic.hq.agent.server.AgentDaemon";
    private static final int AGENT_STARTUP_TIMEOUT = 300000;
    private static final int FORCE_SETUP = -42;
    private static final String JAAS_CONFIG = "jaas.config";
    private final AgentCommandsClient agtCommands;
    private final CommandsClient camCommands;
    private final AgentConfig config;
    private String sslHandlerPkg;
    private final Log log;
    private boolean nuking;
    private boolean redirectedOutputs = false;
    private static Thread agentDaemonThread;
    private static final String PING = "ping";
    private static final String DIE = "die";
    private static final String START = "start";
    private static final String STATUS = "status";
    private static final String RESTART = "restart";
    private static final String SETUP = "setup";
    private static final String SETUP_IF_NO_PROVIDER = "setup-if-no-provider";
    private static final String SET_PROPERTY = "set-property";

    private AgentClient(AgentConfig config, SecureAgentConnection conn) {
        this.agtCommands = new LegacyAgentCommandsClientImpl((AgentConnection)conn);
        this.camCommands = new CommandsClient((AgentConnection)conn);
        this.config = config;
        this.log = LogFactory.getLog(AgentClient.class);
        this.nuking = false;
    }

    private long cmdPing(int numAttempts) throws AgentConnectionException, AgentRemoteException {
        AgentConnectionException lastExc = new AgentConnectionException("Failed to connect to agent");
        while (numAttempts-- != 0) {
            try {
                return this.agtCommands.ping();
            }
            catch (AgentConnectionException exc) {
                lastExc = exc;
                try {
                    if (numAttempts <= 0) continue;
                    Thread.sleep(1000L);
                }
                catch (InterruptedException exc2) {
                    throw new AgentConnectionException("Connection interrupted");
                }
            }
        }
        throw lastExc;
    }

    private void cmdStatus() throws AgentConnectionException, AgentRemoteException {
        String address;
        ProviderInfo pInfo;
        String currentAgentBundle;
        try {
            currentAgentBundle = this.agtCommands.getCurrentAgentBundle();
            pInfo = this.camCommands.getProviderInfo();
        }
        catch (AgentConnectionException exc) {
            SYSTEM_ERR.println("Unable to contact agent: " + exc.getMessage());
            return;
        }
        catch (AgentRemoteException exc) {
            SYSTEM_ERR.println("Error executing remote method: " + exc.getMessage());
            return;
        }
        SYSTEM_OUT.println("Current agent bundle: " + currentAgentBundle);
        if (pInfo == null || (address = pInfo.getProviderAddress()) == null) {
            SYSTEM_OUT.println("Agent not yet setup");
            return;
        }
        try {
            URL url = new URL(address);
            SYSTEM_OUT.println("Server IP address: " + url.getHost());
            String proto = url.getProtocol();
            if (proto.equalsIgnoreCase("https")) {
                SYSTEM_OUT.print("Server (SSL) port: ");
            } else {
                SYSTEM_OUT.print("Server port:       ");
            }
            SYSTEM_OUT.println(url.getPort());
            if (pInfo.isNewTransport()) {
                SYSTEM_OUT.println("Using new transport; unidirectional=" + pInfo.isUnidirectional());
            }
        }
        catch (Exception exc) {
            SYSTEM_OUT.println("Unable to parse provider info (" + address + "): " + exc.getMessage());
        }
        SYSTEM_OUT.println("Agent listen port: " + this.config.getListenPort());
        if (this.config.isProxyServerSet()) {
            SYSTEM_OUT.println("Proxy server IP address: " + this.config.getProxyIp());
            SYSTEM_OUT.println("Proxy server port: " + this.config.getProxyPort());
        }
    }

    private void cmdDie(int waitTime) throws AgentConnectionException, AgentRemoteException {
        try {
            this.agtCommands.die();
        }
        catch (AgentConnectionException exc) {
            return;
        }
        catch (AgentRemoteException exc) {
            throw new AgentRemoteException("Error making remote agent call: " + exc.getMessage());
        }
        while (waitTime-- != 0) {
            try {
                this.agtCommands.ping();
            }
            catch (AgentConnectionException exc) {
                return;
            }
            catch (AgentRemoteException exc) {
                exc.printStackTrace(SYSTEM_ERR);
                throw exc;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException exc) {
                throw new AgentConnectionException("Connection interrupted");
            }
        }
        throw new AgentRemoteException("Unable to kill agent within timeout");
    }

    private void cmdRestart() throws AgentConnectionException, AgentRemoteException {
        try {
            this.agtCommands.restart();
        }
        catch (AgentConnectionException exc) {
            throw new AgentConnectionException("Unable to connect to agent: already dead?");
        }
        catch (AgentRemoteException exc) {
            throw new AgentRemoteException("Error making remote agent call: " + exc.getMessage());
        }
    }

    private String askQuestion(String question, String def, boolean invis, String questionProp) throws IOException {
        String res;
        block7: {
            String bootProp = this.config.getBootProperties().getProperty(questionProp);
            do {
                SYSTEM_OUT.print(question);
                if (def != null) {
                    SYSTEM_OUT.print(" [default=" + def + "]");
                }
                SYSTEM_OUT.print(": ");
                if (invis) {
                    if (bootProp != null) {
                        SYSTEM_OUT.println("**Not echoing value**");
                        return bootProp;
                    }
                    return Sigar.getPassword((String)"");
                }
                if (bootProp != null) {
                    if (bootProp.equals("*default*") && def != null) {
                        bootProp = def;
                    }
                    SYSTEM_OUT.println(bootProp);
                    return bootProp;
                }
                BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
                res = in.readLine();
                if (res != null && (res = res.trim()).length() == 0) {
                    res = null;
                }
                if (res != null) break block7;
            } while (def == null);
            return def;
        }
        return res;
    }

    private String askQuestion(String question, String def, String questionProp) throws IOException {
        return this.askQuestion(question, def, false, questionProp);
    }

    private boolean askYesNoQuestion(String question, boolean def, String questionProp) throws IOException, AutoQuestionException {
        boolean isAuto = this.config.getBootProperties().getProperty(questionProp) != null;
        String res;
        while (!(res = this.askQuestion(question, def ? "yes" : "no", questionProp)).equalsIgnoreCase("yes") && !res.equalsIgnoreCase("y")) {
            if (res.equalsIgnoreCase("no") || res.equalsIgnoreCase("n")) {
                return false;
            }
            if (isAuto) {
                throw new AutoQuestionException("Property '" + questionProp + "' must be 'yes' or " + "'no'");
            }
            SYSTEM_OUT.println("- Value must be 'yes' or 'no'");
        }
        return true;
    }

    private int askIntQuestion(String question, int def, String questionProp) throws IOException, AutoQuestionException {
        boolean isAuto = this.config.getBootProperties().getProperty(questionProp) != null;
        while (true) {
            String res = this.askQuestion(question, Integer.toString(def), questionProp);
            try {
                int iVal = Integer.parseInt(res);
                return iVal;
            }
            catch (NumberFormatException exc) {
                if (isAuto) {
                    throw new AutoQuestionException("Property '" + questionProp + "' must be a valid integer");
                }
                SYSTEM_OUT.println("- Value must be an integer");
                continue;
            }
            break;
        }
    }

    private BizappCallbackClient testProvider(String provider, boolean acceptUnverifiedCertificates) throws AgentCallbackClientException {
        StaticProviderFetcher fetcher = new StaticProviderFetcher(new ProviderInfo(provider, "no-auth"));
        BizappCallbackClient res = new BizappCallbackClient((ProviderFetcher)fetcher, this.config);
        res.bizappPing(acceptUnverifiedCertificates);
        return res;
    }

    private BizappCallbackClient getConnection(String provider, boolean secure) throws AutoQuestionException, AgentCallbackClientException {
        Properties bootP = this.config.getBootProperties();
        long start = System.currentTimeMillis();
        boolean acceptUnverifiedCertificates = secure;
        while (true) {
            String sec = secure ? "secure" : "insecure";
            SYSTEM_OUT.print("- Testing " + sec + " connection ... ");
            try {
                this.log.info((Object)("test connection with accept unverified certificates flag set to " + acceptUnverifiedCertificates));
                BizappCallbackClient bizapp = this.testProvider(provider, acceptUnverifiedCertificates);
                SYSTEM_OUT.println("Success");
                return bizapp;
            }
            catch (AgentCallbackClientException exc) {
                acceptUnverifiedCertificates = false;
                String msg = exc.getMessage();
                if (exc.getExceptionOfType(SSLPeerUnverifiedException.class) != null) {
                    SYSTEM_OUT.println();
                    SYSTEM_OUT.println(exc.getMessage());
                    this.log.error((Object)exc, (Throwable)((Object)exc));
                    String question = "Are you sure you want to continue connecting?";
                    try {
                        if (this.askYesNoQuestion(question, false, "agent.setup.acceptUnverifiedCertificate")) {
                            acceptUnverifiedCertificates = true;
                            continue;
                        }
                    }
                    catch (IOException ioe) {
                        this.log.debug((Object)ioe.getMessage());
                    }
                }
                if (msg.indexOf("is still starting") != -1) {
                    SYSTEM_ERR.println("HQ is still starting (retrying in 10 seconds)");
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException e) {}
                    continue;
                }
                String propTimeout = bootP.getProperty(QPROP_TIMEOUT);
                if (propTimeout != null) {
                    long timeout;
                    try {
                        timeout = Integer.parseInt(propTimeout) * 1000;
                    }
                    catch (NumberFormatException nfe) {
                        throw new AutoQuestionException("Mis-configuredagent.setup.serverTimeoutproperty: " + propTimeout);
                    }
                    SYSTEM_ERR.println("Failure (retrying in 10 seconds)");
                    if (start + timeout > System.currentTimeMillis()) {
                        try {
                            Thread.sleep(10000L);
                        }
                        catch (InterruptedException ie) {}
                        continue;
                    }
                }
                SYSTEM_ERR.println("Failure");
                if (bootP.getProperty(QPROP_IPADDR) != null || bootP.getProperty(QPROP_PORT) != null || bootP.getProperty(QPROP_SSLPORT) != null) {
                    throw new AutoQuestionException("Unable to connect to HQ");
                }
                throw exc;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getCpuCount() throws SigarException {
        int n;
        Sigar sigar = new Sigar();
        try {
            n = sigar.getCpuInfoList().length;
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            sigar.close();
            throw throwable;
        }
        sigar.close();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getDefaultIpAddress() {
        String address;
        String loopback = "127.0.0.1";
        try {
            address = InetAddress.getLocalHost().getHostAddress();
            if (!"127.0.0.1".equals(address)) {
                return address;
            }
        }
        catch (UnknownHostException e) {
            // empty catch block
        }
        Sigar sigar = new Sigar();
        try {
            try {
                address = sigar.getNetInterfaceConfig().getAddress();
            }
            catch (SigarException e) {
                address = "127.0.0.1";
                Object var6_6 = null;
                sigar.close();
                return address;
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            sigar.close();
            throw throwable;
        }
        sigar.close();
        return address;
    }

    private void cmdSetupIfNoProvider() throws AgentConnectionException, AgentRemoteException, IOException, AutoQuestionException {
        Properties bootProps = this.config.getBootProperties();
        int timeout = AgentClient.getStartupTimeout(bootProps);
        this.cmdPing(timeout / 1000);
        ProviderInfo providerInfo = this.camCommands.getProviderInfo();
        if (providerInfo == null) {
            this.cmdSetup();
        }
    }

    private void cmdSetup() throws AgentConnectionException, AgentRemoteException, IOException, AutoQuestionException {
        String agentToken;
        String agentIP;
        String pword;
        String user;
        BizappCallbackClient bizapp;
        String provider;
        String host;
        Properties bootP;
        int unidirectionalPort;
        boolean unidirectional;
        boolean isNewTransportAgent;
        int agentPort;
        block51: {
            int port;
            boolean secure;
            agentPort = -1;
            isNewTransportAgent = false;
            unidirectional = false;
            unidirectionalPort = -1;
            bootP = this.config.getBootProperties();
            try {
                this.cmdPing(1);
            }
            catch (AgentConnectionException exc) {
                SYSTEM_ERR.println("Unable to setup agent: " + exc.getMessage());
                SYSTEM_ERR.println("The Agent must be running prior to running setup");
                return;
            }
            SYSTEM_OUT.println("[ Running agent setup ]");
            if (this.isUnidirectionalAgentSupported()) {
                isNewTransportAgent = unidirectional = this.askYesNoQuestion("Should Agent communications to HQ be unidirectional", false, QPROP_UNI);
            }
            while (true) {
                host = this.askQuestion("What is the HQ server IP address", null, QPROP_IPADDR);
                secure = this.askYesNoQuestion("Should Agent communications to HQ always be secure", true, QPROP_SECURE);
                if (secure) {
                    port = this.askIntQuestion("What is the HQ server SSL port", 7443, QPROP_SSLPORT);
                    provider = AgentCallbackClient.getDefaultProviderURL(host, port, true);
                } else {
                    port = this.askIntQuestion("What is the HQ server port    ", 7080, QPROP_PORT);
                    provider = AgentCallbackClient.getDefaultProviderURL(host, port, false);
                }
                try {
                    bizapp = this.getConnection(provider, secure);
                }
                catch (AgentCallbackClientException e) {
                    continue;
                }
                break;
            }
            if (unidirectional) {
                String fqdn = bootP.getProperty(PROP_FQDN);
                if (fqdn != null) {
                    agentPort = fqdn.hashCode();
                }
                if (secure) {
                    unidirectionalPort = port;
                } else {
                    while (true) {
                        unidirectionalPort = this.askIntQuestion("What is the HQ server SSL port for unidirectional communications", 7443, QPROP_SSLPORT);
                        String unidirectionalProvider = AgentCallbackClient.getDefaultProviderURL(host, unidirectionalPort, true);
                        try {
                            this.getConnection(unidirectionalProvider, true);
                        }
                        catch (AgentCallbackClientException e) {
                            continue;
                        }
                        break;
                    }
                }
            }
            do {
                block50: {
                    user = this.askQuestion("What is your HQ login", "hqadmin", QPROP_LOGIN);
                    pword = this.askQuestion("What is your HQ password", null, true, QPROP_PWORD);
                    try {
                        if (!bizapp.userIsValid(user, pword)) break block50;
                        break block51;
                    }
                    catch (AgentCallbackClientException exc) {
                        this.log.error((Object)exc, (Throwable)((Object)exc));
                        SYSTEM_ERR.println("Error validating user: " + (Object)((Object)exc));
                        return;
                    }
                }
                SYSTEM_ERR.println("- Invalid username/password");
            } while (bootP.getProperty(QPROP_LOGIN) == null && bootP.getProperty(QPROP_PWORD) == null);
            throw new AutoQuestionException("Invalid username/password");
        }
        while (true) {
            String question = unidirectional ? "What is the agent IP address" : "What IP should HQ use to contact the agent";
            agentIP = this.askQuestion(question, this.getDefaultIpAddress(), QPROP_AGENTIP);
            try {
                InetAddress localHost = InetAddress.getByName(agentIP);
                localHost.getHostAddress();
            }
            catch (UnknownHostException exc) {
                SYSTEM_ERR.println("- Unable to resolve host");
                continue;
            }
            break;
        }
        if (!unidirectional) {
            int listenPort;
            while ((agentPort = this.askIntQuestion("What port should HQ use to contact the agent", listenPort = this.config.getListenPort(), QPROP_AGENTPORT)) < 1 || agentPort > 65535) {
                SYSTEM_ERR.println("- Invalid port");
            }
            if (agentPort != listenPort) {
                SYSTEM_ERR.println("- To setup agent port to " + agentPort + "," + " Stop the agent," + " Update agent properties" + " for agent.listenPort and start" + " the agent again");
                SYSTEM_OUT.println("- Now Agent uses the default port:" + listenPort);
                agentPort = listenPort;
            }
        }
        String oldAgentToken = null;
        ProviderInfo providerInfo = this.camCommands.getProviderInfo();
        if (providerInfo != null && providerInfo.getProviderAddress() != null && providerInfo.getAgentToken() != null) {
            oldAgentToken = providerInfo.getAgentToken();
            SYSTEM_OUT.println("- Agent is already setup for HQ @ " + providerInfo.getProviderAddress());
            boolean setupTokens = this.askYesNoQuestion("Would you like to re-setup the auth tokens", false, QPROP_RESETUPTOK);
            if (!setupTokens) {
                SYSTEM_OUT.println("- Informing HQ about agent setup changes");
                boolean acceptUnverifiedCertificates = false;
                try {
                    String response;
                    while ((response = bizapp.updateAgent(providerInfo.getAgentToken(), user, pword, agentIP, agentPort, isNewTransportAgent, unidirectional, acceptUnverifiedCertificates)) != null) {
                        if (response.contains("java.security.cert.CertificateException")) {
                            String question = "The server to agent communication channel is using a self-signed certificate and can not be verified\nAre you sure you want to continue connecting?";
                            try {
                                if (this.askYesNoQuestion(question, false, "agent.setup.acceptUnverifiedCertificate")) {
                                    acceptUnverifiedCertificates = true;
                                    continue;
                                }
                            }
                            catch (IOException ioe) {
                                this.log.debug((Object)ioe.getMessage());
                            }
                        }
                        SYSTEM_ERR.println("- Error updating agent: " + response);
                        break;
                    }
                }
                catch (Exception exc) {
                    SYSTEM_ERR.println("- Error updating agent: " + exc.getMessage());
                    return;
                }
                if (providerInfo.isNewTransport() != isNewTransportAgent || providerInfo.isUnidirectional() != unidirectional) {
                    ProviderInfo registeredProviderInfo = new ProviderInfo(provider, providerInfo.getAgentToken());
                    if (isNewTransportAgent) {
                        registeredProviderInfo.setNewTransport(unidirectional, unidirectionalPort);
                    }
                    this.camCommands.setProviderInfo(registeredProviderInfo);
                }
                return;
            }
        }
        try {
            InetAddress.getByName(host);
        }
        catch (UnknownHostException exc) {
            SYSTEM_ERR.println("Unable to resolve provider (strange): " + exc.getMessage());
            return;
        }
        CreateToken_result tokenRes = this.camCommands.createToken(new CreateToken_args());
        SYSTEM_OUT.println("- Received temporary auth token from agent");
        SYSTEM_OUT.println("- Registering agent with HQ");
        boolean acceptUnverifiedCertificates = false;
        while (true) {
            try {
                String response;
                block53: {
                    while (true) {
                        RegisterAgentResult result = bizapp.registerAgent(oldAgentToken, user, pword, tokenRes.getToken(), agentIP, agentPort, ProductProperties.getVersion(), AgentClient.getCpuCount(), isNewTransportAgent, unidirectional, acceptUnverifiedCertificates);
                        response = result.response;
                        if (response.startsWith("token:")) break block53;
                        if (!response.contains("java.security.cert.CertificateException")) break;
                        String question = "The server to agent communication channel is using a self-signed certificate and could not be verified\nAre you sure you want to continue connecting?";
                        try {
                            if (!this.askYesNoQuestion(question, false, "agent.setup.acceptUnverifiedCertificate")) break;
                            acceptUnverifiedCertificates = true;
                        }
                        catch (IOException ioe) {
                            this.log.debug((Object)ioe.getMessage());
                            break;
                        }
                    }
                    SYSTEM_ERR.println("- Unable to register agent: " + response);
                    return;
                }
                agentToken = response.substring("token:".length());
            }
            catch (Exception exc) {
                exc.printStackTrace(SYSTEM_ERR);
                SYSTEM_ERR.println("- Error registering agent: " + exc.getMessage());
                continue;
            }
            break;
        }
        SYSTEM_OUT.println("- HQ gave us the following agent token");
        SYSTEM_OUT.println("    " + agentToken);
        SYSTEM_OUT.println("- Informing agent of new HQ server");
        ProviderInfo registeredProviderInfo = new ProviderInfo(provider, agentToken);
        if (isNewTransportAgent) {
            registeredProviderInfo.setNewTransport(unidirectional, unidirectionalPort);
        }
        this.camCommands.setProviderInfo(registeredProviderInfo);
        SYSTEM_OUT.println("- Validating");
        providerInfo = this.camCommands.getProviderInfo();
        if (providerInfo == null || !providerInfo.getProviderAddress().equals(provider) || !providerInfo.getAgentToken().equals(agentToken)) {
            if (providerInfo == null) {
                SYSTEM_ERR.println(" - Failure - Agent is reporting no HQ provider information");
            } else {
                SYSTEM_ERR.println("- Failure - Agent is using HQ server '" + providerInfo.getProviderAddress() + "' with token '" + providerInfo.getAgentToken() + "'");
            }
        } else {
            SYSTEM_OUT.println("- Successfully setup agent");
            if (providerInfo.isNewTransport()) {
                String unidirectionalPortString = "";
                if (providerInfo.isUnidirectional()) {
                    unidirectionalPortString = ", port=" + providerInfo.getUnidirectionalPort();
                }
                SYSTEM_OUT.println("- Agent using new transport, unidirectional=" + providerInfo.isUnidirectional() + unidirectionalPortString);
            }
        }
        this.redirectOutputs(bootP);
    }

    private boolean isUnidirectionalAgentSupported() {
        boolean isUnidirectionalSupported;
        block3: {
            isUnidirectionalSupported = false;
            String libPath = AgentConfig.PROP_BUNDLEHOME[1] + "/lib";
            try {
                File libDir = new File(libPath);
                if (!libDir.isDirectory()) break block3;
                File[] libFiles = libDir.listFiles();
                for (int i = 0; i < libFiles.length; ++i) {
                    String fileName = libFiles[i].getName().toLowerCase();
                    if (!fileName.startsWith("hqee-agent") || !fileName.endsWith(".jar")) continue;
                    isUnidirectionalSupported = true;
                    break;
                }
            }
            catch (Exception e) {
                this.log.info((Object)("Could not determine whether the agent supports unidirectional transport: " + e.getMessage()), (Throwable)e);
            }
        }
        return isUnidirectionalSupported;
    }

    /*
     * Loose catch block
     */
    private void verifyAgentRunning(ServerSocket startupSock) throws AgentInvokeException {
        block11: {
            Socket conn = startupSock.accept();
            DataInputStream dIs = new DataInputStream(conn.getInputStream());
            if (dIs.readInt() != 1) {
                throw new AgentInvokeException("Agent reported an error while starting up");
            }
            Object var5_7 = null;
            try {
                startupSock.close();
            }
            catch (IOException exc) {}
            break block11;
            {
                catch (InterruptedIOException exc) {
                    throw new AgentInvokeException("Timed out waiting for Agent to report startup success");
                }
                catch (IOException exc) {
                    throw new AgentInvokeException("Agent failure while starting");
                }
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                try {
                    startupSock.close();
                }
                catch (IOException exc) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        try {
            this.agtCommands.ping();
        }
        catch (Exception exc) {
            throw new AgentInvokeException("Unable to ping agent: " + exc.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void nukeAgentAndDie() {
        AgentClient agentClient = this;
        synchronized (agentClient) {
            if (this.nuking) {
                return;
            }
            this.nuking = true;
        }
        try {
            SYSTEM_ERR.println("Received interrupt while starting.  Shutting agent down ...");
            this.cmdDie(10);
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.exit(-1);
    }

    private void handleSIGINT() {
        try {
            Signal.handle(new Signal("INT"), new SignalHandler(){

                public void handle(Signal sig) {
                    AgentClient.this.nukeAgentAndDie();
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private PrintStream newLogStream(String stream, Properties bootProps) throws AgentConfigException, IOException {
        Logger logger = Logger.getLogger((String)stream);
        Level level = Level.toLevel((String)bootProps.getProperty("agent.startup.logLevel." + stream, bootProps.getProperty("agent.logLevel." + stream, DEFAULT_LOG_LEVEL)));
        PatternLayout layout = new PatternLayout(bootProps.getProperty("agent.startup.ConversionPattern", LOG_PATTERN_LAYOUT));
        RollingFileAppender fileAppender = new RollingFileAppender((Layout)layout, this.getStartupLogFile(bootProps), true);
        fileAppender.setImmediateFlush(true);
        fileAppender.setBufferedIO(false);
        fileAppender.setBufferSize(1024);
        fileAppender.setMaxFileSize(bootProps.getProperty("agent.startup.MaxFileSize", MAX_FILE_SIZE));
        fileAppender.setMaxBackupIndex(Integer.parseInt(bootProps.getProperty("agent.startup.MaxBackupIndex", MAX_FILES)));
        logger.addAppender((Appender)fileAppender);
        logger.setAdditivity(false);
        return new PrintStream(new LoggingOutputStream((Category)logger, (Priority)level), true);
    }

    private void redirectOutputs(Properties bootProp) {
        if (this.redirectedOutputs) {
            return;
        }
        this.redirectedOutputs = true;
        try {
            System.setErr(this.newLogStream("SystemErr", bootProp));
            System.setOut(this.newLogStream("SystemOut", bootProp));
        }
        catch (Exception e) {
            e.printStackTrace(SYSTEM_ERR);
        }
    }

    public static Thread getAgentDaemonThread() {
        return agentDaemonThread;
    }

    private int cmdStart(boolean force) throws AgentInvokeException {
        ProviderInfo providerInfo;
        ServerSocket startupSock;
        try {
            this.cmdPing(1);
            SYSTEM_OUT.println("Agent already running");
            return -1;
        }
        catch (AgentConnectionException exc) {
        }
        catch (AgentRemoteException exc) {
            // empty catch block
        }
        Properties bootProps = this.config.getBootProperties();
        try {
            int iSleepTime = AgentClient.getStartupTimeout(bootProps);
            startupSock = new ServerSocket(0);
            startupSock.setSoTimeout(iSleepTime);
        }
        catch (IOException e) {
            AgentInvokeException ex = new AgentInvokeException("Unable to setup a socket to listen for Agent startup: " + e);
            ex.initCause(e);
            throw ex;
        }
        SYSTEM_OUT.println("- Invoking agent");
        try {
            this.config.setNotifyUpPort(startupSock.getLocalPort());
        }
        catch (AgentConfigException e) {
            throw new AgentInvokeException("Invalid notify up port: " + startupSock.getLocalPort());
        }
        AgentDaemon.RunnableAgent runnableAgent = new AgentDaemon.RunnableAgent(this.config);
        agentDaemonThread = new Thread(runnableAgent);
        agentDaemonThread.setName("AgentDaemonMain");
        AgentUpgradeManager.setAgentDaemonThread((Thread)agentDaemonThread);
        AgentUpgradeManager.setAgent((AgentLifecycle)runnableAgent);
        agentDaemonThread.setDaemon(true);
        agentDaemonThread.start();
        SYSTEM_OUT.println("- Agent thread running");
        SYSTEM_OUT.println("- Verifying if agent is running...");
        this.verifyAgentRunning(startupSock);
        SYSTEM_OUT.println("- Agent is running");
        try {
            providerInfo = this.camCommands.getProviderInfo();
        }
        catch (Exception exc) {
            throw new AgentInvokeException("Unexpected connection exception: agent is still running");
        }
        SYSTEM_OUT.println("Agent successfully started");
        if (providerInfo == null && !WrapperManager.isControlledByNativeWrapper()) {
            SYSTEM_OUT.println();
            return -42;
        }
        this.redirectOutputs(bootProps);
        return 0;
    }

    private static void cmdSetProp(String propKey, String propVal) throws AgentConfigException {
        AgentClient.ensurePropertiesEncryption();
        try {
            String propEncKey = PropertyEncryptionUtil.getPropertyEncryptionKey((String)AgentConfig.DEFAULT_PROP_ENC_KEY_FILE);
            String propFile = System.getProperty("agent.propFile", AgentConfig.DEFAULT_PROPFILE);
            HashMap<String, String> entriesToStore = new HashMap<String, String>();
            entriesToStore.put(propKey, propVal);
            PropertyUtil.storeProperties((String)propFile, (String)propEncKey, entriesToStore);
        }
        catch (Exception exc) {
            throw new AgentConfigException((Throwable)exc);
        }
    }

    private String getStartupLogFile(Properties bootProps) throws AgentConfigException {
        String logFile = bootProps.getProperty(PROP_LOGFILE);
        if (logFile == null) {
            throw new AgentConfigException("agent.logFile is undefined");
        }
        return logFile + ".startup";
    }

    private static int getStartupTimeout(Properties bootProps) {
        int iSleepTime = 300000;
        String sleepTime = bootProps.getProperty(PROP_STARTUP_TIMEOUT);
        try {
            iSleepTime = Integer.parseInt(sleepTime) * 1000;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return iSleepTime;
    }

    private static int getUseTime(String val) {
        try {
            return Integer.parseInt(val);
        }
        catch (NumberFormatException exc) {
            return 1;
        }
    }

    private static AgentClient initializeAgent(boolean generateToken) throws AgentConfigException {
        String connIp;
        AgentConfig cfg;
        AgentClient.ensurePropertiesEncryption();
        final String propFile = System.getProperty("agent.propFile", AgentConfig.DEFAULT_PROPFILE);
        BasicConfigurator.configure();
        try {
            cfg = AgentConfig.newInstance((String)propFile);
        }
        catch (IOException exc) {
            SYSTEM_ERR.println("Error: " + exc);
            return null;
        }
        catch (AgentConfigException exc) {
            SYSTEM_ERR.println("Agent Properties error: " + exc.getMessage());
            return null;
        }
        Properties bootProps = cfg.getBootProperties();
        if (!AgentClient.checkCanWriteToLog(bootProps)) {
            return null;
        }
        PropertyConfigurator.configure((Properties)bootProps);
        FileWatcherThread watcherThread = FileWatcherThread.getInstance();
        FileWatcher loggingWatcher = new FileWatcher(new Sigar()){
            {
                super(x0);
                File[] files = AgentConfig.getPropertyFiles((String)propFile);
                for (int i = 0; i < files.length; ++i) {
                    try {
                        this.add(files[i]);
                        continue;
                    }
                    catch (SigarException e) {
                        SYSTEM_ERR.println("Error adding watcher for " + files[i]);
                    }
                }
                this.setInterval(60000L);
            }

            public void onChange(FileInfo fileInfo) {
                try {
                    SYSTEM_OUT.println("Change detected in " + fileInfo.getName() + ", reloading logging configuration");
                    PropertyConfigurator.configure((Properties)AgentConfig.getProperties((String)propFile));
                }
                catch (AgentConfigException e) {
                    SYSTEM_ERR.println("Error reloading logging configuration: " + e.getMessage());
                    e.printStackTrace(SYSTEM_ERR);
                }
            }
        };
        watcherThread.add(loggingWatcher);
        watcherThread.doStart();
        String listenIp = cfg.getListenIp();
        try {
            connIp = listenIp.equals("*") ? "127.0.0.1" : InetAddress.getByName(listenIp).getHostAddress();
        }
        catch (UnknownHostException exc) {
            SYSTEM_ERR.println("Failed to lookup agent address '" + listenIp + "'");
            return null;
        }
        AgentKeystoreConfig keystoreConfig = new AgentKeystoreConfig();
        String tokenFile = cfg.getTokenFile();
        if (generateToken) {
            String authToken;
            try {
                authToken = AgentClientUtil.getLocalAuthToken(tokenFile);
            }
            catch (FileNotFoundException exc) {
                SYSTEM_ERR.print("- Unable to load agent token file.  Generating a new one ... ");
                try {
                    String nToken = SecurityUtil.generateRandomToken();
                    AgentClientUtil.generateNewTokenFile(tokenFile, nToken);
                    authToken = AgentClientUtil.getLocalAuthToken(tokenFile);
                }
                catch (IOException oexc) {
                    SYSTEM_ERR.println("Unable to setup preliminary agent auth tokens: " + exc.getMessage());
                    return null;
                }
                SYSTEM_ERR.println("Done");
            }
            catch (IOException exc) {
                SYSTEM_ERR.println("Unable to get necessary authentication tokens to talk to agent: " + exc.getMessage());
                return null;
            }
            SecureAgentConnection conn = new SecureAgentConnection(connIp, cfg.getListenPort(), authToken, (KeystoreConfig)keystoreConfig, keystoreConfig.isAcceptUnverifiedCert());
            return new AgentClient(cfg, conn);
        }
        long initializeStartTime = System.currentTimeMillis();
        long startupTimeout = AgentClient.getStartupTimeout(bootProps);
        while (initializeStartTime > System.currentTimeMillis() - startupTimeout) {
            try {
                String authToken = AgentClientUtil.getLocalAuthToken(tokenFile);
                SecureAgentConnection conn = new SecureAgentConnection(connIp, cfg.getListenPort(), authToken, (KeystoreConfig)keystoreConfig, keystoreConfig.isAcceptUnverifiedCert());
                return new AgentClient(cfg, conn);
            }
            catch (FileNotFoundException exc) {
                SYSTEM_ERR.println("- No token file found, waiting for Agent to initialize");
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    SYSTEM_ERR.println("Interrupted! Shutting down");
                    return null;
                }
            }
            catch (IOException e) {
                SYSTEM_ERR.println("Unable to read preliminary agent auth tokens, waiting for Agent to initialize (error was: " + e.getMessage() + ")");
            }
        }
        SYSTEM_ERR.println("Timeout waiting for token file");
        return null;
    }

    public static void main(String[] args) {
        block23: {
            if (args.length == 3 && args[0].equals(SET_PROPERTY)) {
                try {
                    AgentClient.cmdSetProp(args[1], args[2]);
                }
                catch (AgentConfigException e) {
                    SYSTEM_ERR.println("Error: " + e.getMessage());
                    e.printStackTrace(SYSTEM_ERR);
                }
                return;
            }
            if (!(args.length >= 1 && (args[0].equals(PING) || args[0].equals(DIE) || args[0].equals(START) || args[0].equals(STATUS) || args[0].equals(RESTART) || args[0].equals(SETUP) || args[0].equals(SETUP_IF_NO_PROVIDER)))) {
                SYSTEM_ERR.println("Syntax: program <ping [numAttempts] | die [dieTime] | start | status | restart | setup | setup-if-no-provider | set-property >");
                return;
            }
            try {
                AgentClient client;
                if (args[0].equals(START)) {
                    PropertyEncryptionUtil.unlock((boolean)true);
                    client = AgentClient.initializeAgent(true);
                } else {
                    client = AgentClient.initializeAgent(false);
                }
                if (client == null) {
                    return;
                }
                if (args[0].equals(PING)) {
                    int nWait = args.length == 3 ? AgentClient.getUseTime(args[2]) : 1;
                    client.cmdPing(nWait);
                    break block23;
                }
                if (args[0].equals(DIE)) {
                    int nWait = args.length == 2 ? AgentClient.getUseTime(args[1]) : 1;
                    SYSTEM_OUT.println("Stopping agent ... ");
                    try {
                        client.cmdDie(nWait);
                        SYSTEM_OUT.println("Success -- agent is stopped!");
                    }
                    catch (Exception exc) {
                        SYSTEM_OUT.println("Failed to stop agent: " + exc.getMessage());
                    }
                    break block23;
                }
                if (args[0].equals(START)) {
                    int errVal = client.cmdStart(false);
                    if (errVal == -42) {
                        errVal = 0;
                        client.cmdSetupIfNoProvider();
                    }
                    break block23;
                }
                if (args[0].equals(STATUS)) {
                    client.cmdStatus();
                    break block23;
                }
                if (args[0].equals(SETUP)) {
                    client.cmdSetup();
                    break block23;
                }
                if (args[0].equals(SETUP_IF_NO_PROVIDER)) {
                    client.cmdSetupIfNoProvider();
                    break block23;
                }
                if (args[0].equals(RESTART)) {
                    client.cmdRestart();
                    break block23;
                }
                throw new IllegalStateException("Unhandled condition");
            }
            catch (AutoQuestionException exc) {
                SYSTEM_ERR.println("Unable to automatically setup: " + exc.getMessage());
            }
            catch (AgentInvokeException exc) {
                SYSTEM_ERR.println("Error invoking agent: " + exc.getMessage());
            }
            catch (AgentConnectionException exc) {
                SYSTEM_ERR.println("Error contacting agent: " + exc.getMessage());
            }
            catch (AgentRemoteException exc) {
                SYSTEM_ERR.println("Error executing remote method: " + (Object)((Object)exc));
            }
            catch (Exception exc) {
                SYSTEM_ERR.println("Error: " + exc.getMessage());
                exc.printStackTrace(SYSTEM_ERR);
            }
        }
    }

    private static void ensurePropertiesEncryption() throws AgentConfigException {
        String propFile = System.getProperty("agent.propFile", AgentConfig.DEFAULT_PROPFILE);
        AgentConfig.ensurePropertiesEncryption((String)propFile);
    }

    private static boolean checkCanWriteToLog(Properties props) {
        String logFileName = props.getProperty(PROP_LOGFILE);
        if (logFileName == null) {
            SYSTEM_ERR.println("agent.logFile not set. \nCannot start HQ agent.");
            return false;
        }
        File logFile = new File(logFileName);
        File logDir = logFile.getParentFile();
        if (!logDir.exists() && !logDir.mkdirs()) {
            SYSTEM_ERR.println("Log directory does not exist and could not be created: " + logDir.getAbsolutePath() + "\nCannot start HQ agent.");
            return false;
        }
        if (!logDir.canWrite()) {
            SYSTEM_ERR.println("Cannot write to log directory: " + logDir.getAbsolutePath() + "\nMake sure this directory is owned by user '" + System.getProperty("user.name") + "' and is " + "not a read-only directory." + "\nCannot start HQ agent.");
            return false;
        }
        if (logFile.exists() && !logFile.canWrite()) {
            SYSTEM_ERR.println("Cannot write to log file: " + logFile.getAbsolutePath() + "\nMake sure this file is owned by user '" + System.getProperty("user.name") + "' and is " + "not a read-only file." + "\nCannot start HQ agent.");
            return false;
        }
        return true;
    }

    private static String normalizeClassPath(String s) {
        return StringUtil.replace((String)s, (String)":", (String)File.pathSeparator);
    }

    private class AutoQuestionException
    extends Exception {
        AutoQuestionException(String s) {
            super(s);
        }
    }
}

