/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.bizapp.agent.client;

import org.hyperic.hq.agent.AgentConnectionException;
import org.hyperic.hq.agent.AgentRemoteException;
import org.hyperic.hq.agent.AgentRemoteValue;
import org.hyperic.hq.agent.client.AgentConnection;
import org.hyperic.hq.bizapp.agent.CommandsAPIInfo;
import org.hyperic.hq.bizapp.agent.ProviderInfo;
import org.hyperic.hq.bizapp.agent.commands.CreateToken_args;
import org.hyperic.hq.bizapp.agent.commands.CreateToken_result;
import org.hyperic.hq.bizapp.agent.commands.GetServer_args;
import org.hyperic.hq.bizapp.agent.commands.GetServer_result;
import org.hyperic.hq.bizapp.agent.commands.SetServer_args;
import org.hyperic.hq.bizapp.agent.commands.SetServer_result;

public class CommandsClient {
    private AgentConnection agentConn;
    private CommandsAPIInfo verAPI;

    public CommandsClient(AgentConnection agentConn) {
        this.agentConn = agentConn;
        this.verAPI = new CommandsAPIInfo();
    }

    public CreateToken_result createToken(CreateToken_args args) throws AgentRemoteException, AgentConnectionException {
        AgentRemoteValue rval = this.agentConn.sendCommand("bizapp:createToken", this.verAPI.getVersion(), (AgentRemoteValue)args);
        return new CreateToken_result(rval);
    }

    public ProviderInfo getProviderInfo() throws AgentRemoteException, AgentConnectionException {
        GetServer_args args = new GetServer_args();
        AgentRemoteValue rval = this.agentConn.sendCommand("bizapp:getCAMServer", this.verAPI.getVersion(), (AgentRemoteValue)args);
        GetServer_result res = new GetServer_result(rval);
        return res.getProvider();
    }

    public void setProviderInfo(ProviderInfo provider) throws AgentRemoteException, AgentConnectionException {
        SetServer_args args = new SetServer_args();
        args.setProvider(provider);
        AgentRemoteValue rval = this.agentConn.sendCommand("bizapp:setCAMServer", this.verAPI.getVersion(), (AgentRemoteValue)args);
        SetServer_result res = new SetServer_result(rval);
    }
}

