/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.bizapp.client;

import org.hyperic.hq.bizapp.agent.ProviderInfo;
import org.hyperic.hq.bizapp.client.AgentCallbackClient;
import org.hyperic.hq.bizapp.client.AgentCallbackClientException;
import org.hyperic.hq.bizapp.client.ProviderFetcher;
import org.hyperic.hq.bizapp.shared.lather.MeasurementGetConfigs_args;
import org.hyperic.hq.bizapp.shared.lather.MeasurementGetConfigs_result;
import org.hyperic.hq.bizapp.shared.lather.MeasurementSendReport_args;
import org.hyperic.hq.bizapp.shared.lather.MeasurementSendReport_result;
import org.hyperic.hq.bizapp.shared.lather.TopNSendReport_args;
import org.hyperic.hq.bizapp.shared.lather.TrackSend_args;
import org.hyperic.hq.measurement.data.MeasurementReport;
import org.hyperic.hq.measurement.data.TrackEventReport;
import org.hyperic.hq.measurement.shared.MeasurementConfigList;
import org.hyperic.lather.LatherRemoteException;
import org.hyperic.lather.LatherValue;

public class MeasurementCallbackClient
extends AgentCallbackClient {
    public MeasurementCallbackClient(ProviderFetcher fetcher) {
        super(fetcher);
    }

    public long measurementSendReport(MeasurementReport report) throws AgentCallbackClientException {
        ProviderInfo provider = this.getProvider();
        MeasurementSendReport_args args = new MeasurementSendReport_args();
        args.setReport(report);
        MeasurementSendReport_result res = (MeasurementSendReport_result)this.invokeLatherCall(provider, "measurementSendReport", (LatherValue)args);
        try {
            return res.getTime();
        }
        catch (LatherRemoteException exc) {
            throw new AgentCallbackClientException("Unable to get return value from send report: " + (Object)((Object)exc), exc);
        }
    }

    private void trackSend(String cmd, TrackEventReport report) throws AgentCallbackClientException {
        TrackSend_args args = new TrackSend_args();
        ProviderInfo provider = this.getProvider();
        args.setType(1);
        args.setEvents(report);
        this.invokeLatherCall(provider, cmd, (LatherValue)args);
    }

    public void trackSendLog(TrackEventReport report) throws AgentCallbackClientException {
        this.trackSend("trackSendLog", report);
    }

    public void trackSendConfigChange(TrackEventReport report) throws AgentCallbackClientException {
        this.trackSend("trackSendConfigChange", report);
    }

    public MeasurementConfigList getMeasurementConfigs() throws AgentCallbackClientException {
        ProviderInfo provider = this.getProvider();
        MeasurementGetConfigs_args args = new MeasurementGetConfigs_args();
        MeasurementGetConfigs_result res = (MeasurementGetConfigs_result)this.invokeLatherCall(provider, "measurementGetConfigs", (LatherValue)args);
        try {
            return res.getConfigs();
        }
        catch (LatherRemoteException exc) {
            throw new AgentCallbackClientException("Error getting plugin configs: " + (Object)((Object)exc), exc);
        }
    }

    public void topNSendReport(TopNSendReport_args report) throws AgentCallbackClientException {
        ProviderInfo provider = this.getProvider();
        this.invokeLatherCall(provider, "topNSendReport", (LatherValue)report);
    }
}

