/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.transport;

import java.lang.reflect.Constructor;
import java.net.InetSocketAddress;
import java.util.HashMap;
import org.hyperic.hq.transport.PollerClient;
import org.hyperic.hq.transport.util.TransportUtils;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.transporter.TransporterServer;

public class AgentTransport {
    private final Object _lock = new Object();
    private final PollerClient _pollerClient;
    private final TransporterServer _server;
    private final boolean _unidirectional;
    private final InvokerLocator _remoteEndpointLocator;
    private boolean _stopped;

    public AgentTransport(InetSocketAddress serverTransportAddr, String path, boolean encrypted, String agentToken, boolean unidirectional, long pollingFrequency, int asyncThreadPoolSize) throws Exception {
        this._unidirectional = unidirectional;
        if (!this._unidirectional) {
            Object remotingServerInvokerLocator = null;
            this._remoteEndpointLocator = null;
            throw new UnsupportedOperationException("bidirectional not supported yet");
        }
        this._pollerClient = this.createPollerClient(serverTransportAddr, path, encrypted, pollingFrequency, agentToken, asyncThreadPoolSize);
        InvokerLocator remotingServerInvokerLocator = this.getLocalInvokerLocator();
        this._remoteEndpointLocator = this._pollerClient.getRemoteEndpointLocator();
        this._server = TransporterServer.createTransporterServer((InvokerLocator)remotingServerInvokerLocator, (Object)new BootStrapService());
    }

    public InvokerLocator getRemoteEndpointLocator() {
        return this._remoteEndpointLocator;
    }

    private PollerClient createPollerClient(InetSocketAddress serverTransportAddr, String path, boolean encrypted, long pollingFrequency, String agentToken, int asyncThreadPoolSize) throws ClassNotFoundException, Exception {
        Class clazz;
        try {
            clazz = TransportUtils.tryLoadUnidirectionalTransportPollerClient();
        }
        catch (ClassNotFoundException e) {
            throw new ClassNotFoundException("Unidirectional transport is not available in .ORG");
        }
        Constructor constructor = clazz.getConstructor(InetSocketAddress.class, String.class, Boolean.TYPE, Long.TYPE, String.class, Integer.TYPE);
        return (PollerClient)constructor.newInstance(serverTransportAddr, path, encrypted, new Long(pollingFrequency), agentToken, new Integer(asyncThreadPoolSize));
    }

    public void registerService(Class serviceInterface, Object serviceImpl) throws Exception {
        this.verifyServiceImplementsInterface(serviceInterface, serviceImpl);
        this._server.addHandler(serviceImpl, serviceInterface.getName());
    }

    public void updateAgentToken(String agentToken) {
        if (agentToken == null) {
            throw new NullPointerException("agent token is null");
        }
        this._pollerClient.updateAgentToken(agentToken);
    }

    public void start() throws Exception {
        if (this.isStopped()) {
            return;
        }
        this._server.start();
        if (this._unidirectional) {
            this._pollerClient.start();
        }
    }

    public void stop() throws InterruptedException {
        if (this._unidirectional) {
            this._pollerClient.stop();
        }
        this._server.stop();
        this.setStopped();
    }

    private InvokerLocator getLocalInvokerLocator() {
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("timestamp", String.valueOf(System.currentTimeMillis()));
        return new InvokerLocator("local", "localhost", -1, null, params);
    }

    private void verifyServiceImplementsInterface(Class serviceInterface, Object serviceImpl) {
        Class<?>[] interfaces = serviceImpl.getClass().getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            Class<?> interfaceClazz = interfaces[i];
            if (!interfaceClazz.equals(serviceInterface)) continue;
            return;
        }
        throw new IllegalArgumentException("service: " + serviceImpl.getClass() + " does not implement interface: " + serviceInterface);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setStopped() {
        Object object = this._lock;
        synchronized (object) {
            this._stopped = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isStopped() {
        Object object = this._lock;
        synchronized (object) {
            return this._stopped;
        }
    }

    private static class BootStrapService {
        private BootStrapService() {
        }

        void doNothing() {
        }
    }
}

