/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.cm.versioncontrol.impl;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.jgit.JGitText;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.CommitCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.NoFilepatternException;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheBuildIterator;
import org.eclipse.jgit.dircache.DirCacheBuilder;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.errors.AmbiguousObjectException;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.NoWorkTreeException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryBuilder;
import org.eclipse.jgit.revwalk.FollowFilter;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;
import org.eclipse.jgit.treewalk.filter.AndTreeFilter;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.hyperic.cm.versioncontrol.api.IVersionControlDao;
import org.hyperic.cm.versioncontrol.dto.RevisionDiffItem;
import org.hyperic.cm.versioncontrol.impl.CompiledRevisionInfo;
import org.hyperic.cm.versioncontrol.impl.MapPersister;
import org.hyperic.cm.versioncontrol.jgit.AddAllCommand;
import org.hyperic.cm.versioncontrol.jgit.ExtendedFileTreeIterator;
import org.hyperic.cm.versioncontrol.jgit.FileDiff;
import org.hyperic.cm.versioncontrol.jgit.ZipfileTreeIterator;
import org.hyperic.cm.versioncontrol.util.ArchiveUtils;
import org.hyperic.cm.versioncontrol.util.PairOfLong;
import org.hyperic.cm.versioncontrol.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitTemplate
implements IVersionControlDao {
    static Logger logger = LoggerFactory.getLogger(GitTemplate.class);
    private static final String GIT_DIR = ".git";
    private static final int DEFAULT_PAGE_SIZE = -1;
    private Set<String> binaryExtSet = null;
    private Thread mapPersisterThread;
    private Long fileCount = 0L;
    private Long zipFileCount = 0L;
    private final Map<String, Repository> repositoryMap = new HashMap<String, Repository>();
    private final Map<String, PairOfLong> fileInfoMap = new TreeMap<String, PairOfLong>();
    private String extMonitoredInArchive;

    public GitTemplate() {
        try {
            Properties props = Utils.getPropertiesFromClasspath(this.getClass(), "vc-config.properties");
            String binaryExt = props.getProperty("vc.binary.ext");
            if (binaryExt != null && binaryExt.length() > 0) {
                String[] extArray = binaryExt.split(",");
                List<String> extList = extArray == null || extArray.length == 0 ? null : Arrays.asList(extArray);
                this.binaryExtSet = extList == null ? null : new HashSet<String>(extList);
            }
            String ext = props.getProperty("vc.archiveMonitoredExt");
            this.setExtMonitoredInArchive(ext);
        }
        catch (IOException e) {
            logger.error("Properties file not loaded, " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public boolean createRepository(String gitDirBase) {
        Repository repository;
        File gitLoc;
        File git = new File(this.getGitDir(gitDirBase));
        MapPersister mapPersister = new MapPersister(this.fileInfoMap, gitDirBase);
        mapPersister.init(!git.exists());
        this.mapPersisterThread = new Thread((Runnable)mapPersister, MapPersister.class.getName());
        this.mapPersisterThread.start();
        if (git.exists() && (gitLoc = new File(git.getPath() + File.separator + "index.loc")).exists()) {
            gitLoc.delete();
        }
        if (this.gitDirExists(gitDirBase)) {
            return true;
        }
        if (gitDirBase == null) {
            return false;
        }
        File f = new File(gitDirBase);
        if (!this.gitDirExists(gitDirBase)) {
            Utils.recursiveCreateDir(gitDirBase);
            if (!f.exists() && !f.mkdir()) {
                logger.error("Failure creating repository git Dir folder: " + gitDirBase);
                return false;
            }
        }
        if ((repository = this.openRepository(gitDirBase)) == null) {
            return false;
        }
        try {
            repository.create();
        }
        catch (IOException e) {
            logger.error("Error creating repository " + e.getMessage(), (Throwable)e);
            return false;
        }
        this.closeRepositoryTransaction(gitDirBase);
        return true;
    }

    public Repository openRepository(String gitDirBase) {
        String gitDir = this.getGitDir(gitDirBase);
        Repository repository = this.repositoryMap.get(gitDirBase);
        if (repository != null) {
            return repository;
        }
        RepositoryBuilder builder = new RepositoryBuilder();
        File fGitDir = new File(gitDir);
        try {
            ((RepositoryBuilder)((RepositoryBuilder)builder.setGitDir(fGitDir)).readEnvironment()).findGitDir();
            repository = builder.build();
        }
        catch (IOException e) {
            logger.error("Error opening repository " + e.getMessage(), (Throwable)e);
            return null;
        }
        this.repositoryMap.put(gitDirBase, repository);
        return repository;
    }

    private String getGitDir(String gitDirBase) {
        return gitDirBase + File.separator + GIT_DIR;
    }

    public void closeRepositoryTransaction(String gitDir) {
        Repository r = this.repositoryMap.get(gitDir);
        if (r == null) {
            return;
        }
        this.repositoryMap.remove(gitDir);
        r.close();
    }

    public void closeRepositoryTransaction(Repository repository) {
        String gitDir = repository.getDirectory().getAbsolutePath();
        Repository r = this.repositoryMap.get(gitDir);
        if (r == null) {
            return;
        }
        this.repositoryMap.remove(gitDir);
        r.close();
    }

    public RevCommit doCommit(Repository repository, String message) {
        Git git = new Git(repository);
        CommitCommand commit = git.commit();
        commit.setMessage(message);
        try {
            RevCommit c = commit.call();
            return c;
        }
        catch (Exception e) {
            logger.error("Error in commit" + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public String[] doRename(String gitDir, String oldPath, String newPath, String message) {
        DirCache dc = this.commitRenameFile(gitDir, newPath, oldPath, message);
        String ret = dc == null ? "" : this.commit(gitDir, message);
        return new String[]{ret};
    }

    protected Collection<String> getCumulativeDirs(String path) {
        if (path.length() <= 0) {
            return Collections.emptyList();
        }
        StringBuffer sb = new StringBuffer(path.length());
        ArrayList<String> paths = new ArrayList<String>();
        for (int i = 0; i < path.length(); ++i) {
            Character c = Character.valueOf(path.charAt(i));
            sb.append(c);
            if (c.charValue() != File.separatorChar && i != path.length() - 1) continue;
            paths.add(sb.toString());
        }
        return paths;
    }

    @Override
    public String addChange(String gitDir, String path, String commitMessage) {
        return this.addChange(gitDir, path, null, commitMessage, true);
    }

    @Override
    public String addChange(String gitDir, Collection<String> paths, String commitMessage, boolean performCommit) {
        boolean retVal = false;
        ArrayList<String> changedFiles = new ArrayList<String>();
        for (String path : paths) {
            retVal = this.addToMap(path);
            if (!retVal) continue;
            changedFiles.add(path);
        }
        if (changedFiles.size() <= 0) {
            return null;
        }
        retVal = this.commitChangeFile(gitDir, changedFiles, false);
        if (retVal && performCommit) {
            return this.commit(gitDir, "multiple files changed.");
        }
        return !retVal ? null : String.valueOf(retVal);
    }

    private boolean addToMap(String path) {
        File file = new File(path);
        long lastModified = file.lastModified();
        long fileSize = file.length();
        PairOfLong info = this.fileInfoMap.get(path);
        if (info != null && ((Long)info.getKey()).equals(lastModified) && ((Long)info.getValue()).equals(fileSize) && file.exists()) {
            logger.info("Date and size unchanged, skipping - " + path);
            return false;
        }
        this.fileInfoMap.put(path, new PairOfLong(lastModified, fileSize));
        return true;
    }

    @Override
    public String addChange(String gitDir, String path, String oldPath, String commitMessage, boolean performCommit) {
        if (!this.addToMap(path) && oldPath == null) {
            return null;
        }
        File file = new File(path);
        boolean retVal = false;
        String comment = commitMessage + ";" + file.lastModified() + ";" + file.length() + ";" + file.getName();
        if (!file.exists()) {
            retVal = this.commitChangeFile(gitDir, Arrays.asList(path), true);
            this.deleteFromInfoMap(path);
        } else if (oldPath != null) {
            retVal = this.commitRenameFile(gitDir, path, oldPath, comment) != null;
            this.deleteFromInfoMap(oldPath);
        } else {
            retVal = this.commitChangeFile(gitDir, Arrays.asList(path), false);
        }
        if (retVal && performCommit) {
            return this.commit(gitDir, comment);
        }
        return retVal ? comment : null;
    }

    private void deleteFromInfoMap(String toRemove) {
        PairOfLong o = this.fileInfoMap.remove(toRemove);
        if (o != null) {
            return;
        }
        String path = toRemove.endsWith(File.pathSeparator) ? toRemove : toRemove + File.separator;
        o = this.fileInfoMap.remove(path);
        if (o != null) {
            return;
        }
        LinkedList<String> toDelete = new LinkedList<String>();
        for (String s : this.fileInfoMap.keySet()) {
            if (!s.startsWith(path) || new File(s).exists()) continue;
            toDelete.add(s);
        }
        for (String s : toDelete) {
            this.fileInfoMap.remove(s);
        }
    }

    private ObjectId getLastObjectId(String path, Repository repository) throws AmbiguousObjectException, IOException {
        RevWalk rw = new RevWalk(repository);
        ObjectId objHead = repository.resolve("HEAD");
        if (objHead == null) {
            logger.error("Repository missing or coruppeted - HEAD not found");
            return null;
        }
        rw.markStart(rw.parseCommit((AnyObjectId)objHead));
        PathFilter pathFilter = PathFilter.create((String)Utils.formatPath(path));
        rw.setTreeFilter((TreeFilter)pathFilter);
        for (RevCommit c : rw) {
            FileDiff[] diffs = this.getChangeInfo(c, repository, (TreeFilter)pathFilter, true);
            if (diffs == null || diffs.length <= 0) continue;
            ObjectId[] ids = diffs[0].getBlobs();
            if (ids == null || ids.length <= 0) {
                return null;
            }
            if (ids.length > 1 && !ids[1].equals((AnyObjectId)ObjectId.zeroId())) {
                return ids[1];
            }
            if (!ids[0].equals((AnyObjectId)ObjectId.zeroId())) {
                return ids[0];
            }
            return null;
        }
        rw.dispose();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DirCache commitRenameFile(String gitDir, String path, String oldPath, String commitMessage) {
        Repository repository = this.openRepository(gitDir);
        if (repository == null) {
            logger.error("Repository missing or coruppeted in " + gitDir);
            return null;
        }
        UpdateInfo uInfo = new UpdateInfo(repository);
        try {
            File file = new File(path);
            ObjectId id = this.getLastObjectId(oldPath, repository);
            if (id == null) {
                logger.error("Rename aborted, object id is null for old path " + oldPath);
                DirCache dirCache = null;
                return dirCache;
            }
            uInfo.init();
            DirCache dc2 = this.call(oldPath, uInfo, true, null, 0L, 0L, null);
            uInfo.commit();
            uInfo.init();
            DirCache dc = this.call(path, oldPath, uInfo, false, null, file.length(), file.lastModified(), FileMode.REGULAR_FILE, id);
            uInfo.commit();
            if (dc == null) {
                logger.warn("Return value null for rename call create phase");
            }
            if (dc2 == null) {
                logger.warn("Return value null for rename call delete phase");
            }
            uInfo.release();
            DirCache dirCache = dc;
            return dirCache;
        }
        catch (AmbiguousObjectException e2) {
            logger.error(e2.getMessage(), (Throwable)e2);
        }
        catch (IOException e2) {
            logger.error(e2.getMessage(), (Throwable)e2);
        }
        catch (NoWorkTreeException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            this.closeRepositoryTransaction(gitDir);
        }
        return null;
    }

    private boolean commitChangeFile(String gitDir, Collection<String> paths, boolean setUpdateFlag) {
        Repository repository = this.openRepository(gitDir);
        AddCommand addFile = null;
        String currRoot = null;
        AddCommand add = null;
        for (String path : paths) {
            String formattedPath = Utils.formatPath(path);
            String root = Utils.getRoot(formattedPath);
            String zipPath = formattedPath;
            if (path.startsWith("/")) {
                root = "/" + root;
                zipPath = "/" + zipPath;
            }
            if (ArchiveUtils.isZipArchive(formattedPath)) {
                if (add != null && add instanceof AddAllCommand) {
                    this.callAdd(add);
                }
                ZipfileTreeIterator zipTreeIterator = new ZipfileTreeIterator(repository, zipPath);
                zipTreeIterator.setIncludedExtensions(this.getExtMonitoredInArchive());
                add = this.initAddcommand(new AddAllCommand(repository), zipTreeIterator);
            } else {
                if (add != null && add instanceof AddAllCommand) {
                    this.callAdd(add);
                }
                if (addFile == null || !root.equals(currRoot)) {
                    addFile = this.initAddcommand(new AddCommand(repository), new ExtendedFileTreeIterator(repository, root));
                    currRoot = root;
                }
                add = addFile;
            }
            add.addFilepattern(formattedPath);
            add.setUpdate(setUpdateFlag);
        }
        if (add != null && add != addFile) {
            this.callAdd(add);
        }
        if (addFile != null) {
            this.callAdd(addFile);
        }
        return true;
    }

    private boolean callAdd(AddCommand add) {
        WorkingTreeIterator it;
        boolean res = false;
        try {
            res = add.call() != null;
        }
        catch (NoFilepatternException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        if (add instanceof AddAllCommand && (it = ((AddAllCommand)add).getWorkingTreeIterator()) instanceof ZipfileTreeIterator) {
            ZipfileTreeIterator zipIt = (ZipfileTreeIterator)it;
            this.addZipFileCount(zipIt.getFileCount());
            try {
                zipIt.closeStream();
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return res;
    }

    private AddCommand initAddcommand(AddCommand addCommand, ExtendedFileTreeIterator fileTreeIterator) {
        fileTreeIterator.setExtensionsForMd5(this.binaryExtSet);
        addCommand.setWorkingTreeIterator((WorkingTreeIterator)fileTreeIterator);
        return addCommand;
    }

    public boolean isBinary(String path) {
        if (this.binaryExtSet == null || this.binaryExtSet.size() <= 0 || path == null || path.length() <= 0) {
            return false;
        }
        return this.binaryExtSet.contains(Utils.getFileExtension(Utils.fileName(path)));
    }

    @Override
    public String commit(String gitDir, String commitMessage) {
        if (logger.isDebugEnabled()) {
            logger.debug("---BENCHMARK--- commit start");
        }
        Repository repository = this.openRepository(gitDir);
        String id = null;
        RevCommit rc = this.doCommit(repository, commitMessage);
        id = rc == null ? null : ObjectId.toString((ObjectId)rc.getId());
        this.closeRepositoryTransaction(repository);
        if (logger.isDebugEnabled()) {
            logger.debug("---BENCHMARK--- commit end");
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileDiff[] compareRevisionToHead(String revId, String gitDir, String filepath) {
        Repository repository = this.openRepository(gitDir);
        if (repository == null) {
            logger.error("Repository missing or coruppeted in " + gitDir);
            return null;
        }
        String path = filepath == null ? null : Utils.formatPath(filepath);
        RevWalk rw = null;
        try {
            ObjectId objHead = repository.resolve("HEAD");
            if (objHead == null) {
                logger.error("Repository missing or coruppeted - HEAD not found in " + gitDir);
                FileDiff[] fileDiffArray = null;
                return fileDiffArray;
            }
            ObjectId objRev = ObjectId.fromString((String)revId);
            if (objRev == null) {
                logger.error("Revision to compare not found in " + gitDir);
                FileDiff[] fileDiffArray = null;
                return fileDiffArray;
            }
            rw = new RevWalk(repository);
            RevCommit head = rw.parseCommit((AnyObjectId)objHead);
            RevCommit comparedRev = rw.parseCommit((AnyObjectId)objRev);
            TreeWalk tw = new TreeWalk(repository);
            if (path != null && path.length() > 0) {
                tw.setFilter(AndTreeFilter.create((TreeFilter)PathFilter.create((String)path), (TreeFilter)TreeFilter.ANY_DIFF));
            } else {
                tw.setFilter(TreeFilter.ANY_DIFF);
            }
            FileDiff[] fileDiffArray = FileDiff.compute(tw, head, comparedRev, true);
            return fileDiffArray;
        }
        catch (AmbiguousObjectException e2) {
            logger.error(e2.getMessage(), (Throwable)e2);
        }
        catch (IOException e2) {
            logger.error(e2.getMessage(), (Throwable)e2);
        }
        finally {
            if (rw != null) {
                rw.dispose();
            }
            this.closeRepositoryTransaction(gitDir);
        }
        return null;
    }

    @Override
    public List<CompiledRevisionInfo> getRevisionsForPath(Collection<String> filepaths, String gitDir, boolean changesOnly) {
        return this.getRevisionsForPath(filepaths, gitDir, changesOnly, null, null, null, -1);
    }

    @Override
    public List<CompiledRevisionInfo> getRevisionsForPath(Collection<String> filepaths, String gitDir, boolean changesOnly, int pageSize) {
        return this.getRevisionsForPath(filepaths, gitDir, changesOnly, null, null, null, pageSize);
    }

    @Override
    public List<CompiledRevisionInfo> getRevisionsForPath(Collection<String> filepaths, String gitDir, boolean changesOnly, String revision, int pageSize) {
        return this.getRevisionsForPath(filepaths, gitDir, changesOnly, null, null, revision, pageSize);
    }

    @Override
    public List<CompiledRevisionInfo> getRevisionsForPath(Collection<String> filepaths, String gitDir, boolean changesOnly, Long startDate) {
        return this.getRevisionsForPath(filepaths, gitDir, changesOnly, startDate, null, null, -1);
    }

    @Override
    public List<CompiledRevisionInfo> getRevisionsForPath(Collection<String> filepaths, String gitDir, boolean changesOnly, Long startDate, Long endDate) {
        return this.getRevisionsForPath(filepaths, gitDir, changesOnly, startDate, endDate, null, -1);
    }

    @Override
    public List<CompiledRevisionInfo> getRevisionsForPath(Collection<String> filepaths, String gitDir, boolean changesOnly, Long startDate, Long endDate, int pageSize) {
        return this.getRevisionsForPath(filepaths, gitDir, changesOnly, startDate, endDate, null, pageSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<CompiledRevisionInfo> getRevisionsForPath(Collection<String> filepaths, String gitDir, boolean changesOnly, Long startDate, Long endDate, String revision, int pageSize) {
        ArrayList<CompiledRevisionInfo> commitList = new ArrayList<CompiledRevisionInfo>();
        Repository repository = this.openRepository(gitDir);
        if (repository == null) {
            logger.error("Repository missing or coruppeted in " + gitDir);
            return commitList;
        }
        RevWalk rw = new RevWalk(repository);
        try {
            ObjectId objHead = repository.resolve(revision != null ? revision : "HEAD");
            if (objHead == null) {
                logger.error("Repository missing or coruppeted - HEAD not found in " + gitDir);
                ArrayList<CompiledRevisionInfo> arrayList = commitList;
                return arrayList;
            }
            rw.markStart(rw.parseCommit((AnyObjectId)objHead));
            TreeFilter pathFilter = this.getTreeFilter(filepaths);
            if (pathFilter != null) {
                rw.setTreeFilter(pathFilter);
            } else {
                rw.setTreeFilter(TreeFilter.ALL);
            }
            int pageCounter = 0;
            for (RevCommit c : rw) {
                FileDiff[] diffs;
                if (pageSize > 0 && pageCounter >= pageSize) break;
                if (!this.isCommitInDateRange(c, startDate, endDate) || (diffs = this.getChangeInfo(c, repository, pathFilter, changesOnly)) == null) continue;
                CompiledRevisionInfo info = new CompiledRevisionInfo(c);
                for (FileDiff fd : diffs) {
                    info.addDiff(fd);
                }
                commitList.add(info);
            }
            rw.dispose();
        }
        catch (AmbiguousObjectException e2) {
            logger.error(e2.getMessage(), (Throwable)e2);
        }
        catch (IOException e2) {
            logger.error(e2.getMessage(), (Throwable)e2);
        }
        finally {
            this.closeRepositoryTransaction(gitDir);
        }
        return commitList;
    }

    private TreeFilter getTreeFilter(Collection<String> filepaths) {
        TreeFilter pathFilter = null;
        if (filepaths != null && filepaths.size() > 0) {
            ArrayList<String> paths = new ArrayList<String>();
            for (String filepath : filepaths) {
                String path = filepath == null ? null : Utils.formatPath(filepath);
                if (path == null || path.length() <= 0) continue;
                paths.add(path);
            }
            if (paths.size() > 0) {
                pathFilter = PathFilterGroup.createFromStrings(paths);
            }
        }
        return pathFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<RevisionDiffItem> getChangeInfo(String revId, String gitDir, Collection<String> filepaths) throws IOException {
        ArrayList<RevisionDiffItem> commitList = new ArrayList<RevisionDiffItem>();
        Repository repository = this.openRepository(gitDir);
        if (repository == null) {
            logger.error("Repository missing or corrupted in " + gitDir);
            return commitList;
        }
        RevWalk rw = new RevWalk(repository);
        try {
            ObjectId objHead = repository.resolve("HEAD");
            if (objHead == null) {
                logger.error("Repository missing or coruppeted - HEAD not found in " + gitDir);
                ArrayList<RevisionDiffItem> arrayList = commitList;
                return arrayList;
            }
            rw.markStart(rw.parseCommit((AnyObjectId)objHead));
            TreeFilter pathFilter = this.getTreeFilter(filepaths);
            if (pathFilter != null) {
                rw.setTreeFilter(AndTreeFilter.create((TreeFilter)pathFilter, (TreeFilter)TreeFilter.ALL));
            } else {
                rw.setTreeFilter(TreeFilter.ALL);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("---BENCHMARK--- getChangeInfo before loop");
            }
            for (RevCommit c : rw) {
                String cId = c.getId().toString();
                if (!cId.contains(revId)) continue;
                FileDiff[] diffs = this.getChangeInfo(c, repository, pathFilter, true);
                if (diffs == null) break;
                for (FileDiff fd : diffs) {
                    commitList.add(new RevisionDiffItem(fd));
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug("---BENCHMARK--- getChangeInfo after loop");
            }
            rw.dispose();
        }
        catch (AmbiguousObjectException e2) {
            logger.error(e2.getMessage(), (Throwable)e2);
        }
        catch (IOException e2) {
            logger.error(e2.getMessage(), (Throwable)e2);
        }
        finally {
            this.closeRepositoryTransaction(gitDir);
        }
        return commitList;
    }

    private FileDiff[] getChangeInfo(RevCommit c, Repository repository, TreeFilter pathFilter, boolean changesOnly) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug("---BENCHMARK--- FileDiff[] getChangeInfo start");
        }
        TreeWalk tw = new TreeWalk(repository);
        if (logger.isDebugEnabled()) {
            logger.debug("---BENCHMARK--- FileDiff[] getChangeInfo after treewalk create");
        }
        if (pathFilter != null) {
            tw.setFilter(AndTreeFilter.create((TreeFilter)pathFilter, (TreeFilter)TreeFilter.ANY_DIFF));
        } else {
            tw.setFilter(TreeFilter.ANY_DIFF);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("---BENCHMARK--- getChangeInfo before compute");
        }
        FileDiff[] diffs = FileDiff.compute(tw, c, null, true);
        if (logger.isDebugEnabled()) {
            logger.debug("---BENCHMARK--- getChangeInfo after compute");
        }
        if ((diffs == null || diffs.length <= 0) && changesOnly) {
            return null;
        }
        return diffs;
    }

    private boolean isCommitInDateRange(RevCommit commit, Long startDate, Long endDate) {
        long time = commit.getCommitTime() * 1000;
        boolean inRange = true;
        inRange &= startDate == null ? true : time >= startDate;
        return inRange &= endDate == null ? true : time <= endDate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getFileByRevision(String gitDir, String revId) {
        Repository repository = this.openRepository(gitDir);
        if (repository == null) {
            logger.error("Repository missing or coruppeted in " + gitDir);
            return null;
        }
        ObjectId objId = ObjectId.fromString((String)revId);
        byte[] bytes = null;
        try {
            ObjectLoader loader = repository.open((AnyObjectId)objId, 3);
            bytes = loader.getCachedBytes(Integer.MAX_VALUE);
        }
        catch (MissingObjectException e) {
            logger.error("Error retreiving revision: " + e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            logger.error("Error retreiving revision: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.closeRepositoryTransaction(gitDir);
        }
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String outputDiff(String gitDir, String[] blobIds, FileMode[] fileModes, String path) {
        if (blobIds == null || blobIds.length < 2) {
            logger.error("Number of object ids to compare is smaller than 2");
            return null;
        }
        final StringBuilder sb = new StringBuilder();
        Repository repository = this.openRepository(gitDir);
        try {
            ObjectId[] objIds = new ObjectId[]{ObjectId.fromString((String)blobIds[0]), ObjectId.fromString((String)blobIds[1])};
            DiffFormatter formatter = new DiffFormatter(new BufferedOutputStream(new ByteArrayOutputStream(){

                public synchronized void write(byte[] b, int off, int len) {
                    super.write(b, off, len);
                    sb.append(this.toString());
                    this.reset();
                }
            })){};
            if (logger.isDebugEnabled()) {
                logger.debug("---BENCHMARK--- before outputDiff");
            }
            FileDiff.outputDiff(sb, repository, formatter, objIds, fileModes, path);
            if (logger.isDebugEnabled()) {
                logger.debug("---BENCHMARK--- after outputDiff");
            }
            formatter.flush();
            String string = sb.toString();
            return string;
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            this.closeRepositoryTransaction(gitDir);
        }
        return null;
    }

    @Override
    public String getDiff(String gitDir, RevisionDiffItem revItem1, RevisionDiffItem revItem2) {
        if (revItem1.getFileModeBits() == null || revItem2.getFileModeBits() == null) {
            logger.error("File mode null");
            return null;
        }
        String[] ids = new String[]{revItem1.getId(), revItem2.getId()};
        FileMode fileMode1 = FileMode.fromBits((int)revItem1.getFileModeBits());
        FileMode fileMode2 = FileMode.fromBits((int)revItem2.getFileModeBits());
        FileMode[] modes = new FileMode[]{fileMode1, fileMode2};
        String diff = this.outputDiff(gitDir, ids, modes, revItem1.getPath());
        return diff;
    }

    @Override
    public String getLastChangeDiff(String gitDir, RevisionDiffItem revItem) {
        if (revItem == null) {
            logger.error("Revision item null");
            return null;
        }
        if (revItem.getFileModeBits() == null) {
            logger.error("File mode null");
            return null;
        }
        String[] ids = new String[]{revItem.getPrevVersionId(), revItem.getId()};
        FileMode fileMode1 = FileMode.fromBits((int)revItem.getFileModeBits());
        FileMode fileMode2 = FileMode.fromBits((int)revItem.getPrevVersionFileModeBits());
        FileMode[] modes = new FileMode[]{fileMode2, fileMode1};
        String diff = this.outputDiff(gitDir, ids, modes, revItem.getPath());
        if (this.isBinary(revItem.getPath()) && diff != null && diff.length() > 0) {
            return revItem.getPath() + "\n@@ 0,0 0,0 @@\nBinary file changed";
        }
        return diff;
    }

    @Override
    public String getStatus(String dirPath, Collection<RevisionDiffItem> items) {
        if (logger.isDebugEnabled()) {
            logger.debug("---BENCHMARK--- getStatus start");
        }
        int offset = Utils.formatPath(dirPath).length() + 1;
        String status = dirPath + "\n";
        for (RevisionDiffItem item : items) {
            status = status + String.format("%s\t%s\n", Character.valueOf(item.getChangeType().name().charAt(0)), item.getPath().substring(offset));
        }
        if (logger.isDebugEnabled()) {
            logger.debug("---BENCHMARK--- getStatus end");
        }
        return status;
    }

    @Override
    public boolean gitDirExists(String gitDirBase) {
        String dir = this.getGitDir(gitDirBase);
        File f = new File(dir);
        return f.exists() && f.isDirectory();
    }

    private DirCache call(String pathForGit, UpdateInfo updateInfo, boolean addBody, InputStream is, long size, long lastModified, FileMode fileMode) {
        return this.call(pathForGit, null, updateInfo, addBody, is, size, lastModified, fileMode, null);
    }

    private DirCache call(String pathForGit, String oldPath, UpdateInfo updateInfo, boolean isDelete, InputStream is, long size, long lastModified, FileMode fileMode, ObjectId id) {
        try {
            String formattedPath = Utils.formatPath(pathForGit);
            if (oldPath != null && oldPath.length() > 0) {
                updateInfo.addTreeFilter((TreeFilter)FollowFilter.create((String)formattedPath));
                updateInfo.addTreeFilter((TreeFilter)FollowFilter.create((String)Utils.formatPath(oldPath)));
            } else {
                updateInfo.addTreeFilter((TreeFilter)PathFilter.create((String)formattedPath));
            }
            if (!isDelete) {
                DirCacheBuilder builder = updateInfo.getBuilder();
                DirCacheEntry entry = new DirCacheEntry(formattedPath);
                entry.setLength(size);
                entry.setLastModified(lastModified);
                entry.setFileMode(fileMode);
                if (id != null) {
                    entry.setObjectId((AnyObjectId)id);
                } else {
                    entry.setObjectId((AnyObjectId)updateInfo.getInserter().insert(3, size, is));
                }
                builder.add(entry);
            }
        }
        catch (IOException e) {
            throw new JGitInternalException(JGitText.get().exceptionCaughtDuringExecutionOfAddCommand, (Throwable)e);
        }
        return updateInfo.getDirCache();
    }

    public Long getFileCount() {
        return this.fileCount;
    }

    public void setFileCount(Long fileCount) {
        this.fileCount = fileCount;
    }

    public void addFileCount(Long fileCount) {
        GitTemplate gitTemplate = this;
        gitTemplate.fileCount = gitTemplate.fileCount + fileCount;
    }

    public Long getZipFileCount() {
        return this.zipFileCount;
    }

    public void setZipFileCount(Long zipFileCount) {
        this.zipFileCount = zipFileCount;
    }

    public void addZipFileCount(Long zipFileCount) {
        GitTemplate gitTemplate = this;
        gitTemplate.zipFileCount = gitTemplate.zipFileCount + zipFileCount;
        if (logger.isDebugEnabled()) {
            logger.debug("Added: " + zipFileCount + " total: " + this.zipFileCount);
        }
    }

    public String getExtMonitoredInArchive() {
        return this.extMonitoredInArchive;
    }

    @Override
    public void setExtMonitoredInArchive(String extMonitoredInArchive) {
        this.extMonitoredInArchive = extMonitoredInArchive;
    }

    public void onDestroy() {
        if (this.mapPersisterThread != null) {
            this.mapPersisterThread.interrupt();
        }
    }

    private class UpdateInfo {
        private Repository repository;
        private ObjectInserter inserter;
        private DirCacheBuilder builder;
        private DirCache dirCache;
        private Collection<TreeFilter> filters = new ArrayList<TreeFilter>();

        public UpdateInfo(Repository repository) {
            this.repository = repository;
        }

        public void init() throws NoWorkTreeException, CorruptObjectException, IOException {
            this.inserter = this.repository.newObjectInserter();
            this.dirCache = this.repository.lockDirCache();
            this.builder = this.dirCache.builder();
        }

        public void addTreeFilter(TreeFilter filter) {
            this.filters.add(filter);
        }

        private TreeFilter getFilter() {
            if (this.filters.size() <= 0) {
                return null;
            }
            if (this.filters.size() == 1) {
                return this.filters.iterator().next();
            }
            TreeFilter[] filterArr = new TreeFilter[this.filters.size()];
            int i = 0;
            Iterator<TreeFilter> i$ = this.filters.iterator();
            while (i$.hasNext()) {
                TreeFilter f;
                filterArr[i] = f = i$.next();
                ++i;
            }
            return AndTreeFilter.create((TreeFilter[])filterArr);
        }

        public void commit() throws IOException {
            TreeWalk tw = new TreeWalk(this.repository);
            tw.addTree((AbstractTreeIterator)new DirCacheBuildIterator(this.builder));
            tw.setRecursive(true);
            TreeFilter tf = this.getFilter();
            if (tf != null) {
                tw.setFilter(tf);
            }
            while (tw.next()) {
            }
            this.inserter.flush();
            this.builder.commit();
        }

        public void release() {
            this.inserter.release();
            if (this.dirCache != null) {
                this.dirCache.unlock();
            }
        }

        public DirCacheBuilder getBuilder() {
            return this.builder;
        }

        public ObjectInserter getInserter() {
            return this.inserter;
        }

        public DirCache getDirCache() {
            return this.dirCache;
        }
    }
}

