/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.activemq;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.management.MBeanServerConnection;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.ServerResource;
import org.hyperic.hq.product.ServiceResource;
import org.hyperic.hq.product.jmx.MxServerDetector;
import org.hyperic.util.config.ConfigResponse;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActiveMQServerDetector
extends MxServerDetector {
    private Log log = LogFactory.getLog(ActiveMQServerDetector.class);
    private static final String HOME = "-Dactivemq.home=";
    private static final String BASE = "-Dactivemq.base=";

    protected List getServerProcessList() {
        ArrayList<MxServerDetector.MxProcess> procs = new ArrayList<MxServerDetector.MxProcess>();
        String query = "State.Name.sw=java,Args.*.sw=-Dactivemq.base=";
        long[] pids = ActiveMQServerDetector.getPids((String)query);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("ptql='" + query + "' matched pids=" + this.asList(pids)));
        }
        for (int i = 0; i < pids.length; ++i) {
            long pid = pids[i];
            String[] args = ActiveMQServerDetector.getProcArgs((long)pid);
            String path = null;
            for (int j = 0; j < args.length; ++j) {
                int ix;
                String arg = args[j];
                if (!arg.startsWith(BASE) || (ix = arg.indexOf(61)) == -1) continue;
                path = arg.substring(ix + 1);
                break;
            }
            if (path == null) continue;
            MxServerDetector.MxProcess process = new MxServerDetector.MxProcess(pid, args, path);
            procs.add(process);
        }
        return procs;
    }

    protected ServerResource createServerResource(String installpath) {
        ServerResource server = super.createServerResource(installpath);
        this.log.debug((Object)("[createServerResource] installpath=" + installpath));
        XPathFactory xpathFactory = XPathFactory.newInstance();
        XPath xpath = xpathFactory.newXPath();
        try {
            File cfg = new File(installpath, "conf/activemq.xml");
            this.log.debug((Object)("[createServerResource] cfg=" + cfg));
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = builder.parse(cfg);
            String bName = xpath.evaluate("/beans/broker/@brokerName", document);
            System.out.println("bName=" + bName);
            server.setName(server.getName() + " " + bName);
        }
        catch (Exception ex) {
            this.log.debug((Object)("[createServerResource] Error when looking for the broker name: " + ex.getMessage()), (Throwable)ex);
        }
        return server;
    }

    protected List discoverMxServices(MBeanServerConnection mServer, ConfigResponse serverConfig) throws PluginException {
        List services = super.discoverMxServices(mServer, serverConfig);
        String type = this.getTypeInfo().getName();
        String serverName = ActiveMQServerDetector.getPlatformName() + " " + type;
        for (int i = 0; i < services.size(); ++i) {
            ServiceResource service = (ServiceResource)services.get(i);
            service.setName(service.getName().replaceAll("%serverName%", serverName));
        }
        return services;
    }

    protected boolean isInstallTypeVersion(MxServerDetector.MxProcess process) {
        String dir = null;
        for (int j = 0; j < process.getArgs().length; ++j) {
            int ix;
            String arg = process.getArgs()[j];
            if (!arg.startsWith(HOME) || (ix = arg.indexOf(61)) == -1) continue;
            dir = arg.substring(ix + 1);
            break;
        }
        if (dir == null) {
            return false;
        }
        return this.isInstallTypeVersion(dir);
    }

    protected String getProcQuery(String path) {
        return "State.Name.sw=java,Args.*.eq=-Dactivemq.base=" + path;
    }

    private List<Long> asList(long[] input) {
        ArrayList<Long> list = new ArrayList<Long>();
        for (long value : input) {
            list.add(value);
        }
        return list;
    }
}

