/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vfabric.hyperic.plugin.vfgf;

import com.google.common.collect.BiMap;
import com.google.common.util.concurrent.AbstractExecutionThreadService;
import com.vmware.vfabric.hyperic.plugin.vfgf.cache.MemberCache;
import com.vmware.vfabric.hyperic.plugin.vfgf.cache.MemberInfo;
import com.vmware.vfabric.hyperic.plugin.vfgf.mx.GFJmxConnection;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MemberUpdater
extends AbstractExecutionThreadService {
    private static final Log log = LogFactory.getLog(MemberUpdater.class);
    private MemberCache memberCache;
    private Properties config;

    public MemberUpdater(MemberCache memberCache) {
        this.memberCache = memberCache;
    }

    public void refreshCacheVMs(Properties config) {
        if (this.config != null) {
            log.debug((Object)"Config exists, skipping refresh:");
            return;
        }
        this.config = config;
        log.debug((Object)("Service status:" + this.isRunning()));
        log.debug((Object)"Asking updater to start the task");
        this.start();
    }

    protected void run() throws Exception {
        while (this.isRunning()) {
            try {
                this.updateMembers();
            }
            catch (Exception e) {
                log.debug((Object)("[run] Exception in MemberUpdater: " + e.toString()));
            }
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                log.debug((Object)"[run] Got interrupt, continue...");
            }
        }
        log.debug((Object)"[run] Exiting");
    }

    private void updateMembers() {
        log.debug((Object)("Check if we need to update members with config:" + this.config));
        if (this.config == null) {
            return;
        }
        log.debug((Object)"Doing member cache update");
        GFJmxConnection gf = new GFJmxConnection(this.config);
        MemberInfo[] cMembers = gf.getCacheVmMembers();
        MemberInfo[] aMembers = gf.getSystemMemberApplications();
        BiMap<String, MemberInfo> cacheVMMap = this.memberCache.getCacheVMMap();
        cacheVMMap.clear();
        for (MemberInfo memberInfo : cMembers) {
            cacheVMMap.put((Object)memberInfo.getGfid(), (Object)memberInfo);
        }
        for (MemberInfo memberInfo : aMembers) {
            cacheVMMap.put((Object)memberInfo.getGfid(), (Object)memberInfo);
        }
        log.debug((Object)"Members updated");
        this.config = null;
    }
}

