/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vfabric.hyperic.plugin.vfgf.cache;

import com.google.common.collect.MapMaker;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetricCache {
    private long metricCacheLastUpdate = 0L;
    private ConcurrentMap<String, Double> metricCache;
    private ConcurrentMap<String, Double> trackCache;
    private boolean memberOnline = false;
    private Object trackLock = new Object();

    public MetricCache() {
        this.metricCache = new MapMaker().makeMap();
        this.trackCache = new MapMaker().expireAfterAccess(3600L, TimeUnit.SECONDS).makeMap();
    }

    public long getMetricCacheLastUpdate() {
        return this.metricCacheLastUpdate;
    }

    public void setMetricCacheLastUpdate(long metricCacheLastUpdate) {
        this.metricCacheLastUpdate = metricCacheLastUpdate;
    }

    public boolean isMemberOnline() {
        return this.memberOnline;
    }

    public void setMemberOnline(boolean memberOnline) {
        this.memberOnline = memberOnline;
    }

    public ConcurrentMap<String, Double> getMetricCache() {
        return this.metricCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getTrackKeySet() {
        Object object = this.trackLock;
        synchronized (object) {
            try {
                return this.trackCache.keySet().toArray(new String[0]);
            }
            catch (Exception exception) {
                return new String[0];
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putToTrackCache(String alias, Double value) {
        Object object = this.trackLock;
        synchronized (object) {
            this.trackCache.put(alias, value);
        }
    }
}

