/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vfabric.hyperic.plugin.vfgf.metric;

import com.vmware.vfabric.hyperic.plugin.vfgf.GFProductPlugin;
import com.vmware.vfabric.hyperic.plugin.vfgf.detector.GF7PlatformDetector;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.product.Metric;
import org.hyperic.hq.product.MetricNotFoundException;
import org.hyperic.hq.product.MetricUnreachableException;
import org.hyperic.hq.product.MetricValue;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.jmx.MxMeasurementPlugin;
import org.hyperic.hq.product.jmx.MxUtil;

public class GF7MeasurementPlugin
extends MxMeasurementPlugin {
    private static final Log log = LogFactory.getLog(GF7MeasurementPlugin.class);
    private static String PROP_LOCATORS = "locators";
    private static String JMX_USERNAME = "jmx.username";
    private static String JMX_PASSWORD = "jmx.password";
    private static String last_signature = new String();

    public MetricValue getValue(Metric metric) throws PluginException, MetricNotFoundException, MetricUnreachableException {
        MetricValue val;
        Properties props = metric.getProperties();
        String template = metric.toString();
        String locators = props.getProperty(PROP_LOCATORS);
        String jmxUsername = props.getProperty(JMX_USERNAME);
        String jmxPassword = props.getProperty(JMX_PASSWORD);
        if (locators == null) {
            throw new MetricUnreachableException("Locators not configured");
        }
        if (jmxUsername == null) {
            jmxUsername = "";
        }
        if (jmxPassword == null) {
            jmxPassword = "";
        }
        String locatorsEncoded = Metric.encode((String)locators);
        String jmxUrl = GFProductPlugin.getJmxUrl(locators);
        if (jmxUrl.isEmpty()) {
            throw new MetricUnreachableException("Unable to find jmx.url from " + locators);
        }
        String jmxConfig = "jmx.url=" + jmxUrl + ",jmx.username=" + jmxUsername + ",jmx.password=" + jmxPassword;
        log.debug((Object)("[getValue] jmxConfig=" + jmxConfig));
        String newTemplate = StringUtils.replace((String)template, (String)("locators=" + locatorsEncoded), (String)jmxConfig);
        Metric newMetric = Metric.parse((String)newTemplate);
        if (newMetric.isAvail()) {
            Set<Object> names = new HashSet();
            String objName = "GemFire:type=Member,member=*";
            JMXConnector connector = null;
            try {
                connector = MxUtil.getMBeanConnector((Properties)newMetric.getProperties());
                MBeanServerConnection mServer = connector.getMBeanServerConnection();
                names = mServer.queryNames(new ObjectName(objName), null);
            }
            catch (MalformedObjectNameException e) {
                log.debug((Object)("[getServerResources] " + e.getMessage()), (Throwable)e);
            }
            catch (IOException e) {
                log.debug((Object)("[getServerResources] " + e.getMessage()), (Throwable)e);
            }
            String signature = Arrays.asList(names).toString();
            if (!signature.equals(last_signature)) {
                last_signature = signature;
                log.debug((Object)("[getValue] Membership change detected. Forcing new auto discovery. Old=" + last_signature + ", new=" + signature));
                GF7PlatformDetector.runAutoDiscovery(locators);
            }
        }
        try {
            val = super.getValue(newMetric);
        }
        catch (Exception e) {
            log.debug((Object)("[getValue] " + e.getMessage()), (Throwable)e);
            GFProductPlugin.resetJmxUrl();
            try {
                MxUtil.getMBeanConnector((Properties)metric.getProperties()).close();
            }
            catch (MalformedURLException e1) {
                throw new MetricUnreachableException(e1.getMessage(), (Throwable)e1);
            }
            catch (IOException e1) {
                throw new MetricUnreachableException(e1.getMessage(), (Throwable)e);
            }
            throw new MetricUnreachableException(e.getMessage(), (Throwable)e);
        }
        return val;
    }
}

