/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vfabric.hyperic.plugin.vfgf.metric;

import com.vmware.vfabric.hyperic.plugin.vfgf.GFProductPlugin;
import com.vmware.vfabric.hyperic.plugin.vfgf.cache.MemberCache;
import com.vmware.vfabric.hyperic.plugin.vfgf.cache.MemberInfo;
import com.vmware.vfabric.hyperic.plugin.vfgf.metric.GFMeasurementPlugin;
import com.vmware.vfabric.hyperic.plugin.vfgf.mx.GFJmxConnection;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.product.Metric;
import org.hyperic.hq.product.MetricNotFoundException;
import org.hyperic.hq.product.MetricUnreachableException;
import org.hyperic.hq.product.MetricValue;
import org.hyperic.hq.product.PluginException;

public class GFApplicationPeerMeasurementPlugin
extends GFMeasurementPlugin {
    private static final Log log = LogFactory.getLog(GFApplicationPeerMeasurementPlugin.class);

    public MetricValue getValue(Metric metric) throws PluginException, MetricNotFoundException, MetricUnreachableException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Plugin hash id:" + ((Object)((Object)this)).hashCode()));
            log.debug((Object)("Metric:" + metric.toDebugString()));
        }
        Properties mProps = metric.getObjectProperties();
        MemberCache memberCache = ((GFProductPlugin)this.getProductPlugin()).getMemberCache(mProps.getProperty("jmx.url"));
        String workingDirectory = mProps.getProperty("workingDirectory");
        String host = mProps.getProperty("host");
        String name = mProps.getProperty("name");
        boolean needMemberUpdate = false;
        double value = 0.0;
        GFJmxConnection gf = new GFJmxConnection(mProps);
        MemberInfo member = memberCache.getMember(workingDirectory == null ? "" : workingDirectory, host, name);
        if (member == null) {
            needMemberUpdate = true;
        } else {
            String gfid = member.getGfid();
            try {
                Map<String, Object> map = gf.getApplicationAttributes(gfid, new String[]{"id"});
                if (map.containsKey("id")) {
                    value = 1.0;
                }
            }
            catch (Exception e) {
                needMemberUpdate = true;
            }
        }
        if (needMemberUpdate) {
            memberCache.refresh(mProps);
        }
        if (log.isDebugEnabled()) {
            if (member == null) {
                log.debug((Object)"[getValue] member is null");
            } else {
                log.debug((Object)("[getValue] for " + member.getGfid() + " is " + value));
            }
        }
        return new MetricValue(value);
    }
}

