/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vfabric.hyperic.plugin.vfgf.util;

import com.vmware.vfabric.hyperic.plugin.vfgf.util.JmxManagerInfo;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.hyperic.hq.agent.AgentKeystoreConfig;
import org.hyperic.util.security.DefaultSSLProviderImpl;
import org.hyperic.util.security.KeystoreConfig;

public class JmxManagerFinder {
    private static final Log log = LogFactory.getLog(JmxManagerFinder.class);
    private static final short JMX_MANAGER_LOCATOR_REQUEST = 2150;
    private static final short JMX_MANAGER_LOCATOR_RESPONSE = 2151;
    private static final byte DS_FIXED_ID_SHORT = 2;
    private static final int GOSSIPVERSION = 1001;
    private static final byte STRING_BYTES = 87;
    private static final byte NULL_STRING = 69;
    private static AgentKeystoreConfig keystoreConfig;

    public static JmxManagerInfo getJmxManager(String locators) {
        String[] locArray = locators.split(",");
        if (locArray.length > 3) {
            log.warn((Object)"More than 3 locators defined. This could lead to issues");
        }
        for (String loc : locArray) {
            String[] address = loc.split(":");
            try {
                InetAddress addr = InetAddress.getByName(address[0]);
                return JmxManagerFinder.askLocatorForJmxManager(addr, Integer.parseInt(address[1]), 10000, false);
            }
            catch (UnknownHostException e) {
                log.debug((Object)("[getJmxManager] Unable to connect to " + address[0] + ":" + address[1] + ": " + e.getMessage()), (Throwable)e);
            }
            catch (NumberFormatException e) {
                log.debug((Object)("[getJmxManager] Invalid Port:" + address[1] + ": " + e.getMessage()), (Throwable)e);
            }
            catch (IOException e) {
                log.debug((Object)("[getJmxManager] Unable to connect to " + address[0] + ":" + address[1] + ": " + e.getMessage()), (Throwable)e);
            }
        }
        return null;
    }

    public static String getJmxUrl(String locators) {
        JmxManagerInfo info = JmxManagerFinder.getJmxManager(locators);
        if (info == null) {
            return null;
        }
        return "service:jmx:rmi:///jndi/rmi://" + info.getHost() + ":" + info.getPort() + "/jmxrmi";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JmxManagerInfo askLocatorForJmxManager(InetAddress addr, int port, int timeout, boolean isSsl) throws IOException {
        Socket sock;
        InetSocketAddress sockaddr = new InetSocketAddress(addr, port);
        if (isSsl) {
            keystoreConfig = new AgentKeystoreConfig();
            boolean accept = true;
            DefaultSSLProviderImpl sslProvider = new DefaultSSLProviderImpl((KeystoreConfig)keystoreConfig, accept);
            SSLSocketFactory factory = sslProvider.getSSLSocketFactory();
            sock = factory.createSocket();
        } else {
            sock = new Socket();
        }
        try {
            String host;
            sock.connect(sockaddr, timeout);
            sock.setSoTimeout(timeout);
            DataOutputStream out = new DataOutputStream(sock.getOutputStream());
            out.writeInt(1001);
            out.writeByte(2);
            out.writeShort(2150);
            out.flush();
            DataInputStream in = new DataInputStream(sock.getInputStream());
            byte header = in.readByte();
            if (header != 2) {
                throw new IllegalStateException("Expected 2 but found " + header);
            }
            short msgType = in.readShort();
            if (msgType != 2151) {
                throw new IllegalStateException("Expected 2151 but found " + msgType);
            }
            byte hostHeader = in.readByte();
            if (hostHeader == 69) {
                host = "";
            } else if (hostHeader == 87) {
                String str;
                int len = in.readUnsignedShort();
                byte[] buf = new byte[len];
                in.readFully(buf, 0, len);
                host = str = new String(buf, 0);
            } else {
                throw new IllegalStateException("Expected 87 or 69 but found " + hostHeader);
            }
            int jmport = in.readInt();
            boolean ssl = in.readBoolean();
            if (host.equals("")) {
                jmport = 0;
            }
            JmxManagerInfo jmxManagerInfo = new JmxManagerInfo(host, jmport, ssl);
            return jmxManagerInfo;
        }
        catch (IllegalStateException e) {
            JmxManagerInfo jmxManagerInfo;
            if (!isSsl) {
                log.debug((Object)("[askLocatorForJmxManager] Exception Caught while trying to connect to " + addr.getHostName() + ":" + port));
                log.debug((Object)("[askLocatorForJmxManager] Retrying with SSL (this is expected if it GF is using SSL)" + e.getMessage()), (Throwable)e);
                jmxManagerInfo = JmxManagerFinder.askLocatorForJmxManager(addr, port, timeout, true);
                return jmxManagerInfo;
            }
            jmxManagerInfo = null;
            return jmxManagerInfo;
        }
        finally {
            try {
                sock.close();
            }
            catch (Exception e) {}
        }
    }
}

